/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.common;

import com.pingidentity.sdk.api.authn.spec.AuthnErrorSpec;

public class CommonErrorSpec {
    public static final AuthnErrorSpec RESOURCE_NOT_FOUND = new AuthnErrorSpec.Builder().httpStatus(404).code("RESOURCE_NOT_FOUND").message("The requested resource was not found.").build();
    public static final AuthnErrorSpec INVALID_REQUEST = new AuthnErrorSpec.Builder().httpStatus(400).code("INVALID_REQUEST").message("The request was malformed or invalid.").build();
    public static final AuthnErrorSpec VALIDATION_ERROR = new AuthnErrorSpec.Builder().httpStatus(400).code("VALIDATION_ERROR").message("One or more validation errors occurred.").userMessageKey("authn.api.validation.error").build();
    public static final AuthnErrorSpec UNEXPECTED_ERROR = new AuthnErrorSpec.Builder().httpStatus(500).code("UNEXPECTED_ERROR").message("An unexpected error occurred while processing the request.").build();
    public static final AuthnErrorSpec INVALID_ACTION_ID = new AuthnErrorSpec.Builder().httpStatus(400).code("INVALID_ACTION_ID").message("The provided action ID is not valid for the current state of the flow.").build();
    public static final AuthnErrorSpec REGISTRATION_FAILED = new AuthnErrorSpec.Builder().httpStatus(400).code("REGISTRATION_FAILED").message("An error occurred while attempting to register the user.").build();
    public static final AuthnErrorSpec REQUEST_FAILED = new AuthnErrorSpec.Builder().httpStatus(400).code("REQUEST_FAILED").message("The request could not be completed. There was an issue processing the request.").build();
}

