/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.internal;

import com.pingidentity.sdk.api.authn.internal.AuthnApiEnvironment;
import com.pingidentity.sdk.api.authn.internal.AuthnApiFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalAuthnApiSupport {
    private static final Log log = LogFactory.getLog(InternalAuthnApiSupport.class);
    private static final InternalAuthnApiSupport instance = new InternalAuthnApiSupport();
    private static final String KEY_AUTHN_API_OAUTH_FLOW_ID = "IAAS.AuthnAPIOAuthFlowID";
    private static final String KEY_HANDLER_PATH = "IAAS.HandlerPath";
    private static final String ATTR_STATE_PARAMS = "IAAS.StateParams";
    private static final String ATTR_REISSUE_REQUEST = "IAAS.ReissueRequest";
    private static final String ATTR_REQUEST_BODY_CONSUMED = "AAS.ApiRequest.BodyConsumed";

    public static InternalAuthnApiSupport getDefault() {
        return instance;
    }

    public boolean isRequestBodyConsumed(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(ATTR_REQUEST_BODY_CONSUMED));
    }

    public void setRequestBodyConsumed(HttpServletRequest request) {
        request.setAttribute(ATTR_REQUEST_BODY_CONSUMED, (Object)Boolean.TRUE);
    }

    public void setReissueRequest(HttpServletRequest req, HttpServletResponse resp, boolean reissue) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting flag to reissue request to " + reissue));
        }
        if (reissue) {
            this.overrideResponseCommitted(resp, true);
            req.setAttribute(ATTR_REISSUE_REQUEST, (Object)true);
        } else {
            this.overrideResponseCommitted(resp, false);
            req.removeAttribute(ATTR_REISSUE_REQUEST);
        }
    }

    public boolean isReissueRequest(HttpServletRequest req) {
        Boolean val = (Boolean)req.getAttribute(ATTR_REISSUE_REQUEST);
        if (val == null) {
            return false;
        }
        return val;
    }

    public void saveHandlerPath(HttpServletRequest req, String handlerPath) {
        Map<String, Object> stateParams = this.getStateParams(req);
        if (stateParams == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Handler path is not being saved as state params not found in request (likely not an API request)");
            }
            return;
        }
        stateParams.put(KEY_HANDLER_PATH, handlerPath);
    }

    public String getHandlerPath(HttpServletRequest req) {
        Map<String, Object> stateParams = this.getStateParams(req);
        if (stateParams == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Failed to retrieve handler path as state params not found in request (likely not an API request)");
            }
            return null;
        }
        String previousHandlerPath = this.getSavedHandlerPath(stateParams);
        if (previousHandlerPath != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning previous handler path " + previousHandlerPath));
            }
            return previousHandlerPath;
        }
        return null;
    }

    public void cleanHandlerState(HttpServletRequest req) {
        Map<String, Object> stateParams = this.getStateParams(req);
        if (stateParams == null) {
            return;
        }
        stateParams.remove(KEY_HANDLER_PATH);
    }

    public void addStateParamsToRequest(HttpServletRequest req, Map<String, Object> params) {
        if (params != null) {
            req.setAttribute(ATTR_STATE_PARAMS, params);
        }
    }

    public boolean isDefaultAuthnAppEnabled() {
        return AuthnApiFactory.getEnvironment().isDefaultAuthnAppEnabled();
    }

    public void createFlowAndRedirectToDefaultAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String handlerPath) throws IOException {
        if (stateParams == null) {
            stateParams = new HashMap<String, Object>();
        }
        this.addHandlerPathStateParams(stateParams, handlerPath);
        AuthnApiFactory.getEnvironment().createFlowAndRedirectToDefaultAuthnApp(req, resp, stateParams);
    }

    public void redirectToDefaultAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String authnApiFlowId, String handlerPath) throws IOException {
        if (stateParams == null) {
            stateParams = new HashMap<String, Object>();
        }
        this.addHandlerPathStateParams(stateParams, handlerPath);
        AuthnApiFactory.getEnvironment().redirectToDefaultAuthnApp(req, resp, stateParams, authnApiFlowId);
    }

    public void createFlowAndRedirectToAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String authnApiAppId, String handlerPath) throws IOException {
        if (stateParams == null) {
            stateParams = new HashMap<String, Object>();
        }
        this.addHandlerPathStateParams(stateParams, handlerPath);
        AuthnApiFactory.getEnvironment().createFlowAndRedirectToAuthnApp(req, resp, stateParams, authnApiAppId);
    }

    public void redirectToAuthnApp(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> stateParams, String authnApiAppId, String authnApiFlowId, String handlerPath) throws IOException {
        if (stateParams == null) {
            stateParams = new HashMap<String, Object>();
        }
        this.addHandlerPathStateParams(stateParams, handlerPath);
        AuthnApiFactory.getEnvironment().redirectToAuthnApp(req, resp, authnApiAppId, authnApiFlowId, stateParams);
    }

    public Map<String, Object> getStateParams(HttpServletRequest req) {
        return (Map)req.getAttribute(ATTR_STATE_PARAMS);
    }

    public String getAuthnApiAppId(HttpServletRequest req) {
        return AuthnApiFactory.getEnvironment().getAuthnApiAppId(this.getStateParams(req));
    }

    public String getPluginTypeId(HttpServletRequest req) {
        Map<String, Object> stateParams = this.getStateParams(req);
        if (stateParams == null) {
            return null;
        }
        return AuthnApiFactory.getEnvironment().getPluginTypeId(stateParams);
    }

    public void setCurrentAuthnPlugin(HttpServletRequest request, Map<String, Object> stateParams, AuthnPluginType pluginType, String pluginId) {
        AuthnApiFactory.getEnvironment().setCurrentAuthnPlugin(request, stateParams, pluginType, pluginId);
    }

    public void saveLastAuthnApiApplication(Map<String, Object> stateParams, String authnAppId) {
        AuthnApiFactory.getEnvironment().saveLastAuthnApiApplication(stateParams, authnAppId);
    }

    private void overrideResponseCommitted(HttpServletResponse resp, boolean committed) {
        String METHOD_NAME = "setOverrideCommitted";
        try {
            Method method = resp.getClass().getMethod("setOverrideCommitted", Boolean.TYPE);
            method.invoke((Object)resp, committed);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected error trying to invoke method setOverrideCommitted on servlet response", e);
        }
    }

    private String getSavedHandlerPath(Map<String, Object> stateParams) {
        return (String)stateParams.get(KEY_HANDLER_PATH);
    }

    private void addHandlerPathStateParams(Map<String, Object> stateParams, String handlerPath) {
        stateParams.put(KEY_HANDLER_PATH, handlerPath);
    }

    public void setAuthnAPIOAuthFlowID(HttpServletRequest request, String flowID) {
        this.getStateParams(request).put(KEY_AUTHN_API_OAUTH_FLOW_ID, flowID);
    }

    public String getAuthnAPIOAuthFlowID(HttpServletRequest request) {
        return (String)this.getStateParam(request, KEY_AUTHN_API_OAUTH_FLOW_ID);
    }

    public Boolean isAuthnAPIOAuthInitiated(HttpServletRequest request) {
        String oauthFlowId = (String)this.getStateParam(request, KEY_AUTHN_API_OAUTH_FLOW_ID);
        if (oauthFlowId == null) {
            return false;
        }
        AuthnApiEnvironment authnApiEnvironment = AuthnApiFactory.getEnvironment();
        if (!authnApiEnvironment.supportsRedirectlessStateParam()) {
            return true;
        }
        Map<String, Object> stateParams = this.getStateParams(request);
        if (stateParams == null) {
            return false;
        }
        return authnApiEnvironment.isRedirectlessApiFlow(stateParams);
    }

    private Object getStateParam(HttpServletRequest request, String key) {
        Map<String, Object> stateParams = this.getStateParams(request);
        if (stateParams == null) {
            return null;
        }
        return stateParams.get(key);
    }

    public static enum AuthnPluginType {
        IDP_ADAPTER,
        SELECTOR;

    }
}

