/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.WithStateAttributeSupport;
import com.pingidentity.sdk.api.authn.util.MessageKeySerializer;
import java.util.ArrayList;
import java.util.List;

public class AuthnError
implements WithStateAttributeSupport {
    private String code;
    private String message;
    private String userMessage;
    private String userMessageKey;
    private List<AuthnErrorDetail> details;
    private int httpStatus;
    private String state = null;

    public AuthnError() {
    }

    public AuthnError(int httpStatus, String code, String message) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
    }

    public AuthnError(int httpStatus, String code, String message, List<AuthnErrorDetail> details) {
        this.httpStatus = httpStatus;
        this.code = code;
        this.message = message;
        this.details = details;
    }

    @JsonIgnore
    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonSerialize(using=MessageKeySerializer.class)
    public String getUserMessage() {
        if (this.userMessage != null) {
            return this.userMessage;
        }
        if (this.userMessageKey != null) {
            return this.userMessageKey;
        }
        return null;
    }

    public void setUserMessageKey(String userMessageKey) {
        this.userMessageKey = userMessageKey;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public List<AuthnErrorDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<AuthnErrorDetail> details) {
        this.details = details;
    }

    @Override
    @JsonProperty(value="_pf_authn_api_state")
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    public static class Builder {
        protected AuthnError result = new AuthnError();

        public AuthnError build() {
            return this.result;
        }

        public Builder httpStatus(int httpStatus) {
            this.result.httpStatus = httpStatus;
            return this;
        }

        public Builder code(String code) {
            this.result.code = code;
            return this;
        }

        public Builder message(String message) {
            this.result.message = message;
            return this;
        }

        public Builder userMessageKey(String messageKey) {
            this.result.userMessageKey = messageKey;
            return this;
        }

        public Builder userMessage(String userMessage) {
            this.result.userMessage = userMessage;
            return this;
        }

        public Builder detail(AuthnErrorDetail detail) {
            if (this.result.details == null) {
                this.result.details = new ArrayList();
            }
            this.result.details.add(detail);
            return this;
        }
    }
}

