/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.api.authn.util.MessageKeySerializer;

public class AuthnErrorDetail {
    private String code;
    private String message;
    private String target;
    private String userMessage;
    private String userMessageKey;

    public AuthnErrorDetail() {
    }

    public AuthnErrorDetail(String code, String message, String target) {
        this.code = code;
        this.message = message;
        this.target = target;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonSerialize(using=MessageKeySerializer.class)
    public String getUserMessage() {
        if (this.userMessage != null) {
            return this.userMessage;
        }
        if (this.userMessageKey != null) {
            return this.userMessageKey;
        }
        return null;
    }

    public void setUserMessageKey(String userMessageKey) {
        this.userMessageKey = userMessageKey;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public static class Builder {
        protected AuthnErrorDetail result = new AuthnErrorDetail();

        public AuthnErrorDetail build() {
            return this.result;
        }

        public Builder code(String code) {
            this.result.code = code;
            return this;
        }

        public Builder message(String message) {
            this.result.message = message;
            return this;
        }

        public Builder userMessageKey(String messageKey) {
            this.result.userMessageKey = messageKey;
            return this;
        }

        public Builder userMessage(String userMessage) {
            this.result.userMessage = userMessage;
            return this;
        }

        public Builder target(String target) {
            this.result.target = target;
            return this;
        }
    }
}

