/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.api.authn.util.MessageKeySerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

@Schema(description="The model for the FAILED state.")
public class AuthenticationFailed
implements Serializable {
    private String code;
    private String message = "Authentication failed.";
    private String userMessage;
    private String userMessageKey;
    private String adapterId;
    private String trackingId;

    @Schema(description="The error code.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Schema(description="The developer-facing error message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Schema(description="The user-facing error message. The intent is that this message can be displayed to the end user. Where possible, the message is user-friendly and localized.")
    @JsonSerialize(using=MessageKeySerializer.class)
    public String getUserMessage() {
        if (this.userMessage != null) {
            return this.userMessage;
        }
        if (this.userMessageKey != null) {
            return this.userMessageKey;
        }
        return null;
    }

    public void setUserMessageKey(String userMessageKey) {
        this.userMessageKey = userMessageKey;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    @Schema(description="The adapter ID associated with the error, if available.")
    public String getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    @Schema(description="The tracking ID for the user's browser session.")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }
}

