/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.api.authn.util.MessageKeySerializer;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="External authentication failed.")
public class ExternalAuthenticationFailed {
    private String code;
    private String message = "Authentication failed.";
    private String userMessage;
    private String userMessageKey;
    private String errorUrl;

    @Schema(description="The error code.")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Schema(description="The developer-facing error message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Schema(description="The user-facing error message.")
    @JsonSerialize(using=MessageKeySerializer.class)
    public String getUserMessage() {
        if (this.userMessage != null) {
            return this.userMessage;
        }
        if (this.userMessageKey != null) {
            return this.userMessageKey;
        }
        return null;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public void setUserMessageKey(String userMessageKey) {
        this.userMessageKey = userMessageKey;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    @Schema(description="The URL of the error page if one was defined in the adapter configuration.")
    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }
}

