/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.model.state;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaEnabledState;
import com.pingidentity.sdk.api.authn.model.state.interfaces.CaptchaProviderEnabledState;
import com.pingidentity.sdk.api.authn.util.MessageKeySerializer;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Map;

@Schema(description="New password is required.")
public class NewPasswordRequired
implements Serializable,
CaptchaEnabledState,
CaptchaProviderEnabledState {
    private String username;
    private boolean showCaptcha;
    private String captchaSiteKey;
    private String userMessage;
    private String userMessageKey;
    private boolean existingPasswordRequired = true;
    private String captchaProviderType;
    private Map<String, Object> captchaAttributes;

    @Schema(description="The username hint to be presented to the user.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean getShowCaptcha() {
        return this.showCaptcha;
    }

    @Override
    public void setShowCaptcha(boolean showCaptcha) {
        this.showCaptcha = showCaptcha;
    }

    @Override
    public String getCaptchaSiteKey() {
        return this.captchaSiteKey;
    }

    @Override
    public void setCaptchaSiteKey(String captchaSiteKey) {
        this.captchaSiteKey = captchaSiteKey;
    }

    @Schema(description="User message.")
    @JsonSerialize(using=MessageKeySerializer.class)
    public String getUserMessage() {
        if (this.userMessage != null) {
            return this.userMessage;
        }
        if (this.userMessageKey != null) {
            return this.userMessageKey;
        }
        return null;
    }

    public void setUserMessageKey(String userMessageKey) {
        this.userMessageKey = userMessageKey;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    @Schema(description="Set to true when the user's existing password is required.")
    public boolean isExistingPasswordRequired() {
        return this.existingPasswordRequired;
    }

    public void setExistingPasswordRequired(boolean existingPasswordRequired) {
        this.existingPasswordRequired = existingPasswordRequired;
    }

    @Override
    public String getCaptchaProviderType() {
        return this.captchaProviderType;
    }

    @Override
    public void setCaptchaProviderType(String captchaProviderType) {
        this.captchaProviderType = captchaProviderType;
    }

    @Override
    public Map<String, Object> getCaptchaAttributes() {
        return this.captchaAttributes;
    }

    @Override
    public void setCaptchaAttributes(Map<String, Object> captchaAttributes) {
        this.captchaAttributes = captchaAttributes;
    }
}

