/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.spec;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.model.AuthnAction;
import com.pingidentity.sdk.api.authn.spec.AuthnErrorDetailSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnErrorGroup;
import com.pingidentity.sdk.api.authn.spec.AuthnErrorSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;

public class AuthnActionSpec<ModelType> {
    private String id;
    private String description;
    private Class<ModelType> modelClass;
    private List<AuthnErrorSpec> errorSpecs = new ArrayList<AuthnErrorSpec>();
    private List<AuthnErrorDetailSpec> errorDetailSpecs = new ArrayList<AuthnErrorDetailSpec>();

    protected AuthnActionSpec() {
    }

    protected AuthnActionSpec(AuthnActionSpec<?> template, Class<ModelType> modelClass) {
        this.id = template.id;
        this.description = template.description;
        this.modelClass = modelClass;
        this.errorSpecs = new ArrayList<AuthnErrorSpec>(template.errorSpecs);
        this.errorDetailSpecs = new ArrayList<AuthnErrorDetailSpec>(template.errorDetailSpecs);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="models")
    public Class<ModelType> getModelClass() {
        return Void.class.equals(this.modelClass) ? null : this.modelClass;
    }

    public List<AuthnErrorGroup> getErrorGroups() {
        AuthnErrorGroup.Builder builder2;
        LinkedHashMap<String, AuthnErrorGroup.Builder> buildersByCode = new LinkedHashMap<String, AuthnErrorGroup.Builder>();
        for (AuthnErrorSpec errorSpec : this.errorSpecs) {
            builder2 = (AuthnErrorGroup.Builder)buildersByCode.get(errorSpec.getCode());
            if (builder2 == null) {
                builder2 = new AuthnErrorGroup.Builder();
                buildersByCode.put(errorSpec.getCode(), builder2);
            }
            builder2.error(errorSpec);
        }
        for (AuthnErrorDetailSpec detailSpec : this.errorDetailSpecs) {
            builder2 = (AuthnErrorGroup.Builder)buildersByCode.get(detailSpec.getParentCode());
            if (builder2 == null) {
                throw new RuntimeException("No error spec registered for code '" + detailSpec.getParentCode() + "'");
            }
            builder2.errorDetail(detailSpec);
        }
        return buildersByCode.values().stream().map(builder -> builder.build()).collect(Collectors.toList());
    }

    public AuthnAction makeInstance() {
        return new AuthnAction(this.id);
    }

    public <ValueType> ParamMapping<ModelType, ValueType> makeParamMapping(String formParamName, Function<ModelType, ValueType> modelFieldRetriever, Function<String, ValueType> paramFieldRetriever) {
        return new ParamMapping<ModelType, ValueType>(formParamName, this.modelClass, modelFieldRetriever, paramFieldRetriever);
    }

    public boolean isRequested(HttpServletRequest req) {
        if (!AuthnApiSupport.getDefault().isApiRequest(req)) {
            return false;
        }
        return this.id.equals(AuthnApiSupport.getDefault().toActionId(req.getContentType()));
    }

    public ModelType deserializeModel(HttpServletRequest request) throws AuthnErrorException, IOException {
        return AuthnApiSupport.getDefault().deserializeAsModel(request, this.modelClass);
    }

    public static class Builder<ModelType> {
        protected AuthnActionSpec<ModelType> result = new AuthnActionSpec();

        public AuthnActionSpec<ModelType> build() {
            return this.result;
        }

        public Builder<ModelType> template(AuthnActionSpec<ModelType> template) {
            this.result = new AuthnActionSpec<ModelType>(template, template.getModelClass());
            return this;
        }

        public Builder<ModelType> template(AuthnActionSpec<?> template, Class<ModelType> overrideModelClass) {
            this.result = new AuthnActionSpec<ModelType>(template, overrideModelClass);
            return this;
        }

        public Builder<ModelType> id(String id) {
            ((AuthnActionSpec)this.result).id = id;
            return this;
        }

        public Builder<ModelType> description(String description) {
            ((AuthnActionSpec)this.result).description = description;
            return this;
        }

        public Builder<ModelType> modelClass(Class<?> cls) {
            ((AuthnActionSpec)this.result).modelClass = cls;
            return this;
        }

        public Builder<ModelType> error(AuthnErrorSpec errorSpec) {
            ((AuthnActionSpec)this.result).errorSpecs.add(errorSpec);
            return this;
        }

        public Builder<ModelType> errorDetail(AuthnErrorDetailSpec errorDetailSpec) {
            if (errorDetailSpec.getParentCode() == null) {
                throw new IllegalArgumentException("The error detail spec's parent code must not be null");
            }
            AuthnErrorSpec errorSpec = ((AuthnActionSpec)this.result).errorSpecs.stream().filter(spec -> spec.getCode().equals(errorDetailSpec.getParentCode())).findFirst().orElse(null);
            if (errorSpec == null) {
                throw new IllegalArgumentException("You must first add the parent error spec (with code '" + errorDetailSpec.getParentCode() + "')");
            }
            ((AuthnActionSpec)this.result).errorDetailSpecs.add(errorDetailSpec);
            return this;
        }

        public Builder<ModelType> errorDetails(Collection<AuthnErrorDetailSpec> details) {
            details.forEach(this::errorDetail);
            return this;
        }
    }
}

