/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.spec;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;

public class AuthnErrorDetailSpec {
    private String code;
    private String message;
    private String userMessageKey;
    private String target;
    private String parentCode;

    public AuthnErrorDetailSpec(String parentCode, String code, String message) {
        this.parentCode = parentCode;
        this.code = code;
        this.message = message;
    }

    protected AuthnErrorDetailSpec() {
    }

    public AuthnErrorDetail.Builder makeInstanceBuilder() {
        return new AuthnErrorDetail.Builder().code(this.code).message(this.message).userMessageKey(this.userMessageKey).target(this.target);
    }

    public AuthnErrorDetail makeInstance() {
        return this.makeInstanceBuilder().build();
    }

    public String getParentCode() {
        return this.parentCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getUserMessageKey() {
        return this.userMessageKey;
    }

    public String getTarget() {
        return this.target;
    }

    public static class Builder {
        protected AuthnErrorDetailSpec result = new AuthnErrorDetailSpec();

        public AuthnErrorDetailSpec build() {
            return this.result;
        }

        public Builder code(String code) {
            this.result.code = code;
            return this;
        }

        public Builder message(String message) {
            this.result.message = message;
            return this;
        }

        public Builder userMessageKey(String messageKey) {
            this.result.userMessageKey = messageKey;
            return this;
        }

        public Builder target(String target) {
            this.result.target = target;
            return this;
        }

        public Builder parentCode(String parentCode) {
            this.result.parentCode = parentCode;
            return this;
        }
    }
}

