/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.internal.AuthnApiFactory;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.internal.RequestContextParameterNames;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnState;
import com.pingidentity.sdk.api.authn.model.RequestContext;
import com.pingidentity.sdk.api.authn.model.WithStateAttributeSupport;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.api.authn.spec.AuthnActionSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthnApiSupport {
    private static final Log log = LogFactory.getLog(AuthnApiSupport.class);
    private static final AuthnApiSupport instance = AuthnApiSupport.makeDefault();
    private static final String ATTR_IS_API_REQUEST = "AAS.IsApiRequest";
    private static final String ATTR_DESERIALIZED_MAP = "AAS.ApiRequest.Map";
    private static final String ATTR_DESERIALIZED_MODEL = "AAS.ApiRequest.Model";
    private static final String APPLICATION_JSON = "application/json";
    private static final String UTF_8 = "UTF-8";
    private static final String EMPTY_JSON_BODY = "{}";
    private static final String BEGINNING_INPUT_BOUNDARY = "\\A";
    private static final String WHITE_SPACE_REGEX = "\\s+";
    private ObjectMapper objectMapper;

    public static AuthnApiSupport getDefault() {
        return instance;
    }

    public AuthnApiSupport(ObjectMapper mapper) {
        this.objectMapper = mapper;
    }

    protected static AuthnApiSupport makeDefault() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return new AuthnApiSupport(objectMapper);
    }

    public boolean isApiRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(ATTR_IS_API_REQUEST));
    }

    public void setApiRequest(HttpServletRequest request) {
        request.setAttribute(ATTR_IS_API_REQUEST, (Object)Boolean.TRUE);
    }

    public Map<String, Object> deserializeAsMap(HttpServletRequest request) throws IOException {
        if (!this.isApiRequest(request)) {
            throw new RuntimeException("This does not appear to be an API request");
        }
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(request)) {
            return null;
        }
        Map deserialized = (Map)request.getAttribute(ATTR_DESERIALIZED_MAP);
        if (deserialized != null) {
            return deserialized;
        }
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        try (ServletInputStream inputStream = request.getInputStream();){
            deserialized = (Map)this.objectMapper.readValue((InputStream)inputStream, (TypeReference)typeRef);
            request.setAttribute(ATTR_DESERIALIZED_MAP, (Object)deserialized);
            Map map = deserialized;
            return map;
        }
    }

    public <ModelType> ModelType deserializeAsModel(HttpServletRequest request, Class<ModelType> modelClass) throws AuthnErrorException, IOException {
        if (!this.isApiRequest(request)) {
            throw new RuntimeException("This does not appear to be an API request");
        }
        if (InternalAuthnApiSupport.getDefault().isRequestBodyConsumed(request)) {
            return null;
        }
        Object deserialized = request.getAttribute(ATTR_DESERIALIZED_MODEL);
        if (deserialized == null) {
            try (ServletInputStream inputStream = request.getInputStream();){
                String jsonString = this.getJsonString(inputStream);
                if (modelClass != null) {
                    deserialized = this.objectMapper.readValue(jsonString, modelClass);
                    this.validateRequiredFields(deserialized, modelClass);
                    request.setAttribute(ATTR_DESERIALIZED_MODEL, deserialized);
                } else if (!jsonString.replaceAll(WHITE_SPACE_REGEX, "").equals(EMPTY_JSON_BODY)) {
                    throw new AuthnErrorException(this.getUnexpectedActionModelError());
                }
            }
            catch (JsonMappingException e) {
                log.debug((Object)"Error occurred while deserializing API request model");
                AuthnError error = e instanceof InvalidFormatException ? this.getInvalidFieldFormatError((InvalidFormatException)e) : (e instanceof UnrecognizedPropertyException ? this.getUnrecognizedPropertyError((UnrecognizedPropertyException)e) : this.getJsonMappingError(e));
                throw new AuthnErrorException(error);
            }
        }
        return (ModelType)deserialized;
    }

    private String getJsonString(ServletInputStream inputStream) {
        try {
            String jsonString = new Scanner((InputStream)inputStream, UTF_8).useDelimiter(BEGINNING_INPUT_BOUNDARY).next().trim();
            return jsonString.isEmpty() ? EMPTY_JSON_BODY : jsonString;
        }
        catch (NoSuchElementException exception) {
            return EMPTY_JSON_BODY;
        }
    }

    private void validateRequiredFields(Object model, Class<?> modelClass) throws AuthnErrorException {
        try {
            boolean hasRequiredFieldsMissing = false;
            AuthnError.Builder errorBuilder = CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder();
            for (Method method : modelClass.getMethods()) {
                if (!this.isRequiredFieldMissing(method, model)) continue;
                String fieldName = this.getFieldName(method);
                String fieldType = this.getFieldType(method);
                errorBuilder.detail(CommonErrorDetailSpec.FIELD_REQUIRED.makeInstanceBuilder().message(String.format("Required field '%s' of type %s is missing.", fieldName, fieldType)).target(fieldName).build());
                hasRequiredFieldsMissing = true;
            }
            if (hasRequiredFieldsMissing) {
                throw new AuthnErrorException(errorBuilder.build());
            }
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("API model required fields verification failed due to unexpected error: " + exception.getMessage()));
            }
            throw new AuthnErrorException(CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().build());
        }
    }

    private AuthnError getUnexpectedActionModelError() {
        return CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.UNEXPECTED_ACTION_MODEL.makeInstanceBuilder().build()).build();
    }

    private AuthnError getJsonMappingError(JsonMappingException exception) {
        return CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.INVALID_FIELD_FORMAT.makeInstanceBuilder().target(exception.getPath().stream().map(JsonMappingException.Reference::getFieldName).collect(Collectors.joining("/"))).build()).build();
    }

    private AuthnError getInvalidFieldFormatError(InvalidFormatException exception) {
        return CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.INVALID_FIELD_FORMAT.makeInstanceBuilder().target(exception.getPath().stream().map(JsonMappingException.Reference::getFieldName).collect(Collectors.joining("/"))).message(String.format("Expected type %s but received value '%s'.", exception.getTargetType().toGenericString(), exception.getValue().toString())).build()).build();
    }

    private AuthnError getUnrecognizedPropertyError(UnrecognizedPropertyException exception) {
        return CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().detail(CommonErrorDetailSpec.UNRECOGNIZED_FIELD_NAME.makeInstanceBuilder().target(exception.getPath().stream().map(JsonMappingException.Reference::getFieldName).collect(Collectors.joining("/"))).build()).build();
    }

    private String getFieldName(Method method) {
        return StringUtils.uncapitalize((String)method.getName().replaceAll("^get|^is", ""));
    }

    private String getFieldType(Method method) {
        return method.getReturnType().getSimpleName();
    }

    private boolean isRequiredFieldMissing(Method method, Object actionModel) throws InvocationTargetException, IllegalAccessException {
        Schema schema = method.getAnnotation(Schema.class);
        if (schema != null && schema.required() && (method.getName().startsWith("get") || method.getName().startsWith("is"))) {
            Object result = method.invoke(actionModel, new Object[0]);
            if (result == null) {
                return true;
            }
            if (result instanceof String) {
                return StringUtils.isBlank((String)((String)result));
            }
        }
        return false;
    }

    public <ModelType> AuthnState<ModelType> makeAuthnState(HttpServletRequest request, AuthnStateSpec<ModelType> stateSpec, ModelType stateModel) {
        InternalAuthnApiSupport internalAuthnApiSupport = InternalAuthnApiSupport.getDefault();
        String flowId = this.getFlowId(request.getPathInfo());
        if (flowId == null) {
            flowId = internalAuthnApiSupport.getAuthnAPIOAuthFlowID(request);
        }
        String url = this.getFlowUrl(request);
        if (flowId != null && !url.endsWith(flowId)) {
            url = url + (url.endsWith("/") ? "" : "/") + flowId;
        }
        AuthnState<ModelType> authnState = new AuthnState<ModelType>(flowId, url);
        for (AuthnActionSpec<?> actionSpec : stateSpec.getActions()) {
            authnState.addAction(actionSpec.makeInstance());
        }
        RequestContext requestContext = this.populateRequestContextParams(request, internalAuthnApiSupport);
        authnState.setRequestContext(requestContext);
        authnState.setStatus(stateSpec.getStatus());
        authnState.setModel(stateModel);
        String pluginTypeId = InternalAuthnApiSupport.getDefault().getPluginTypeId(request);
        authnState.setPluginTypeId(pluginTypeId);
        return authnState;
    }

    private RequestContext populateRequestContextParams(HttpServletRequest request, InternalAuthnApiSupport internalAuthnApiSupport) {
        RequestContext requestContext = null;
        if (AuthnApiFactory.getEnvironment().isIncludeRequestContext()) {
            RequestContextParameterNames requestContextParameterNames = AuthnApiFactory.getEnvironment().getRequestContextParameterNames();
            Map<String, Object> stateParams = internalAuthnApiSupport.getStateParams(request);
            requestContext = new RequestContext((String)stateParams.get(requestContextParameterNames.getClientId()), (String)stateParams.get(requestContextParameterNames.getEntityId()), (String)stateParams.get(requestContextParameterNames.getPluginId()), (Map)stateParams.get(requestContextParameterNames.getTrackedHttpParams()), (String)stateParams.get(requestContextParameterNames.getSpAdapterId()), (String)stateParams.get(requestContextParameterNames.getApplicationName()), (String)stateParams.get(requestContextParameterNames.getOidcUiLocales()), (String)stateParams.get(requestContextParameterNames.getApplicationIconUrl()), (Map)stateParams.get(requestContextParameterNames.getExtendedProperties()));
        }
        return requestContext;
    }

    private String getFlowUrl(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        try {
            URI uri = new URI(requestUrl);
            String contextPath = System.getProperty("pf.runtime.context.path");
            contextPath = StringUtils.trimToEmpty((String)contextPath);
            if (contextPath.equals("/")) {
                contextPath = "";
            }
            String path = contextPath + "/pf-ws/authn/flows";
            URI newUri = new URI(uri.getScheme(), uri.getRawAuthority(), path, null, null);
            return newUri.toString();
        }
        catch (URISyntaxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error parsing request URL", (Throwable)e);
            }
            return requestUrl;
        }
    }

    public void writeAuthnStateResponse(HttpServletRequest req, HttpServletResponse resp, AuthnState<?> authnState) throws IOException {
        this.writeResponse(req, resp, 200, authnState);
    }

    public void writeResumeResponse(HttpServletRequest req, HttpServletResponse resp, String resumePath) throws IOException {
        String resumeUrl;
        if (InternalAuthnApiSupport.getDefault().isAuthnAPIOAuthInitiated(req).booleanValue()) {
            throw new RuntimeException("The next step requires browser interaction, which is not supported with the pi.flow response mode");
        }
        try {
            URI requestUri = new URI(req.getRequestURL().toString());
            URI resumeUri = new URI(requestUri.getScheme(), null, requestUri.getHost(), requestUri.getPort(), resumePath, null, null);
            resumeUrl = resumeUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Request URL is not a valid URI: " + req.getRequestURL().toString());
        }
        Resume resume = new Resume();
        resume.setResumeUrl(resumeUrl);
        AuthnState<Resume> resumeState = CommonStateSpec.RESUME.makeInstance(req, resume);
        this.writeAuthnStateResponse(req, resp, resumeState);
    }

    public void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, AuthnError authnError) throws IOException {
        this.writeResponse(req, resp, authnError.getHttpStatus(), authnError);
    }

    public void writeResponse(HttpServletRequest req, HttpServletResponse resp, int status, Object model) throws IOException {
        resp.setContentType(APPLICATION_JSON);
        resp.setCharacterEncoding(UTF_8);
        resp.setStatus(status);
        if (model instanceof WithStateAttributeSupport) {
            String state = AuthnApiFactory.getEnvironment().getCookielessState(req, resp).orElse(null);
            ((WithStateAttributeSupport)model).setState(state);
        }
        try (PrintWriter printWriter = resp.getWriter();){
            ObjectWriter objectWriter = this.objectMapper.writer();
            Method withAttributeMethod = objectWriter.getClass().getMethod("withAttribute", Object.class, Object.class);
            objectWriter = (ObjectWriter)withAttributeMethod.invoke((Object)objectWriter, "httpRequest", req);
            objectWriter.writeValue((Writer)printWriter, model);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected error trying to invoke ObjectWriter.withAttribute()", e);
        }
    }

    public String getFlowId(String pathInfo) {
        if (pathInfo == null) {
            return null;
        }
        pathInfo = pathInfo.trim();
        String[] parts = (pathInfo = StringUtils.strip((String)pathInfo, (String)"/")).split("/");
        if (parts.length == 0) {
            return null;
        }
        String result = parts[0];
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public String toContentType(String actionId) {
        return "application/vnd.pingidentity." + actionId + "+json";
    }

    public String toActionId(String contentType) {
        if ((contentType = this.normalizeContentType(contentType)) == null) {
            return null;
        }
        if (!contentType.startsWith("application/vnd.pingidentity.")) {
            return null;
        }
        if (!contentType.endsWith("+json")) {
            return null;
        }
        if (contentType.length() < "application/vnd.pingidentity.".length() + "+json".length() + 1) {
            return null;
        }
        String result = contentType.substring("application/vnd.pingidentity.".length());
        result = result.substring(0, result.length() - "+json".length());
        return result;
    }

    public String getActionId(HttpServletRequest req) {
        return this.toActionId(req.getContentType());
    }

    public boolean isActionRequested(HttpServletRequest req) {
        return this.isApiRequest(req) && this.getActionId(req) != null;
    }

    public String getLocalizedMessage(HttpServletRequest request, String resourceBundleBaseName, String messageKey) {
        return this.getLocalizedMessage(request, resourceBundleBaseName, messageKey, new String[0]);
    }

    public String getLocalizedMessage(HttpServletRequest request, String resourceBundleBaseName, String messageKey, String[] params) {
        String message;
        block6: {
            if (messageKey == null) {
                return null;
            }
            message = null;
            if (resourceBundleBaseName == null) {
                try {
                    message = AuthnApiFactory.getEnvironment().getLocalizedMessage(request, "authn-api-messages", messageKey, params);
                }
                catch (MissingResourceException e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)"Resource authn-api-messages not found");
                }
            }
        }
        if (message == null || message.equals(messageKey)) {
            message = AuthnApiFactory.getEnvironment().getLocalizedMessage(request, resourceBundleBaseName, messageKey, params);
        }
        if ((message == null || message.equals(messageKey)) && resourceBundleBaseName == null) {
            message = AuthnApiFactory.getEnvironment().getLocalizedMessage(request, "authn-api-messages-embedded", messageKey, params);
        }
        return message;
    }

    public boolean isValidAuthnApiPostRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Class<?>> expectedActionIdToModelMapping) throws IOException {
        AuthnError authnError = null;
        if (AuthnApiSupport.getDefault().isApiRequest(req) && "POST".equals(req.getMethod())) {
            authnError = this.validateActionId(req, expectedActionIdToModelMapping.keySet());
            if (authnError == null) {
                authnError = this.validateActionModel(req, expectedActionIdToModelMapping.get(AuthnApiSupport.getDefault().getActionId(req)));
            }
            if (authnError != null) {
                AuthnApiSupport.getDefault().writeErrorResponse(req, resp, authnError);
            }
        }
        return authnError == null;
    }

    private AuthnError validateActionId(HttpServletRequest request, Set<String> expectedActionIds) {
        if (this.isInvalidContentType(request)) {
            return CommonErrorSpec.INVALID_REQUEST.makeInstanceBuilder().detail(CommonErrorDetailSpec.INVALID_CONTENT_TYPE.makeInstance()).build();
        }
        if (this.isInvalidActionId(request, expectedActionIds)) {
            return CommonErrorSpec.INVALID_ACTION_ID.makeInstanceBuilder().build();
        }
        return null;
    }

    private boolean isInvalidContentType(HttpServletRequest request) {
        return this.getActionId(request) == null;
    }

    private String normalizeContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return StringUtils.substringBefore((String)contentType, (String)";").trim();
    }

    private boolean isInvalidActionId(HttpServletRequest request, Set<String> expectedActionIds) {
        String requestedActionId = AuthnApiSupport.getDefault().getActionId(request);
        if (!expectedActionIds.contains(requestedActionId)) {
            log.debug((Object)("The requested action ID '" + requestedActionId + "' is not valid. Expected action IDs are " + expectedActionIds.toString()));
            return true;
        }
        return false;
    }

    private AuthnError validateActionModel(HttpServletRequest request, Class<?> expectedActionModelClass) {
        try {
            AuthnApiSupport.getDefault().deserializeAsModel(request, expectedActionModelClass);
        }
        catch (AuthnErrorException authnErrorException) {
            return authnErrorException.getValidationError();
        }
        catch (Exception exception) {
            log.error((Object)("Action model validation failed due to unexpected error: " + exception.getMessage()));
            if (log.isDebugEnabled()) {
                log.debug((Object)exception);
            }
            return CommonErrorSpec.VALIDATION_ERROR.makeInstanceBuilder().build();
        }
        return null;
    }
}

