/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

public class MessageKeySerializer
extends StdSerializer<String> {
    public static final String SERIALIZATION_ATTRIBUTE_HTTP_REQUEST = "httpRequest";

    public MessageKeySerializer() {
        super((Class)null);
    }

    public void serialize(String messageKey, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        String message = messageKey;
        try {
            Method getAttributeMethod = serializerProvider.getClass().getMethod("getAttribute", Object.class);
            HttpServletRequest request = (HttpServletRequest)getAttributeMethod.invoke((Object)serializerProvider, SERIALIZATION_ATTRIBUTE_HTTP_REQUEST);
            if (request == null) {
                throw new RuntimeException("Serialization context attribute httpRequest was not set");
            }
            message = AuthnApiSupport.getDefault().getLocalizedMessage(request, null, messageKey);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unexpected error trying to invoke SerializerProvider.getAttribute()", e);
        }
        jsonGenerator.writeString(message);
    }
}

