/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.api.authn.util;

import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

public class ParamMapping<ModelType, ValueType> {
    private String formParamName;
    private Class<ModelType> modelClass;
    private Function<ModelType, ValueType> modelFieldRetriever;
    private Function<String, ValueType> formFieldRetriever;

    public ParamMapping(String formParamName, Class<ModelType> modelClass, Function<ModelType, ValueType> modelFieldRetriever, Function<String, ValueType> paramFieldRetriever) {
        this.formParamName = formParamName;
        this.modelClass = modelClass;
        this.modelFieldRetriever = modelFieldRetriever;
        this.formFieldRetriever = paramFieldRetriever;
    }

    public String getFormParamName() {
        return this.formParamName;
    }

    public ValueType getValue(HttpServletRequest request) {
        AuthnApiSupport helper = AuthnApiSupport.getDefault();
        if (helper.isApiRequest(request) && request.getMethod().equals("POST")) {
            try {
                ModelType deserialized = helper.deserializeAsModel(request, this.modelClass);
                if (deserialized == null) {
                    return null;
                }
                return !deserialized.getClass().equals(this.modelClass) ? null : (ValueType)this.modelFieldRetriever.apply(deserialized);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.formFieldRetriever.apply(request.getParameter(this.getFormParamName()));
    }
}

