/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.filter;

import com.pingidentity.pf.common.api.CommonApiMsgKey;
import com.pingidentity.pf.common.api.filter.PatternAndRequestType;
import com.pingidentity.pf.common.api.model.ApiResult;
import com.pingidentity.pf.common.api.model.CommonApiResultFactory;
import com.pingidentity.pf.common.api.util.CorsUtils;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class XsrfFilter
implements ContainerRequestFilter {
    public static final String XSRF_HEADER_NAME = "X-XSRF-Header";
    @Context
    private HttpServletRequest servletRequest;

    public ContainerRequest filter(ContainerRequest containerRequest) {
        String pathInfo = StringUtils.defaultString((String)this.servletRequest.getPathInfo());
        if (this.isPathExempt(pathInfo, containerRequest.getMethod())) {
            return containerRequest;
        }
        String headerValue = containerRequest.getHeaderValue(XSRF_HEADER_NAME);
        if (headerValue != null) {
            return containerRequest;
        }
        ApiResult result = CommonApiResultFactory.create(CommonApiMsgKey.xsrf_header_required);
        if (CorsUtils.isSuccessfulOptionsCorsRequest(this.servletRequest.getMethod(), this.servletRequest)) {
            return containerRequest;
        }
        throw new WebApplicationException(Response.status((int)400).type("application/json").entity((Object)result).build());
    }

    protected boolean isPathExempt(String pathInfo, String requestType) {
        for (PatternAndRequestType patternReq : this.getExemptPaths()) {
            Matcher matcher = patternReq.getExcludePattern().matcher(pathInfo);
            if (!matcher.matches() || !patternReq.getRequestType().getValue().equals(requestType)) continue;
            return true;
        }
        return false;
    }

    protected List<PatternAndRequestType> getExemptPaths() {
        return Collections.singletonList(new PatternAndRequestType(Pattern.compile("/oauth/grants(?:/.+)?"), PatternAndRequestType.RequestType.OPTIONS));
    }
}

