/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.model;

import com.pingidentity.pf.common.api.validator.error.ValidationError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description="Details on the result of the operation.")
public class ApiResult {
    private String resultId;
    private String message;
    private String developerMessage;
    private List<ValidationError> validationErrors;

    public ApiResult(String resultId, String message) {
        this.resultId = resultId;
        this.message = message;
    }

    public ApiResult(String resultId, String message, List<ValidationError> validationErrors) {
        this(resultId, message);
        this.validationErrors = validationErrors;
    }

    @ApiModelProperty(position=10, value="Result identifier.")
    public String getResultId() {
        return this.resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    @ApiModelProperty(position=20, value="Success or error message.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(position=30, value="Developer-oriented error message, if available.")
    public String getDeveloperMessage() {
        return this.developerMessage;
    }

    public void setDeveloperMessage(String developerMessage) {
        this.developerMessage = developerMessage;
    }

    @ApiModelProperty(position=40, value="List of validation errors, if any.")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    public void appendError(ValidationError error) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.add(error);
    }

    public void appendErrors(List<ValidationError> errors) {
        if (this.validationErrors == null) {
            this.validationErrors = new ArrayList<ValidationError>();
        }
        this.validationErrors.addAll(errors);
    }
}

