/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.model.oauth;

import java.util.HashMap;
import java.util.Map;

public enum GrantType {
    IMPLICIT("implicit"),
    AUTHORIZATION_CODE("authorization_code"),
    RESOURCE_OWNER_CREDENTIALS("password"),
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token"),
    EXTENSION("extension"),
    DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code"),
    ACCESS_TOKEN_VALIDATION("urn:pingidentity.com:oauth2:grant_type:validate_bearer"),
    CIBA("urn:openid:params:grant-type:ciba"),
    TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange");

    private String id;
    private static final Map<String, GrantType> ID_TO_TYPE_MAP;

    private GrantType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static GrantType getType(String id) {
        return ID_TO_TYPE_MAP.get(id);
    }

    static {
        ID_TO_TYPE_MAP = new HashMap<String, GrantType>();
        for (GrantType grantType : GrantType.values()) {
            ID_TO_TYPE_MAP.put(grantType.getId(), grantType);
        }
    }
}

