/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pf.common.api.validator.error;

import com.pingidentity.pf.common.api.validator.error.ValidationError;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

public class BulkOperationsValidationError
extends ValidationError {
    private String resourceType;
    private String subResource;
    private String resourceId;
    private List<ValidationError> validationErrors;

    protected BulkOperationsValidationError(Builder builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
        this.resourceType = builder.resourceType;
        this.subResource = builder.subResource;
        this.resourceId = builder.resourceId;
    }

    @ApiModelProperty(position=60, value="If using bulk import, the resource type that generated the validation error.")
    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @ApiModelProperty(position=65, value="If using bulk import, the subresource that generated the validation error.")
    public String getSubResource() {
        return this.subResource;
    }

    public void setSubResource(String subResource) {
        this.subResource = subResource;
    }

    @ApiModelProperty(position=70, value="If using bulk import, the resource ID that generated the validation error.")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @ApiModelProperty(position=80, value="If using bulk import, the list of validation errors for a specific resource type")
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public void setValidationErrors(List<ValidationError> validationErrors) {
        this.validationErrors = validationErrors;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("\nResource ID: ");
        builder.append(this.resourceId);
        builder.append("\n");
        builder.append("\nResource Type: ");
        builder.append(this.resourceType);
        builder.append("\n");
        builder.append("\nSub-resource: ");
        builder.append(this.subResource);
        builder.append("\n");
        return builder.toString();
    }

    public static class Builder
    extends ValidationError.Builder<Builder> {
        private String resourceType;
        private String subResource;
        private String resourceId;
        private List<ValidationError> validationErrors;

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder subResource(String subResource) {
            this.subResource = subResource;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder validationErrors(List<ValidationError> validationErrors) {
            this.validationErrors = validationErrors;
            return this;
        }

        @Override
        public BulkOperationsValidationError build() {
            return new BulkOperationsValidationError(this);
        }
    }
}

