/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.ConfigStoreFileMigrator;
import com.pingidentity.common.upgrade.FileMigrationManager;
import com.pingidentity.common.upgrade.FileMigrator;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.ParameterValidationMigrator;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.Saml2LocalMetadataMigrator;
import com.pingidentity.common.upgrade.Saml2MetadataMigrator;
import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.common.upgrade.custom.Adapter2AdapterCustomAction;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.custom.LdapDsCustomAction;
import com.pingidentity.common.upgrade.custom.OAuthAuthzServerSettingsCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.AccessGrantManagerCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.CoreConfigCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ExpressionAdminUpdateCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.JCEManagerCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.OidcConfigStoreCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.PersistentSessionCookieConfigCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.SessionCookieConfigCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.SessionMgmtSettingsCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.SourceDefaultMissingCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.SqlFilterManagerCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.TargetResourceValidationMgrCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.UnboundIDAccessGrantCustomAction;
import com.pingidentity.common.upgrade.exception.MigrationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataDirectoryMigrator {
    private static final Logger log = LogManager.getLogger(DataDirectoryMigrator.class);
    private final String srcDataDir;
    private final String destDataDir;
    private final String sourcePFVersion;
    private final String destinationPFVersion;
    private final PingFederateDirectoryInfo pingFederateDirectoryInfo;
    private final String mode;
    private final FileMigrationManager fileMigrationManager;

    public DataDirectoryMigrator(String sourceRootDir, String destinationRootDir, String sourcePFVersion, String destinationPFVersion, PingFederateDirectoryInfo pingFederateDirectoryInfo, FileMigrationManager fileMigrationManager, String mode) {
        this.srcDataDir = sourceRootDir + pingFederateDirectoryInfo.getRelativeDataDir();
        this.destDataDir = destinationRootDir + pingFederateDirectoryInfo.getRelativeDataDir();
        this.sourcePFVersion = sourcePFVersion;
        this.destinationPFVersion = destinationPFVersion;
        this.pingFederateDirectoryInfo = pingFederateDirectoryInfo;
        this.mode = mode;
        this.fileMigrationManager = fileMigrationManager;
    }

    public DataDirectoryMigrator(String sourceDataDir, String destDataDir, String sourcePFVersion, String destinationPFVersion, PingFederateDirectoryInfo pingFederateDirectoryInfo, String mode) {
        this.srcDataDir = sourceDataDir;
        this.destDataDir = destDataDir;
        this.sourcePFVersion = sourcePFVersion;
        this.destinationPFVersion = destinationPFVersion;
        this.pingFederateDirectoryInfo = pingFederateDirectoryInfo;
        this.mode = mode;
        this.fileMigrationManager = new FileMigrationManager(this.srcDataDir, pingFederateDirectoryInfo.getDestinationRootDir(), pingFederateDirectoryInfo.getReferenceFilesRootDirForSourceVersion());
    }

    public void migrateDataDirectory() throws MigrationException {
        Utils.deletePfJwkFileFromDir(this.destDataDir);
        File sourceDataDirectoryFile = new File(this.srcDataDir);
        File destinationDataDirectoryFile = new File(this.destDataDir);
        FilesUtils.copyDirectory(sourceDataDirectoryFile, destinationDataDirectoryFile, file -> !".placeholder".equals(file.getName()) && !"ping-ssl-client-trust-cas.jks".equals(file.getName()) && !"archive".equals(file.getName()) && !"instance".equals(file.getName()) && !"config-store".equals(file.getName()) && !"connection-deployer".equals(file.getName()) && !"drop-in-deployer".equals(file.getName()) && !"hypersonic".equals(file.getName()) && !"index".equals(file.getName()) && !"replication".equals(file.getName()) && !"update".equals(file.getName()) && !"oauth-clients.xml".equals(file.getName()) && !"mbean-to-snmp-mappings.xml".equals(file.getName()) && !"pf-adapter-2-adapter-mapping.xml".equals(file.getName()) && !"pingfederate-ldap-ds.xml".equals(file.getName()));
        File sourceInstanceDirectoryFile = new File(this.srcDataDir, "instance");
        File destinationInstanceDirectoryFile = new File(this.destDataDir, "instance");
        FilesUtils.copyDirectory(sourceInstanceDirectoryFile, destinationInstanceDirectoryFile, file -> !".placeholder".equals(file.getName()) && !"metadata.xml".equals(file.getName()));
        if (Version.compare(this.sourcePFVersion, "8.3.3") < 0) {
            String hsmMode = this.getSourceHsmMode();
            this.renameHSMKeystoreFiles(destinationDataDirectoryFile, hsmMode);
        }
        if (Version.compare(this.sourcePFVersion, "6.5.0") < 0 && Version.compare(this.destinationPFVersion, "6.5.0") >= 0) {
            Saml2MetadataMigrator saml2MetadataMigrator = new Saml2MetadataMigrator();
            saml2MetadataMigrator.migrate(this.destDataDir);
        }
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getSourceRelativeDataDir(), this.pingFederateDirectoryInfo.getRelativeDataDir(), "oauth-authz-server-settings.xml", new OAuthAuthzServerSettingsCustomAction());
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getSourceRelativeDataDir(), this.pingFederateDirectoryInfo.getRelativeDataDir(), "pf-adapter-2-adapter-mapping.xml", new Adapter2AdapterCustomAction());
        this.fileMigrationManager.migrate(new FileMigrator(), this.pingFederateDirectoryInfo.getSourceRelativeDataDir(), this.pingFederateDirectoryInfo.getRelativeDataDir(), "pingfederate-ldap-ds.xml", new LdapDsCustomAction());
        this.migrateConfigStoreDirectory(this.srcDataDir, this.destDataDir);
        if (this.pingFederateDirectoryInfo.getSourceRootDir() != null) {
            File sourceUpdateDirectoryFile = new File(this.pingFederateDirectoryInfo.getSourceUpdateDir());
            File destinationUpdateDirectoryFile = new File(this.pingFederateDirectoryInfo.getDestinationUpdateDir());
            FilesUtils.copyDirectory(sourceUpdateDirectoryFile, destinationUpdateDirectoryFile, file -> "config".equals(file.getName()));
        }
        Saml2LocalMetadataMigrator saml2LocalMetadataMigrator = new Saml2LocalMetadataMigrator();
        saml2LocalMetadataMigrator.migrate(this.srcDataDir, this.destDataDir);
    }

    private void migrateConfigStoreDirectory(String srcDataDir, String destDataDir) throws MigrationException {
        String CONFIG_STORE = "config-store";
        String TARGET_RESOURCE_VALIDATION_CONFIG_NAME = "org.sourceid.saml20.domain.mgmt.impl.TargetResourceValidationMgrImpl.xml";
        String ATTRIBUTE_MAPPING_CONFIG_NAME = "org.sourceid.saml20.domain.AttributeMapping.xml";
        String PF_WEB_APP_PROVIDER_CONFIG_NAME = "com.pingidentity.appserver.jetty.PFWebAppProvider.xml";
        String OIDC_SPECIFICATION_COMPLIANCE_CONFIG_NAME = "oidc-specification-compliance.xml";
        String EXPRESSION_MANAGER = "org.sourceid.common.ExpressionManager.xml";
        String MASTER_KEY_SET_CONFIG_NAME = "com.pingidentity.crypto.jwk.MasterKeySet.xml";
        HashMap<String, ConfigStoreFileCustomAction> sourceFileMayBeMissingCustomActions = new HashMap<String, ConfigStoreFileCustomAction>();
        sourceFileMayBeMissingCustomActions.put("org.sourceid.saml20.domain.mgmt.impl.TargetResourceValidationMgrImpl.xml", new TargetResourceValidationMgrCustomAction(this.mode));
        sourceFileMayBeMissingCustomActions.put("org.sourceid.saml20.domain.AttributeMapping.xml", new SourceDefaultMissingCustomAction());
        sourceFileMayBeMissingCustomActions.put("cipher-suite-settings.xml", new SourceDefaultMissingCustomAction());
        sourceFileMayBeMissingCustomActions.put("com.pingidentity.crypto.jwk.MasterKeySet.xml", new SourceDefaultMissingCustomAction(true));
        sourceFileMayBeMissingCustomActions.put("com.pingidentity.appserver.jetty.PFWebAppProvider.xml", new PFWebAppProviderConfigSourceMissingCustomAction());
        sourceFileMayBeMissingCustomActions.put("oidc-specification-compliance.xml", new OidcConfigStoreCustomAction());
        ArrayList<String> grantManagementConfigFileNames = new ArrayList<String>();
        grantManagementConfigFileNames.add("org.sourceid.oauth20.token.AccessGrantManagerJdbcImpl.xml");
        grantManagementConfigFileNames.add("org.sourceid.oauth20.token.AccessGrantManagerLDAPADImpl.xml");
        grantManagementConfigFileNames.add("org.sourceid.oauth20.token.AccessGrantManagerLDAPOracleImpl.xml");
        grantManagementConfigFileNames.add("org.sourceid.oauth20.token.AccessGrantManagerLDAPPingDirectoryImpl.xml");
        grantManagementConfigFileNames.add("org.sourceid.oauth20.token.AccessGrantManagerLDAPPingDSImpl.xml");
        String[] fileExt = new String[]{"xml"};
        Collection srcConfigStoreFiles = FileUtils.listFiles((File)new File(srcDataDir, "config-store"), (String[])fileExt, (boolean)false);
        Set newDestConfigStoreFiles = FileUtils.listFiles((File)new File(destDataDir, "config-store"), (String[])fileExt, (boolean)false).stream().map(file -> file.getName()).collect(Collectors.toSet());
        srcConfigStoreFiles.forEach(file -> newDestConfigStoreFiles.remove(file.getName()));
        newDestConfigStoreFiles.removeAll(sourceFileMayBeMissingCustomActions.keySet());
        String sourceRelativeDir = this.pingFederateDirectoryInfo.getSourceRelativeConfigStoreDir();
        String destinationRelativeDir = this.pingFederateDirectoryInfo.getRelativeConfigStoreDir();
        for (File file2 : srcConfigStoreFiles) {
            String sourceConfigStoreFileName = file2.getName();
            ConfigStoreFileCustomAction customAction = null;
            FileMigrator migrator = new ConfigStoreFileMigrator();
            String localDestinationRelativeDir = destinationRelativeDir;
            if (sourceFileMayBeMissingCustomActions.containsKey(sourceConfigStoreFileName) || "com.pingidentity.draft.mgmt.DraftManagerImpl.xml".equals(sourceConfigStoreFileName) || "org.sourceid.saml20.domain.mgmt.SnmpManager.xml".equals(sourceConfigStoreFileName)) continue;
            if (sourceConfigStoreFileName.startsWith("com.pingidentity.crypto.") && sourceConfigStoreFileName.endsWith("JCEManager.xml")) {
                customAction = new JCEManagerCustomAction(this.mode, sourceConfigStoreFileName);
            } else if ("org.sourceid.common.SqlFilterManager.xml".equals(sourceConfigStoreFileName)) {
                customAction = new SqlFilterManagerCustomAction(this.mode);
            } else if ("org.sourceid.config.CoreConfig.xml".equals(sourceConfigStoreFileName)) {
                customAction = new CoreConfigCustomAction(this.mode);
            } else if ("session-cookie-config.xml".equals(sourceConfigStoreFileName)) {
                customAction = new SessionCookieConfigCustomAction(this.mode);
            } else if ("persistent-session-cookie-config.xml".equals(sourceConfigStoreFileName)) {
                customAction = new PersistentSessionCookieConfigCustomAction(this.mode);
            } else if ("jmx-remote-config.xml".equals(sourceConfigStoreFileName)) {
                localDestinationRelativeDir = this.pingFederateDirectoryInfo.getRelativeConfDir();
            } else if ("org.sourceid.oauth20.token.AccessGrantManagerLDAPUnboundIDImpl.xml".equals(sourceConfigStoreFileName)) {
                customAction = new UnboundIDAccessGrantCustomAction(this.mode);
                migrator = new FileMigrator();
            } else if ("session-mgmt-settings.xml".equals(sourceConfigStoreFileName)) {
                customAction = new SessionMgmtSettingsCustomAction(this.mode);
            } else if (grantManagementConfigFileNames.contains(sourceConfigStoreFileName)) {
                customAction = new AccessGrantManagerCustomAction(this.mode);
            } else if ("org.sourceid.common.ExpressionManager.xml".equals(sourceConfigStoreFileName)) {
                customAction = new ExpressionAdminUpdateCustomAction(this.mode);
            }
            this.fileMigrationManager.migrate(migrator, sourceRelativeDir, localDestinationRelativeDir, sourceConfigStoreFileName, customAction);
        }
        for (Map.Entry entry : sourceFileMayBeMissingCustomActions.entrySet()) {
            this.fileMigrationManager.migrate(new ConfigStoreFileMigrator(), sourceRelativeDir, destinationRelativeDir, (String)entry.getKey(), (FileCustomAction)entry.getValue());
        }
        for (String string : newDestConfigStoreFiles) {
            this.fileMigrationManager.migrate(new ConfigStoreFileMigrator(), sourceRelativeDir, destinationRelativeDir, string, null);
        }
        if (Version.compare(this.sourcePFVersion, "6.11.0") < 0 && Version.compare(this.destinationPFVersion, "6.11.0") >= 0) {
            new ParameterValidationMigrator().migrate(this.pingFederateDirectoryInfo);
        }
    }

    private String getSourceHsmMode() {
        String hsmMode = null;
        try {
            String sourceRunPropertiesPath = PingFederateDirectoryInfo.getInstance().getSourceBinDir();
            File sourceRunPropertiesFile = new File(sourceRunPropertiesPath, "run.properties");
            Properties defaultSourceProps = FilesUtils.loadProperties(sourceRunPropertiesFile);
            hsmMode = defaultSourceProps.getProperty("pf.hsm.mode");
        }
        catch (IOException e) {
            log.error("Unable to get pf.hsm.mode from source run.properties.", (Throwable)e);
        }
        return hsmMode;
    }

    private void renameHSMKeystoreFiles(File destinationDataDirectoryFile, String hsmMode) throws MigrationException {
        if (!StringUtils.equalsIgnoreCase((String)"OFF", (String)hsmMode)) {
            this.renameKeystore(destinationDataDirectoryFile, "ping-dsig.jks", "ping-dsig.hsmks", true);
            this.renameKeystore(destinationDataDirectoryFile, "ping-ssl.jks", "ping-ssl.hsmks", true);
            this.renameKeystore(destinationDataDirectoryFile, "ping-ssl-server.jks", "ping-ssl-server.hsmks", true);
            this.renameKeystore(destinationDataDirectoryFile, "ping-general.jks", "ping-general.hsmks", true);
            if (!StringUtils.equalsIgnoreCase((String)"LUNA", (String)hsmMode)) {
                this.renameKeystore(destinationDataDirectoryFile, "ping-trust.jks", "ping-trust.hsmks", true);
            }
            if (StringUtils.equalsIgnoreCase((String)"LUNA", (String)hsmMode) && Version.compare(this.sourcePFVersion, "8.3.3") < 0) {
                this.renameKeystore(destinationDataDirectoryFile, "ping-dsig-cert.jks", "ping-dsig.jks", false);
                this.renameKeystore(destinationDataDirectoryFile, "ping-ssl-cert.jks", "ping-ssl.jks", false);
            }
        }
    }

    private void renameKeystore(File destinationDataDirectoryFile, String sourceKeystoreName, String destKeystoreName, boolean isHSMKeyStore) throws MigrationException {
        boolean validKeyStoreType;
        File sourceKeystore = new File(destinationDataDirectoryFile, sourceKeystoreName);
        File destKeystore = new File(destinationDataDirectoryFile, destKeystoreName);
        boolean bl = validKeyStoreType = isHSMKeyStore && !FilesUtils.isJksKeystore(sourceKeystore) || !isHSMKeyStore && FilesUtils.isJksKeystore(sourceKeystore);
        if (sourceKeystore.exists() && !destKeystore.exists() && validKeyStoreType) {
            boolean renameSuccessful = sourceKeystore.renameTo(destKeystore);
            if (renameSuccessful) {
                log.info("Renamed " + LogHelper.getInstance().getCleanPath(sourceKeystore) + " to " + LogHelper.getInstance().getCleanPath(destKeystore));
            } else {
                throw new MigrationException("Unable to rename " + LogHelper.getInstance().getCleanPath(sourceKeystore) + " to " + LogHelper.getInstance().getCleanPath(destKeystore));
            }
        }
    }

    private static class PFWebAppProviderConfigSourceMissingCustomAction
    extends ConfigStoreFileCustomAction {
        private PFWebAppProviderConfigSourceMissingCustomAction() {
        }

        private String getModifiedConfigContent(File defaultConfigFile) throws IOException {
            try (FileInputStream inputStream = FileUtils.openInputStream((File)defaultConfigFile);){
                String string = String.join((CharSequence)"\n", IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).stream().filter(line -> !line.trim().equals("<!--") && !line.trim().equals("-->")).collect(Collectors.toList()));
                return string;
            }
        }
    }
}

