/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade;

import com.pingidentity.common.upgrade.ConfigStoreFileMigrator;
import com.pingidentity.common.upgrade.ConfigStoreHelper;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.PingFederateDirectoryInfo;
import com.pingidentity.common.upgrade.exception.FileMigrationException;
import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.impl.xml.ConfigDocument;
import org.sourceid.config.impl.xml.ItemType;
import org.sourceid.config.impl.xml.MapType;

public class ParameterValidationMigrator
extends ConfigStoreFileMigrator {
    private static final Logger log = LogManager.getLogger(ParameterValidationMigrator.class);
    private static final String oldName = "request-parameter-validation.xml";
    private static final String newName = "http-request-parameter-validation.xml";

    public void migrate(PingFederateDirectoryInfo dirInfo) {
        String relativeDir = dirInfo.getRelativeConfigStoreDir();
        File sourceFileParentDir = new File(dirInfo.getSourceRootDir() + relativeDir);
        File sourceFile = new File(sourceFileParentDir, oldName);
        File destinationFileParentDir = new File(dirInfo.getDestinationRootDir() + relativeDir);
        File destinationFile = new File(destinationFileParentDir, newName);
        File sourceDefaultFileParentDir = new File(dirInfo.getReferenceFilesRootDirForSourceVersion() + relativeDir);
        File defaultSourceFile = new File(sourceDefaultFileParentDir, oldName);
        try {
            MapType[] configMaps;
            if (this.isFilesEqual(sourceFile, defaultSourceFile)) {
                return;
            }
            ConfigDocument sourceConfigDocument = ConfigStoreHelper.getConfigDocument(sourceFile);
            Map<String, Object> sourceMap = ConfigStoreHelper.getConfigStoreMapFromFile(sourceConfigDocument);
            ConfigDocument destinationConfigDocument = ConfigStoreHelper.getConfigDocument(destinationFile);
            int resourceUrlLength = this.getIntValue(sourceMap.get("resource-url-max-length"));
            int requestedBindingLength = this.getIntValue(sourceMap.get("RequestedBinding-max-length"));
            int bindingLength = this.getIntValue(sourceMap.get("Binding-max-length"));
            int requestedSpNameQualifierLength = this.getIntValue(sourceMap.get("RequestedSPNameQualifier-max-length"));
            for (MapType map : configMaps = destinationConfigDocument.getConfig().getMapArray()) {
                String propertyName = map.getName();
                String skipName = "skip-validate:" + propertyName;
                Object skipValue = sourceMap.get(skipName);
                if (skipValue != null && skipValue.toString().equalsIgnoreCase("true")) {
                    map.setItemArray(new ItemType[0]);
                    log.info("Update " + LogHelper.getInstance().getCleanPath(destinationFile.getPath()) + ". Set property map " + propertyName + " to empty.");
                    continue;
                }
                if (resourceUrlLength >= 0 && (propertyName.equalsIgnoreCase("TargetResource") || propertyName.equalsIgnoreCase("TARGET") || propertyName.equalsIgnoreCase("SourceResource") || propertyName.equalsIgnoreCase("InErrorResource"))) {
                    this.updateLengthValidatorArgument(destinationFile.getPath(), map, resourceUrlLength);
                }
                if (requestedBindingLength > 0 && propertyName.equalsIgnoreCase("RequestedBinding")) {
                    this.updateLengthValidatorArgument(destinationFile.getPath(), map, requestedBindingLength);
                }
                if (bindingLength > 0 && propertyName.equalsIgnoreCase("Binding")) {
                    this.updateLengthValidatorArgument(destinationFile.getPath(), map, bindingLength);
                }
                if (requestedSpNameQualifierLength <= 0 || !propertyName.equalsIgnoreCase("RequestedSPNameQualifier")) continue;
                this.updateLengthValidatorArgument(destinationFile.getPath(), map, requestedSpNameQualifierLength);
            }
            ParameterValidationMigrator.save(destinationFile, (XmlObject)destinationConfigDocument);
        }
        catch (FileMigrationException e) {
            log.error("Unable to migrate source file " + LogHelper.getInstance().getCleanPath(sourceFile), (Throwable)e);
        }
    }

    private void updateLengthValidatorArgument(String filePath, MapType map, int length) {
        for (ItemType item : map.getItemArray()) {
            if (!"LengthValidator".equals(item.getName())) continue;
            String destinationValue = item.getStringValue();
            String sourceValue = Integer.toString(length);
            if (sourceValue.equals(destinationValue)) {
                return;
            }
            item.setStringValue(sourceValue);
            log.info("Update " + LogHelper.getInstance().getCleanPath(filePath) + ". Update property LengthValidator in property map " + map.getName() + ". Value changed from " + destinationValue + " to " + sourceValue + ".");
            break;
        }
    }

    private int getIntValue(Object value) {
        int result = -1;
        if (value != null) {
            result = Integer.parseInt(value.toString());
        }
        return result;
    }
}

