/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import com.pingidentity.config.xml.ldapds.LdapSource;
import com.pingidentity.config.xml.ldapds.LdapSourcesDocument;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;

public class LdapDsCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(LdapDsCustomAction.class);

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File srcLdapDsXmlFile = new File(sourceFileParentDir, fileName);
        if (srcLdapDsXmlFile.exists()) {
            File destLdapDsXmlFile = new File(destinationFileParentDir, fileName);
            try {
                FilesUtils.copyfile(srcLdapDsXmlFile, destLdapDsXmlFile);
            }
            catch (Exception e) {
                log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(srcLdapDsXmlFile), (Throwable)e);
                return;
            }
            try {
                LdapSourcesDocument dest = LdapSourcesDocument.Factory.parse((File)destLdapDsXmlFile);
                LdapSource[] sources = dest.getLdapSources().getLdapSourceArray();
                StringBuilder updateMsg = new StringBuilder();
                for (LdapSource source : sources) {
                    if (source.isSetMaxTotal()) {
                        int min;
                        int max = min = 1;
                        if (source.getMinIdle() > min) {
                            min = source.getMinIdle();
                        }
                        if ((max = source.getMaxTotal() > source.getMaxActive() ? source.getMaxTotal() : source.getMaxActive()) <= min) {
                            max = min;
                        }
                        source.setMinIdle(min);
                        source.setMaxActive(max);
                        updateMsg.append(" [Changed attributes min = " + min + ", max = " + max + " for ldap-source: " + source.getId() + "]");
                    }
                    if (source.isSetTestWhileIdle()) {
                        source.unsetTestWhileIdle();
                    }
                    if (source.isSetMaxTotal()) {
                        source.unsetMaxTotal();
                    }
                    if (source.isSetMaxIdle()) {
                        source.unsetMaxIdle();
                    }
                    if (source.isSetMinEvictableIdleTimeMillis()) {
                        source.unsetMinEvictableIdleTimeMillis();
                    }
                    if (!source.isSetNumTestsPerEvictionRun()) continue;
                    source.unsetNumTestsPerEvictionRun();
                }
                if (StringUtils.isNotBlank((String)updateMsg.toString())) {
                    this.updateFile(dest, destLdapDsXmlFile, updateMsg.toString());
                }
            }
            catch (Exception e) {
                log.error("Unable to update file " + LogHelper.getInstance().getCleanPath(destLdapDsXmlFile), (Throwable)e);
            }
        }
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        return false;
    }

    @Override
    public boolean copyIfSourceDefaultMissing() {
        return false;
    }

    private void updateFile(LdapSourcesDocument destCopy, File destLdapDsXmlFile, String logMessage) throws IOException {
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        destCopy.save(destLdapDsXmlFile, options);
        log.info("Update " + LogHelper.getInstance().getCleanPath(destLdapDsXmlFile) + ". " + logMessage);
    }
}

