/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom;

import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.FileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OAuthAuthzServerSettingsCustomAction
implements FileCustomAction {
    private static final Logger log = LogManager.getLogger(OAuthAuthzServerSettingsCustomAction.class);

    private String read(File settingFile) throws IOException {
        try (FileInputStream inputStream = FileUtils.openInputStream((File)settingFile);){
            String string = String.join((CharSequence)"\n", new ArrayList(IOUtils.readLines((InputStream)inputStream, (Charset)Charsets.UTF_8)));
            return string;
        }
    }

    private void write(File settingFile, String modifiedContent) throws IOException {
        try (FileOutputStream outputStream = FileUtils.openOutputStream((File)settingFile);){
            IOUtils.write((String)modifiedContent, (OutputStream)outputStream, (Charset)Charsets.UTF_8);
        }
    }

    @Override
    public void performMigration(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File sourceAuthorizationServerSettings = new File(sourceFileParentDir, fileName);
        if (sourceAuthorizationServerSettings.exists()) {
            File destinationAuthorizationServerSettings = new File(destinationFileParentDir, fileName);
            try {
                FilesUtils.copyfile(sourceAuthorizationServerSettings, destinationAuthorizationServerSettings);
            }
            catch (Exception exception) {
                log.error("Unable to migrate file " + LogHelper.getInstance().getCleanPath(sourceAuthorizationServerSettings), (Throwable)exception);
                return;
            }
            String settings = "";
            try {
                settings = this.read(destinationAuthorizationServerSettings);
            }
            catch (IOException exception) {
                throw new FileCustomActionException(String.format("Unable to update default persistent grant idle timeout to indefinite due to failure to read the OAuth Authorization Server Settings File %s because of I/O error - %s", LogHelper.getInstance().getCleanPath(destinationAuthorizationServerSettings), exception.getMessage()));
            }
            if (!settings.contains("globalPersistentGrantIdleTimeout")) {
                settings = settings.replace("<urn:OAuthConfig", "<urn:OAuthConfig globalPersistentGrantIdleTimeout=\"-1\" globalPersistentGrantIdleTimeoutTimeUnit=\"d\"");
                try {
                    this.write(destinationAuthorizationServerSettings, settings);
                }
                catch (Exception exception) {
                    throw new FileCustomActionException(String.format("Unable to update default persistent grant idle timeout to indefinite due to failure to write to the OAuth Authorization Server Settings File %s because of I/O error - %s", LogHelper.getInstance().getCleanPath(destinationAuthorizationServerSettings), exception.getMessage()));
                }
            }
            if (!settings.contains("refreshTokenRollingGracePeriod")) {
                settings = settings.replace("<urn:OAuthConfig", "<urn:OAuthConfig refreshTokenRollingGracePeriod=\"0\"");
                try {
                    this.write(destinationAuthorizationServerSettings, settings);
                }
                catch (Exception exception) {
                    throw new FileCustomActionException(String.format("Unable to update default refresh token rolling grace period to 0 due to failure to write to the OAuth Authorization Server Settings File %s because of I/O error - %s", LogHelper.getInstance().getCleanPath(destinationAuthorizationServerSettings), exception.getMessage()));
                }
            }
        }
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File destinationAuthorizationServerSettings = new File(destinationFileParentDir, fileName);
        if (destinationAuthorizationServerSettings.exists()) {
            String settings = "";
            try {
                settings = this.read(destinationAuthorizationServerSettings);
            }
            catch (IOException exception) {
                throw new FileCustomActionException(String.format("Unable to update default persistent grant idle timeout to indefinite due to failure to read the OAuth Authorization Server Settings File %s because of I/O error - %s", LogHelper.getInstance().getCleanPath(destinationAuthorizationServerSettings), exception.getMessage()));
            }
            settings = settings.replace("globalPersistentGrantIdleTimeout=\"30\"", "globalPersistentGrantIdleTimeout=\"-1\"");
            try {
                this.write(destinationAuthorizationServerSettings, settings);
            }
            catch (Exception exception) {
                throw new FileCustomActionException(String.format("Unable to update default persistent grant idle timeout to indefinite due to failure to write to the OAuth Authorization Server Settings File %s because of I/O error - %s", LogHelper.getInstance().getCleanPath(destinationAuthorizationServerSettings), exception.getMessage()));
            }
        }
        return true;
    }

    @Override
    public boolean copyIfSourceDefaultMissing() {
        return false;
    }
}

