/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom.configstorefile;

import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OidcConfigStoreCustomAction
extends ConfigStoreFileCustomAction {
    private static final Logger log = LogManager.getLogger(OidcConfigStoreCustomAction.class);

    @Override
    public boolean copyIfSourceDefaultMissing() {
        return true;
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File destFile = new File(destinationFileParentDir, fileName);
        try {
            List lines = FileUtils.readLines((File)destFile);
            List updatedLines = lines.stream().map(line -> line.contains("require-oidc-redirect-uri") ? line.replace("true", "false") : line).collect(Collectors.toList());
            FileUtils.writeLines((File)destFile, updatedLines);
        }
        catch (IOException e) {
            String msg = String.format("Unable to write the configStore file %s", fileName);
            log.warn(msg);
            throw new FileCustomActionException(msg, e);
        }
        return true;
    }
}

