/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom.configstorefile;

import com.pingidentity.common.upgrade.LogHelper;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.exception.FileCustomActionException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceDefaultMissingCustomAction
extends ConfigStoreFileCustomAction {
    private static final Logger log = LogManager.getLogger(SourceDefaultMissingCustomAction.class);
    public static final String LINE_BREAK = System.getProperty("line.separator", "\n");
    private boolean preserveDestFile = false;

    public SourceDefaultMissingCustomAction() {
    }

    public SourceDefaultMissingCustomAction(boolean preserveDestFile) {
        this.preserveDestFile = preserveDestFile;
    }

    @Override
    public boolean handleSourceFileNotFound(File sourceFileParentDir, File destinationFileParentDir, File sourceDefaultFileParentDir, String fileName) throws FileCustomActionException {
        File destFile = new File(destinationFileParentDir, fileName);
        if (!destFile.exists() || this.preserveDestFile) {
            return true;
        }
        try {
            FileUtils.write((File)destFile, (CharSequence)SourceDefaultMissingCustomAction.getTemplateContent());
            log.info("Source file does not exist, so destination file contents were replaced with default values: " + LogHelper.getInstance().getCleanPath(destFile));
        }
        catch (IOException e) {
            throw new FileCustomActionException("Source file does not exist, but unable to write default contents to destination file: " + LogHelper.getInstance().getCleanPath(destFile));
        }
        return true;
    }

    @Override
    public boolean copyIfSourceDefaultMissing() {
        return true;
    }

    private static String getTemplateContent() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append(LINE_BREAK).append("<c:config xmlns:c=\"http://www.sourceid.org/2004/05/config\">").append(LINE_BREAK).append("</c:config>");
        return sb.toString();
    }
}

