/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.upgrade.custom.configstorefile;

import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStoreFileCustomAction;
import com.pingidentity.common.upgrade.custom.configstorefile.ConfigStorePropertyCustomAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlFilterManagerCustomAction
extends ConfigStoreFileCustomAction {
    public static final String FILE_NAME = "org.sourceid.common.SqlFilterManager.xml";
    private static final Logger log = LogManager.getLogger(SqlFilterManagerCustomAction.class);
    private static final String PROPERTY_NAME = "enableSqlFilters";

    public SqlFilterManagerCustomAction(String mode) {
        this.addCustomActionForProperty(PROPERTY_NAME, new ConfigStorePropertyCustomAction(mode){

            @Override
            public boolean isUseSourceValue(Object sourceValue, Object destinationValue, Object defaultSourceValue) {
                boolean sourceBooleanValue = Boolean.parseBoolean((String)sourceValue);
                boolean useSourceValue = true;
                if (!sourceBooleanValue) {
                    if ("-c".equals(this.getMode())) {
                        String userResponse = this.promptUser();
                        useSourceValue = !userResponse.equalsIgnoreCase("y");
                    } else {
                        log.warn("SQL data stores in your environment are vulnerable to SQL Injection which can lead to information disclosure and system compromise.\nTo secure your environment update: \"<destinationPingfederateRootDir>/server/default/data/config-store/org.sourceid.common.SqlFilterManager.xml\" and set property 'enableSqlFilters' to true.");
                    }
                }
                return useSourceValue;
            }

            @Override
            public String getPromptQuestionId() {
                return "org.sourceid.common.SqlFilterManager.xml_enableSqlFilters";
            }

            @Override
            public boolean isRetainTargetProperty(Object sourceValue) {
                return true;
            }
        });
    }
}

