/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import com.pingidentity.common.util.NodeTagUtils;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class PropertyInfo {
    private static final String DEFAULT_CONTEXT_PATH = "/";

    public static String getConsoleLoginMode() {
        return System.getProperty("pf.console.login.mode");
    }

    public static String getRuntimeHttpsPort() {
        return System.getProperty("pf.https.port");
    }

    public static String getSecondaryRuntimeHttpsPort() {
        return System.getProperty("pf.secondary.https.port");
    }

    public static String getRuntimeHttpPort() {
        return System.getProperty("pf.http.port");
    }

    public static String getAdminHttpsPort() {
        return System.getProperty("pf.admin.https.port", "9999");
    }

    @Deprecated
    public static String getAdminHostname() {
        return System.getProperty("pf.admin.hostname");
    }

    public static String getAdminBaseUrl() {
        return System.getProperty("pf.admin.baseurl");
    }

    public static String getRunPropertiesLocation() {
        return System.getProperty("run.properties");
    }

    public static String getProvisionerMode() {
        return System.getProperty("pf.provisioner.mode");
    }

    public static String getClusterBindAddress() {
        return System.getProperty("pf.cluster.bind.address");
    }

    public static String getConsoleBindAddress() {
        return System.getProperty("pf.console.bind.address");
    }

    public static String getEngineBindAddress() {
        return System.getProperty("pf.engine.bind.address");
    }

    public static String getPingFederateVersion() {
        return System.getProperty("pingfederate.version");
    }

    public static String getPingFederateEnvironment() {
        return System.getProperty("pf.console.environment");
    }

    public static String getOperationalModel() {
        return System.getProperty("pf.operational.mode");
    }

    public static String getJgroupsKeySize() {
        return System.getProperty("pf.cluster.encryption.keysize", "128");
    }

    public static boolean isEventDetailLogging() {
        return Boolean.parseBoolean(System.getProperty("pf.log.eventdetail", "false"));
    }

    public static String getContextPath() {
        return System.getProperty("pf.runtime.context.path") == null ? DEFAULT_CONTEXT_PATH : System.getProperty("pf.runtime.context.path");
    }

    public static void updateRunProperties(String propertyName, String propertyValue) throws IOException {
        File runProperties = new File(PropertyInfo.getRunPropertiesLocation());
        String propertiesText = FileUtils.readFileToString((File)runProperties, (String)"UTF-8");
        String updated = PropertyInfo.updatePropertyValue(propertiesText, propertyName, propertyValue);
        FileUtils.writeStringToFile((File)runProperties, (String)updated, (String)"UTF-8");
    }

    protected static String updatePropertyValue(String propertiesText, String propertyName, String propertyValue) {
        Pattern pattern = Pattern.compile("^[ \t]*" + Pattern.quote(propertyName) + "[ \t]*=[ \t]*\\S*", 8);
        return pattern.matcher(propertiesText).replaceFirst(propertyName + "=" + propertyValue);
    }

    public static boolean isHSMHybrid() {
        return HSM_MODE.OFF != PropertyInfo.getHSMMode() && Boolean.getBoolean("pf.hsm.hybrid");
    }

    public static boolean isHSMEnableTLSv1_3(boolean defaultValue) {
        String enableTLS1_3 = StringUtils.trim((String)System.getProperty("pf.hsm.enableTLSv1_3"));
        if (enableTLS1_3 == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(enableTLS1_3);
    }

    public static HSM_MODE getHSMMode() {
        HSM_MODE mode = HSM_MODE.OFF;
        try {
            String hsmModeProperty = System.getProperty("pf.hsm.mode");
            if (hsmModeProperty != null) {
                mode = HSM_MODE.valueOf(hsmModeProperty.toUpperCase(Locale.ROOT));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mode;
    }

    public static boolean isHSM() {
        return PropertyInfo.getHSMMode() != HSM_MODE.OFF;
    }

    public static boolean isHardwareHSM() {
        HSM_MODE hsmMode = PropertyInfo.getHSMMode();
        return hsmMode != HSM_MODE.OFF && hsmMode != HSM_MODE.BCFIPS;
    }

    public static boolean isBCFIPSMode() {
        return PropertyInfo.getHSMMode() == HSM_MODE.BCFIPS;
    }

    public static String getFipsAdditionalAllowedProviders() {
        return System.getProperty("pf.fips.additional.allowed.providers");
    }

    public static boolean isFipsAllowUnapprovedAlgorithms() {
        String allowUnapproved = StringUtils.trim((String)System.getProperty("pf.fips.allow.unapproved.algorithms", "false"));
        return Boolean.parseBoolean(allowUnapproved);
    }

    public static boolean isFipsRemoveNonessentialProviders() {
        String removeNonessential = StringUtils.trim((String)System.getProperty("pf.fips.remove.nonessential.providers", "true"));
        return Boolean.parseBoolean(removeNonessential);
    }

    public static Duration getFipsSecureRandomReseedInterval() {
        String PROPERTY_NAME = "pf.fips.secure.random.reseed.interval.secs";
        int DEFAULT_INTERVAL_SECS = 300;
        String reseedInterval = StringUtils.trim((String)System.getProperty("pf.fips.secure.random.reseed.interval.secs", Integer.toString(300)));
        try {
            return Duration.ofSeconds(Integer.parseInt(reseedInterval));
        }
        catch (NumberFormatException e) {
            return Duration.ofSeconds(300L);
        }
    }

    public static boolean isAdaptiveClusteringEnabled() {
        return Boolean.parseBoolean(System.getProperty("pf.cluster.adaptive", "false"));
    }

    public static String getHsmDataDirPath() {
        return System.getProperty("pf.hsm.data.dir.path");
    }

    public static List<String> getNodeTagsFromString(String stringTags) {
        return NodeTagUtils.getNodeTagsFromString((String)stringTags);
    }

    public static List<String> getPingFederateNodeTags() {
        return PropertyInfo.getNodeTagsFromString(System.getProperty("node.tags"));
    }

    public static boolean isInstallRevocationCheckerGlobally() {
        String value = StringUtils.trim((String)System.getProperty("pf.tls.installRevocationCheckerGlobally", "true"));
        return Boolean.parseBoolean(value);
    }

    public static boolean isHSMUpdateProviderList() {
        String reorderProviders = System.getProperty("pf.hsm.update.provider.list", "true");
        return Boolean.parseBoolean(reorderProviders);
    }

    public static boolean isDataUpgradeOnStartupEnabled() {
        return Boolean.parseBoolean(System.getProperty("pf.data.upgrade.on.startup", "true"));
    }

    public static enum HSM_MODE {
        NCIPHER("HSM"),
        LUNA("HSM"),
        AWSCLOUDHSM("HSM"),
        BCFIPS("HSM"),
        OFF("Off");

        private String description;

        private HSM_MODE(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

