/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.access;

import com.pingidentity.common.util.access.ExecutionContext;
import com.pingidentity.common.util.access.ExecutionContextManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;

public final class ExecutionContextFilter
implements Filter {
    private static final String INIT_PARAM_EXECUTION_CONTEXT_NAME = "execution.context.name";
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String executionContextName = this.filterConfig.getInitParameter(INIT_PARAM_EXECUTION_CONTEXT_NAME);
        if (StringUtils.isNotBlank((String)executionContextName)) {
            ExecutionContextManager.setCurrentExecutionContext(ExecutionContext.valueOf(executionContextName));
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

