/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.access;

import com.google.common.annotations.VisibleForTesting;
import com.pingidentity.common.util.access.ExecutionContext;
import com.pingidentity.common.util.access.ExecutionContextException;
import com.pingidentity.common.util.access.ExecutionPermissions;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public final class ExecutionContextManager {
    private static ThreadLocal<ExecutionContext> currentExecutionContext = new ThreadLocal();
    private static ThreadLocal<ExecutionPermissions> overrideExecutePermission = new ThreadLocal();

    private ExecutionContextManager() {
    }

    @VisibleForTesting
    static void resetExecutionContext() {
        currentExecutionContext = new ThreadLocal();
    }

    public static ExecutionContext setCurrentExecutionContext(ExecutionContext executionContext) {
        Objects.requireNonNull(executionContext, "not null");
        if (currentExecutionContext.get() == null) {
            currentExecutionContext.set(executionContext);
        }
        return currentExecutionContext.get();
    }

    public static ExecutionContext getCurrentExecutionContext() {
        return currentExecutionContext.get();
    }

    public static void checkExecutionPermission(ExecutionPermissions executionPermissions, String errorMessage) {
        boolean hasPermission;
        Objects.requireNonNull(executionPermissions, "not null");
        boolean appliedPermissionOverride = overrideExecutePermission.get() != null && overrideExecutePermission.get().equals((Object)executionPermissions);
        boolean bl = hasPermission = currentExecutionContext.get() == null || currentExecutionContext.get().hasPermission(executionPermissions);
        if (!appliedPermissionOverride && !hasPermission) {
            String message = StringUtils.isBlank((String)errorMessage) ? "Current execution context lacks the required permission to execute this method" : errorMessage;
            throw new ExecutionContextException(message);
        }
    }

    public static void checkExecutionPermission(ExecutionPermissions executionPermissions) {
        ExecutionContextManager.checkExecutionPermission(executionPermissions, null);
    }

    public static void executeWith(ExecutionPermissions executionPermissions, Runnable runnable) {
        Objects.requireNonNull(executionPermissions, "not null");
        Objects.requireNonNull(runnable, "not null");
        overrideExecutePermission.set(executionPermissions);
        runnable.run();
        overrideExecutePermission = new ThreadLocal();
    }
}

