/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.consistent;

import java.io.Serializable;

public class Range
implements Serializable,
Comparable<Range> {
    private static final long serialVersionUID = 1L;
    private int start;
    private int end;

    public Range(int start, int end) {
        this.start = start;
        this.end = end;
        if (end <= start) {
            throw new IllegalArgumentException("End must be greater than start");
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int compareTo(Range r) {
        return Integer.compare(this.start, r.start);
    }

    public boolean overlaps(Range r) {
        return this.start < r.end && this.end > r.start;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")";
    }
}

