/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util.consistent;

import com.pingidentity.common.util.consistent.Range;
import com.pingidentity.common.util.consistent.RangeDiff;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class RangeList {
    private List<Range> ranges;

    public RangeList() {
        this.ranges = new ArrayList<Range>();
    }

    public RangeList(Collection<Range> ranges) {
        this.ranges = new ArrayList<Range>(ranges);
        this.sortAndCheckRanges();
    }

    private void sortAndCheckRanges() {
        Range prev = null;
        boolean sorted = true;
        for (Range range : this.ranges) {
            if (prev != null && prev.getStart() > range.getStart()) {
                sorted = false;
                break;
            }
            prev = range;
        }
        if (!sorted) {
            Collections.sort(this.ranges);
        }
        prev = null;
        for (Range range : this.ranges) {
            if (prev != null && prev.getEnd() > range.getStart()) {
                throw new IllegalArgumentException("Ranges " + prev + " and " + range + " overlap");
            }
            prev = range;
        }
    }

    public RangeList(Range range) {
        this.ranges = new ArrayList<Range>();
        this.ranges.add(range);
    }

    public List<Range> getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public RangeDiff getDiff(RangeList rangeList) {
        RangeList added = this.subtract(rangeList);
        RangeList dropped = rangeList.subtract(this);
        return new RangeDiff(added, dropped);
    }

    public RangeList subtract(RangeList rangeList) {
        Range right;
        ArrayList<Range> result = new ArrayList<Range>();
        ArrayDeque<Range> leftStack = new ArrayDeque<Range>(this.ranges);
        ArrayDeque<Range> rightStack = new ArrayDeque<Range>(rangeList.getRanges());
        Range left = leftStack.isEmpty() ? null : (Range)leftStack.pop();
        Range range = right = rightStack.isEmpty() ? null : (Range)rightStack.pop();
        while (left != null) {
            if (right == null) {
                result.add(left);
            } else if (right.getStart() >= left.getEnd()) {
                result.add(left);
                rightStack.push(right);
            } else if (right.getEnd() <= left.getStart()) {
                leftStack.push(left);
            } else {
                if (right.getStart() > left.getStart()) {
                    result.add(new Range(left.getStart(), right.getStart()));
                }
                if (right.getEnd() < left.getEnd()) {
                    leftStack.push(new Range(right.getEnd(), left.getEnd()));
                } else if (right.getEnd() != left.getEnd()) {
                    rightStack.push(right);
                }
            }
            left = leftStack.isEmpty() ? null : (Range)leftStack.pop();
            right = rightStack.isEmpty() ? null : (Range)rightStack.pop();
        }
        return new RangeList(result);
    }

    public RangeList add(RangeList rangeList) {
        Range right;
        ArrayList<Range> result = new ArrayList<Range>();
        ArrayDeque<Range> leftStack = new ArrayDeque<Range>(this.ranges);
        ArrayDeque<Range> rightStack = new ArrayDeque<Range>(rangeList.getRanges());
        Range left = leftStack.isEmpty() ? null : (Range)leftStack.pop();
        Range range = right = rightStack.isEmpty() ? null : (Range)rightStack.pop();
        while (left != null || right != null) {
            if (left == null) {
                result.add(right);
            } else if (right == null) {
                result.add(left);
            } else if (left.getStart() >= right.getEnd()) {
                result.add(right);
                leftStack.push(left);
            } else if (right.getStart() >= left.getEnd()) {
                result.add(left);
                rightStack.push(right);
            } else {
                int start = Math.min(left.getStart(), right.getStart());
                int end = Math.max(left.getEnd(), right.getEnd());
                Range combined = new Range(start, end);
                if (left.getEnd() >= right.getEnd()) {
                    leftStack.push(combined);
                } else {
                    rightStack.push(combined);
                }
            }
            left = leftStack.isEmpty() ? null : (Range)leftStack.pop();
            right = rightStack.isEmpty() ? null : (Range)rightStack.pop();
        }
        return new RangeList(result);
    }

    public boolean contains(Range rangeToCheck) {
        Iterator<Range> rangeIter = this.ranges.iterator();
        while (rangeIter.hasNext()) {
            Range range = rangeIter.next();
            if (range.getStart() > rangeToCheck.getStart()) {
                return false;
            }
            if (range.getEnd() >= rangeToCheck.getEnd()) {
                return true;
            }
            if (range.getEnd() <= rangeToCheck.getStart()) continue;
            while (rangeIter.hasNext()) {
                Range prevRange = range;
                range = rangeIter.next();
                if (range.getStart() > prevRange.getEnd()) {
                    return false;
                }
                if (range.getEnd() < rangeToCheck.getEnd()) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeList other = (RangeList)obj;
        return !(this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges));
    }

    public String toString() {
        if (this.ranges == null) {
            return super.toString();
        }
        return this.ranges.toString();
    }
}

