/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.common;

import org.sourceid.common.InvalidKeyReferenceException;

public class KeyReferenceParser {
    public static final String DELIMITER = ":-";
    private final String key;
    private final String defaultValue;

    public KeyReferenceParser(String keyReference) throws InvalidKeyReferenceException {
        if (keyReference.contains(DELIMITER)) {
            int delimiterIndex = keyReference.indexOf(DELIMITER);
            if (delimiterIndex == 0) {
                throw new InvalidKeyReferenceException(String.format("Invalid key reference '%s'. Key reference cannot start with the delimiter '%s'.", keyReference, DELIMITER));
            }
            this.key = keyReference.substring(0, delimiterIndex);
            this.defaultValue = keyReference.substring(delimiterIndex + DELIMITER.length());
            if (this.defaultValue.isEmpty()) {
                throw new InvalidKeyReferenceException(String.format("Invalid key reference '%s'. Missing default value.", keyReference));
            }
            if (this.defaultValue.contains("${") || this.defaultValue.contains("}")) {
                throw new InvalidKeyReferenceException(String.format("Invalid key reference '%s'. The default value cannot contain `%s` or '%s'.", keyReference, "${", "}"));
            }
        } else {
            this.key = keyReference;
            this.defaultValue = null;
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

