/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.config;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.validators.HtmlFormConfigurationValidator;
import com.pingidentity.adapters.htmlform.validators.SubPathValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.gui.AbstractSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;
import org.sourceid.saml20.adapter.gui.CaptchaProviderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.adapter.gui.LinkDescriptor;
import org.sourceid.saml20.adapter.gui.NotificationSenderFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PasswordCredentialValidatorFieldDescriptor;
import org.sourceid.saml20.adapter.gui.PolicyContractFieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.ReadOnlyDescriptor;
import org.sourceid.saml20.adapter.gui.TableDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.UploadFileFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.localidentity.LocalIdentityProfileFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.RowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.adapter.gui.validation.impl.HttpURLValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.URLValidator;

public class HtmlFormGuiConfiguration {
    private static final int SESSION_IDLE_AND_MAX_MAX = 500000;
    private static final int SESSION_IDLE_AND_MAX_MIN = 1;
    private static final int PASSWORD_UPDATE_TIMEOUT_MAX = 1440;
    private static final int PASSWORD_UPDATE_TIMEOUT_MIN = 1;
    public static final String FIELD_RETRIES = "Challenge Retries";
    public static final String DESC_RETRIES = "Number of failed user authentications after which the PingFederate account locking service blocks future attempts.";
    public static final String FIELD_LOGOUT_SUB_PATH = "Logout Path";
    public static final String FIELD_LOGIN_TEMPLATE_NAME = "Login Template";
    public static final String FIELD_LOGOUT_REDIRECT_LOCATION = "Logout Redirect";
    public static final String FIELD_LOGOUT_TEMPLATE_NAME = "Logout Template";
    public static final String FIELD_ALLOW_PASSWORD_CHANGES = "Allow Password Changes";
    public static final String FIELD_ENABLE_REMEMBER_USERNAME = "Enable 'Remember My Username'";
    public static final String FIELD_REMEMBER_USERNAME_LIFETIME = "'Remember My Username' Lifetime";
    public static final String FIELD_ENABLE_THIS_IS_MY_DEVICE = "Enable 'This is My Device'";
    public static final String FIELD_MY_DEVICE_LIFETIME = "'This is My Device' Lifetime";
    public static final String FIELD_CHANGE_PASSWORD_TEMPLATE_NAME = "Change Password Template";
    public static final String FIELD_CHANGE_PASSWORD_MESSAGE_TEMPLATE_NAME = "Change Password Message Template";
    public static final String FIELD_LOGIN_CHALLENGE_TEMPLATE_NAME = "Login Challenge Template";
    public static final String FIELD_PASSWORD_CHANGE_PWM = "Password Management System";
    public static final String FIELD_PASSWORD_CHANGE_PWM_MESSAGE_TEMPLATE_NAME = "Password Management System Message Template";
    public static final String FIELD_PASSWORD_CHANGE_REAUTH_DELAY = "Post-Password Change Re-Authentication Delay";
    public static final String FIELD_SESSION_MAX_TIMEOUT = "Session Max Timeout";
    public static final String FIELD_ALLOW_USERNAME_EDITS = "Allow Username Edits During Chaining";
    public static final String FIELD_PASSWORD_UPDATE_TIMEOUT = "Password Update Timeout";
    public static final String FIELD_FAIL_AUTHENTICATION_ON_ACCOUNT_LOCKOUT = "Fail Authentication on Account Lockout";
    public static final String DEFAULT_LOGIN_TEMPLATE_NAME = "html.form.login.template.html";
    public static final String DEFAULT_LOGOUT_TEMPLATE_NAME = "idp.logout.success.page.template.html";
    public static final boolean DEFAULT_ALLOW_PASSWORD_CHANGES = false;
    public static final boolean DEFAULT_ENABLE_REMEMBER_USERNAME = false;
    public static final boolean DEFAULT_ENABLE_THIS_IS_MY_DEVICE = false;
    public static final String DEFAULT_REMEMBER_USERNAME_LIFETIME = "30";
    public static final String DEFAULT_MY_DEVICE_LIFETIME = "30";
    public static final String DEFAULT_CHANGE_PASSWORD_TEMPLATE_NAME = "html.form.change.password.template.html";
    public static final String DEFAULT_CHANGE_PASSWORD_MESSAGE_TEMPLATE_NAME = "html.form.message.template.html";
    public static final String DEFAULT_LOGIN_CHALLENGE_TEMPLATE_NAME = "html.form.login.challenge.template.html";
    public static final String DEFAULT_PASSWORD_EXPIRY_TEMPLATE_NAME = "html.form.password.expiring.notification.template.html";
    public static final String DEFAULT_PASSWORD_CHANGE_PWM = "";
    public static final String DEFAULT_PASSWORD_CHANGE_PWM_MESSAGE_TEMPLATE_NAME = "html.form.message.template.html";
    public static final String DEFAULT_PASSWORD_CHANGE_REAUTH_DELAY = "0";
    public static final String DEFAULT_SESSION_MAX_TIMEOUT = "480";
    public static final boolean DEFAULT_ALLOW_USERNAME_EDITS = false;
    public static final boolean DEFAULT_ENABLE_EXPIRING_PASSWORD_WARNING = false;
    public static final String DEFAULT_PASSWORD_EXPIRING_WARNING_THRESHOLD = "7";
    public static final String DEFAULT_PASSWORD_EXPIRING_WARNING_DELAY = "24";
    public static final String PASSWORD_UPDATE_TIMEOUT_DEFAULT = "30";
    public static final String DESC_LOGIN_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render for login.  The default value is html.form.login.template.html.";
    public static final String DESC_LOGOUT_SUB_PATH = "Path on the PingFederate server to invoke the HTML Form Adapter logout functionality. This setting is intended for use when SLO is not desired or available, and only this adapter's session needs to be cleared. Paths specified must include the initial slash (e.g.: /mylogoutpath) and be unique across all adapter instances (including child instances). The resulting full URL will be http[s]://<pf_host>:<port>/ext/<Logout Path>.";
    public static final String DESC_LOGOUT_REDIRECT_LOCATION = "A fully qualified URL, usually at the SP, to which a user will be redirected after logout (applicable only when Logout Path is set above). When provided, this URL takes precedence over any Logout Template specified below.";
    public static final String DESC_LOGOUT_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render after logout (applicable only when Logout Path is set above and if Logout Redirect is not provided).  The default value is idp.logout.success.page.template.html.";
    public static final String DESC_ALLOW_PASSWORD_CHANGES = "Allows users to change their password using this adapter.";
    public static final String DESC_ENABLE_REMEMBER_USERNAME = "Allows users to store their username as a cookie when authenticating with this adapter. Once stored, the username is pre-populated in the login form's username field on subsequent transactions.";
    public static final String DESC_REMEMBER_USERNAME_LIFETIME = "Number of days that the username is stored. The cookie lifetime is reset upon each successful login in which the 'Remember My Username' checkbox is selected. The default is 30.";
    public static final String DESC_ENABLE_THIS_IS_MY_DEVICE = "Allows users to indicate whether their device is shared or private. In this mode, PingFederate Authentication Sessions will not be stored unless the user indicates the device is private. This adapter's internal session tracking (if enabled) will not be affected by the user's selection.";
    public static final String DESC_MY_DEVICE_LIFETIME = "Number of days that the user's 'This is My Device' selection is stored. The cookie lifetime is reset upon each successful login in which the 'This is My Device' checkbox is selected. The default is 30.";
    public static final String DESC_CHANGE_PASSWORD_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render for a user to change their password.  The default value is html.form.change.password.template.html.";
    public static final String DESC_CHANGE_PASSWORD_MESSAGE_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render when a user is being redirected after successfully changing their password. If left blank, users are redirected without explanation.  The default value is html.form.message.template.html.";
    public static final String DESC_LOGIN_CHALLENGE_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render during a strong authentication as a second step. It is used to prompt the user to answer a challenge question after they login and the RADIUS Username Password Credential Validator is an example of where it could be used. The default value is html.form.login.challenge.template.html.";
    public static final String DESC_PASSWORD_CHANGE_PWM = "A fully-qualified URL to your password management system where users can change their password. If left blank, password changes are handled by this adapter.";
    public static final String DESC_PASSWORD_CHANGE_PWM_MESSAGE_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to render when a user is being redirected to the password management system to change their password. If left blank, users are redirected without explanation.  The default value is html.form.message.template.html.";
    public static final String DESC_PASSWORD_UPDATE_TIMEOUT = "Password Update Timeout (in minutes). If left blank, the password update timeout will be disabled. The default value is 30.";
    public static final String DESC_FAIL_AUTHENTICATION_ON_ACCOUNT_LOCKOUT = "This setting determines the behavior when the user's account is locked by PingFederate due to too many failed login attempts. When checked, the adapter immediately returns an error and policy processing continues on the FAIL branch. When unchecked, the login page is displayed with an error message indicating the account is locked.";
    public static final String DESC_PASSWORD_CHANGE_REAUTH_DELAY = "Amount of time (milliseconds) to wait after a successful password change before automatically re-authenticating the user against the Password Credential Validator using the new password. The default (and minimum) value is 0. The maximum value is 60000.";
    public static final String DESC_SESSION_MAX_TIMEOUT = "Session Max Timeout (in minutes). Leave blank for indefinite sessions. Ignored if 'None' is selected for Session State.";
    public static final String ATTR_NAME_USERID = "username";
    public static final String ATTR_NAME_REQUESTEDACTION = "policy.action";
    public static final String MAX_CHALLENGE_DEFAULT = "3";
    public static final String OPTION_GLOBALLY = "Globally";
    public static final String OPTION_PER_ADAPTER_INSTANCE = "Per Adapter";
    public static final String OPTION_NONE = "None";
    public static final String DESC_SESSION_TIMEOUT = "Session Idle Timeout (in minutes). If left blank the timeout will be the Session Max Timeout. Ignored if 'None' is selected for Session State.";
    public static final String FIELD_SESSION_TIMEOUT = "Session Timeout";
    public static final String SESSION_TIMEOUT_DEFAULT = "60";
    public static final String SESSION_STATE = "Session State";
    public static final String DESC_SESSION_STATE = "Determines how state is maintained within one adapter or between different adapter instances. To take advantage of additional features, it is recommended to use a PingFederate Authentication Session rather than this adapter's internal Session State capability.";
    public static final String DESC_ALLOW_USERNAME_EDIT = "Allow users to edit the pre-populated username field in the login form. Note that this is applicable when chained behind another adapter through a Composite Adapter or in some SSO protocols, such as OpenID Connect, that give the SP a way to provide a hint about what identifier an end-user might use to log in. The default value is false.";
    public static final String FIELD_TRACK_AUTHN_TIME = "Track Authentication Time";
    public static final String DESC_TRACK_AUTHN_TIME = "Determines if the time each end user authenticated is tracked. This authentication instance information may be applied within some SSO protocols.";
    public static final String FIELD_EXPIRING_PASSWORD_WARNING_TEMPLATE_NAME = "Expiring Password Warning Template";
    public static final String DESC_EXPIRING_PASSWORD_WARNING_TEMPLATE_NAME = "HTML template (in <pf_home>/server/default/conf/template) to warn the user about approaching password expiry day. The default value is html.form.password.expiring.notification.template.html.";
    public static final String FIELD_ENABLE_EXPIRING_PASSWORD_WARNING = "Show Password Expiring Warning";
    public static final String DESC_ENABLE_EXPIRING_PASSWORD_WARNING = "Show a warning message to the user on login about an approaching password expiration.";
    public static final String FIELD_REQUIRE_REAUTHENTICATION_FOR_PASSWORD_EXPIRY_FLOW = "Require Re-Authentication For Expiring Password Flow";
    public static final String DESC_REQUIRE_REAUTHENTICATION_FOR_PASSWORD_EXPIRY_FLOW = "Requires a user to re-authenticate with their new password after completing the password expiry flow.";
    public static final boolean DEFAULT_REQUIRE_REAUTHENTICATION_FOR_PASSWORD_EXPIRY_FLOW = false;
    public static final String FIELD_EXPIRING_PASSWORD_WARNING_THRESHOLD = "Threshold for Expiring Password Warning";
    public static final String DESC_EXPIRING_PASSWORD_WARNING_THRESHOLD = "Threshold (in days) to start warning the user about approaching password expiry day. The default value is 7.";
    public static final String FIELD_EXPIRING_PASSWORD_WARNING_DELAY = "Snooze Interval for Expiring Password Warning";
    public static final String DESC_EXPIRING_PASSWORD_WARNING_DELAY = "Amount of time (in hours) to wait after a expiring password warning before the next warning. The default value is 24.";
    public static final String DESC_ENABLE_REVOKE_SESSIONS_AFTER_PASSWORD_CHANGE_RESET = "Revokes a user's authentication sessions after a password change or reset is completed by this adapter. This option relies on selecting a unique user key attribute for this adapter.";
    public static final boolean DEFAULT_ENABLE_REVOKE_SESSIONS_AFTER_PASSWORD_CHANGE_RESET = false;
    public static final String FIELD_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION = "Change Password Email Notification";
    public static final String LABEL_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION = "Change Password Notification";
    public static final String DESC_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION = "Send users a notification upon a password change. This feature relies on the underlying PCV returning 'mail' and 'givenName' attributes containing the user's first name and e-mail address. Additionally, a notification publisher must be configured.";
    public static final boolean DEFAULT_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION = false;
    public static final String DEFAULT_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME = "message-template-end-user-password-change.html";
    public static final String FIELD_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME = "Change Password Email Template";
    public static final String DESC_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a changing password email. The default value is message-template-end-user-password-change.html.";
    public static final String FIELD_RESET_TYPE = "Password Reset Type";
    public static final String DESC_RESET_TYPE = "Select the method to use for self-service password reset. Depending on the selected method, additional settings are required to complete the configuration. It is recommended that the method used is not already part of a multi-factor authentication policy that includes a password challenge, as that would indirectly reduce that authentication policy to a single factor. For example, if users normally authenticate with a password challenge and then PingID, the self-service password reset method should not be PingID.";
    public static final String DEFAULT_RESET_TYPE = "NONE";
    public static final String FIELD_RESET_TYPE_NONE_NAME = "None";
    public static final String RESET_TYPE_NONE_VALUE = "NONE";
    public static final String FIELD_RESET_TYPE_OTL_NAME = "Email One-Time Link";
    public static final String RESET_TYPE_OTL_VALUE = "OTL";
    public static final String FIELD_RESET_TYPE_OTP_NAME = "Email One-Time Password";
    public static final String RESET_TYPE_OTP_VALUE = "OTP";
    public static final String FIELD_RESET_TYPE_POLICY_NAME = "Authentication Policy";
    public static final String RESET_TYPE_POLICY_VALUE = "POLICY";
    public static final String RESET_TYPE_PINGID_NAME = "PingID";
    public static final String RESET_TYPE_PINGID_VALUE = "PingID";
    public static final String RESET_TYPE_SMS_NAME = "Text Message";
    public static final String RESET_TYPE_SMS_VALUE = "SMS";
    public static final String DEFAULT_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME = "message-template-forgot-password-link.html";
    public static final String FIELD_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME = "Password Reset One-Time Link Email Template";
    public static final String DESC_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a password reset email when password reset type is 'Email One-Time Link'. The default value is message-template-forgot-password-link.html.";
    public static final String DEFAULT_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME = "message-template-forgot-password-code.html";
    public static final String FIELD_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME = "Password Reset One-Time Password Email Template";
    public static final String DESC_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a password reset email when password reset type is 'Email One-Time Password'. The default value is message-template-forgot-password-code.html.";
    public static final String DEFAULT_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME = "message-template-account-disabled.html";
    public static final String FIELD_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME = "Account Disabled Email Template";
    public static final String DESC_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) that is used to send an account disabled email when a disabled user attempts a password reset or account unlock and the password reset type is 'Email One-Time Password' or 'Email One-Time Link'. The default value is message-template-account-disabled.html.";
    public static final String DEFAULT_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME = "message-template-forgot-password-complete.html";
    public static final String FIELD_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME = "Password Reset Complete Email Template";
    public static final String DESC_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a password reset completed email. The default value is message-template-forgot-password-complete.html.";
    public static final String DEFAULT_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME = "message-template-forgot-password-failed.html";
    public static final String FIELD_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME = "Password Reset Failed Email Template";
    public static final String DESC_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a password reset failed email. The default value is message-template-forgot-password-failed.html.";
    public static final String DEFAULT_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT = "forgot-password.html";
    public static final String FIELD_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT = "Password Reset Username Template";
    public static final String DESC_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user for their username during password reset. The default value is forgot-password.html.";
    public static final String DEFAULT_RESET_PASSWORD_TEMPLATE_CODE_INPUT = "forgot-password-resume.html";
    public static final String FIELD_RESET_PASSWORD_TEMPLATE_CODE_INPUT = "Password Reset Code Template";
    public static final String DESC_RESET_PASSWORD_TEMPLATE_CODE_INPUT = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user for a code challenge during password reset. The default value is forgot-password-resume.html.";
    public static final String DEFAULT_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT = "forgot-password-change.html";
    public static final String FIELD_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT = "Password Reset Template";
    public static final String DESC_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user to define their new password during password reset. The default value is forgot-password-change.html.";
    public static final String DEFAULT_RESET_PASSWORD_TEMPLATE_ERROR_INPUT = "forgot-password-error.html";
    public static final String FIELD_RESET_PASSWORD_TEMPLATE_ERROR_INPUT = "Password Reset Error Template";
    public static final String DESC_RESET_PASSWORD_TEMPLATE_ERROR_INPUT = "HTML template (in <pf_home>/server/default/conf/template) to render when an error occurs during password reset. The default value is forgot-password-error.html.";
    public static final String DEFAULT_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT = "forgot-password-success.html";
    public static final String FIELD_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT = "Password Reset Success Template";
    public static final String DESC_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT = "HTML template (in <pf_home>/server/default/conf/template) rendered upon a successful password reset. The default value is forgot-password-success.html.";
    public static final String FIELD_ACCOUNT_UNLOCK = "Account Unlock";
    public static final String DESC_ACCOUNT_UNLOCK = "Allows users with a locked account to unlock it using the self-service password reset type.";
    public static final String DEFAULT_ACCOUNT_UNLOCK_TEMPLATE = "account-unlock.html";
    public static final String FIELD_ACCOUNT_UNLOCK_TEMPLATE = "Account Unlock Template";
    public static final String DESC_ACCOUNT_UNLOCK_TEMPLATE = "HTML template (in <pf_home>/server/default/conf/template) rendered when a user's account is successfully unlocked. The default value is account-unlock.html.";
    public static final String DEFAULT_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME = "message-template-account-unlock-complete.html";
    public static final String FIELD_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME = "Account Unlock Email Template";
    public static final String DESC_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send an account successfully unlocked email. The default value is message-template-account-unlock-complete.html.";
    public static final String FIELD_CODE_NUMCHARS_INPUT = "OTP Length";
    public static final String DESC_CODE_NUMCHARS_INPUT = "For self-service password reset, the number of characters used in one-time passwords. Default: 8.";
    public static final String DEFAULT_CODE_NUMCHARS_INPUT = "8";
    public static final String FIELD_CODE_EXPIRATION_INPUT = "OTP Time to Live";
    public static final String DESC_CODE_EXPIRATION_INPUT = "For self-service password reset, the validity period (in minutes) for password reset tokens. Default: 10.";
    public static final String DEFAULT_CODE_EXPIRATION_INPUT = "10";
    public static final String FIELD_OTP_ALLOWED_CHARS = "Allowed OTP Character Set";
    public static final String DEFAULT_OTP_ALLOWED_CHARS = "23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz";
    public static final String DESC_OTP_ALLOWED_CHARS = "Provide a set of characters allowed to be used during one-time password generation. Default: 23456789BCDFGHJKMNPQRSTVWXZbcdfghjkmnpqrstvwxz.";
    public static final String FIELD_PINGID_PROPERTIES = "PingID Properties";
    public static final String DESC_PINGID_PROPERTIES = "For self-service password reset using PingID, upload your pingid.properties settings file from PingOne.";
    public static final String PROPERTY_BASE_64KEY = "use_base64_key";
    public static final String PROPERTY_TOKEN = "token";
    public static final String PROPERTY_ORG_ALIAS = "org_alias";
    public static final String PROPERTY_AUTHENTICATOR_URL = "authenticator_url";
    public static final String PROPERTY_ADMIN_URL = "admin_url";
    public static final String FIELD_ENABLE_USERNAME_RECOVERY = "Enable Username Recovery";
    public static final String DESC_ENABLE_USERNAME_RECOVERY = "Allow users to get their username from an email.";
    public static final String FIELD_REQUIRE_VERIFIED_EMAIL = "Require Verified Email";
    public static final String DESC_REQUIRE_VERIFIED_EMAIL = "The user\u2019s email address has to be verified before a password reset, account unlock or username recovery email is sent.";
    public static final String FIELD_USERNAME_RECOVERY_TEMPLATE = "Username Recovery Template";
    public static final String DEFAULT_USERNAME_RECOVERY_TEMPLATE = "username.recovery.template.html";
    public static final String DESC_USERNAME_RECOVERY_TEMPLATE = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user for their email address during username recovery. The default value is username.recovery.template.html.";
    public static final String FIELD_USERNAME_RECOVERY_INFO_TEMPLATE = "Username Recovery Info Template";
    public static final String DEFAULT_USERNAME_RECOVERY_INFO_TEMPLATE = "username.recovery.info.template.html";
    public static final String DESC_USERNAME_RECOVERY_INFO_TEMPLATE = "HTML template (in <pf_home>/server/default/conf/template) rendered to prompt a user to check their email for their recovered username. The default value is username.recovery.info.template.html.";
    public static final String FIELD_USERNAME_RECOVERY_EMAIL_TEMPLATE = "Username Recovery Email Template";
    public static final String DEFAULT_USERNAME_RECOVERY_EMAIL_TEMPLATE = "message-template-username-recovery.html";
    public static final String DESC_USERNAME_RECOVERY_EMAIL_TEMPLATE = "HTML email template (in <pf_home>/server/default/conf/template/mail-notifications) used to send a username recovery email. The default value is message-template-username-recovery.html.";
    public static final String FIELD_ENABLE_CAPTCHA_AUTHENTICATION = "CAPTCHA for Authentication";
    public static final String FIELD_LABEL_ENABLE_CAPTCHA_AUTHENTICATION = "Risk for Authentication";
    public static final String DESC_ENABLE_CAPTCHA_AUTHENTICATION = "Risk can be enabled for the login form to prevent automated attacks.";
    public static final boolean DEFAULT_ENABLE_CAPTCHA_AUTHENTICATION = false;
    public static final String FIELD_ENABLE_CAPTCHA_USERNAME_RECOVERY = "CAPTCHA for Username recovery";
    public static final String FIELD_LABEL_ENABLE_CAPTCHA_USERNAME_RECOVERY = "Risk for Username Recovery";
    public static final String DESC_ENABLE_CAPTCHA_USERNAME_RECOVERY = "Risk can be enabled for username recovery features to prevent automated attacks.";
    public static final boolean DEFAULT_ENABLE_CAPTCHA_USERNAME_RECOVERY = false;
    public static final String FIELD_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK = "CAPTCHA for Password Reset";
    public static final String FIELD_LABEL_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK = "Risk for Password Reset";
    public static final String DESC_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK = "Risk can be enabled for password reset and account unlock features to prevent automated attacks.";
    public static final boolean DEFAULT_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK = false;
    public static final String FIELD_ENABLE_CAPTCHA_PASSWORD_CHANGE = "CAPTCHA for Password change";
    public static final String FIELD_LABEL_ENABLE_CAPTCHA_PASSWORD_CHANGE = "Risk for Password Change";
    public static final String DESC_ENABLE_CAPTCHA_PASSWORD_CHANGE = "Risk can be enabled for the password change form to prevent automated attacks.";
    public static final boolean DEFAULT_ENABLE_CAPTCHA_PASSWORD_CHANGE = false;
    private static final String FIELD_CHANGE_PASSWORD_ENDPOINT = "Change Password Endpoint";
    private static final String FIELD_ACCOUNT_RECOVERY_ENDPOINT = "Account Recovery Endpoint";
    private static final String FIELD_USERNAME_RECOVERY_ENDPOINT = "Username Recovery Endpoint";
    private static final String CHANGE_PASSWORD_ENDPOINT = "${baseUrl}/ext/pwdchange/Identify?AdapterId=${pluginId}";
    private static final String PASSWORD_RESET_ENDPOINT = "${baseUrl}/ext/pwdreset/Identify?AdapterId=${pluginId}";
    private static final String USERNAME_RECOVERY_ENDPOINT = "${baseUrl}/ext/idrecovery/Recover?AdapterId=${pluginId}";
    public static final String FIELD_RE_AUTHENTICATE_AFTER_CHANGE_PASSWORD = "Require Re-Authentication for Change Password Flow";
    private static final String DESC_RE_AUTHENTICATE_AFTER_CHANGE_PASSWORD = "Requires a user to re-authenticate with their new password after completing a successful change password flow.";
    public static final boolean DEFAULT_RE_AUTHENTICATE_AFTER_CHANGE_PASSWORD = false;
    public static final String FIELD_RE_AUTHENTICATE_AFTER_PASSWORD_RESET = "Require Re-Authentication for Password Reset Flow";
    private static final String DESC_RE_AUTHENTICATE_AFTER_PASSWORD_RESET = "Requires a user to re-authenticate with their new password after completing a successful password reset or account unlock flow.";
    public static final boolean DEFAULT_RE_AUTHENTICATE_AFTER_PASSWORD_RESET = false;

    public AdapterConfigurationGuiDescriptor getGuiDescriptor() {
        AdapterConfigurationGuiDescriptor guiDescriptor = new AdapterConfigurationGuiDescriptor();
        TableDescriptor pcvTable = new TableDescriptor("Credential Validators", "A list of Password Credential Validators to be used for authentication.");
        guiDescriptor.addTable(pcvTable);
        PasswordCredentialValidatorFieldDescriptor pcvField = new PasswordCredentialValidatorFieldDescriptor("Password Credential Validator Instance", DEFAULT_PASSWORD_CHANGE_PWM);
        pcvField.addValidator((FieldValidator)new RequiredFieldValidator());
        pcvTable.addRowField((FieldDescriptor)pcvField);
        pcvTable.addValidator((RowValidator)new PcvRowValidator());
        TextFieldDescriptor retries = new TextFieldDescriptor(FIELD_RETRIES, DESC_RETRIES);
        retries.addValidator((FieldValidator)new RequiredFieldValidator());
        retries.addValidator((FieldValidator)new IntegerValidator(1, 100));
        retries.setDefaultValue(MAX_CHALLENGE_DEFAULT);
        guiDescriptor.addField((FieldDescriptor)retries);
        String[] options = new String[]{OPTION_GLOBALLY, OPTION_PER_ADAPTER_INSTANCE, "None"};
        RadioGroupFieldDescriptor sessionState = new RadioGroupFieldDescriptor(SESSION_STATE, DESC_SESSION_STATE, options);
        sessionState.setDefaultValue("None");
        guiDescriptor.addField((FieldDescriptor)sessionState);
        TextFieldDescriptor sessionTimeout = new TextFieldDescriptor(FIELD_SESSION_TIMEOUT, DESC_SESSION_TIMEOUT);
        sessionTimeout.setDefaultValue(SESSION_TIMEOUT_DEFAULT);
        sessionTimeout.addValidator((FieldValidator)new IntegerValidator(1, 500000), true);
        guiDescriptor.addField((FieldDescriptor)sessionTimeout);
        TextFieldDescriptor sessionMaxTimeout = new TextFieldDescriptor(FIELD_SESSION_MAX_TIMEOUT, DESC_SESSION_MAX_TIMEOUT);
        sessionMaxTimeout.setDefaultValue(DEFAULT_SESSION_MAX_TIMEOUT);
        sessionMaxTimeout.addValidator((FieldValidator)new IntegerValidator(1, 500000), true);
        guiDescriptor.addField((FieldDescriptor)sessionMaxTimeout);
        TextFieldDescriptor loginTemplateName = new TextFieldDescriptor(FIELD_LOGIN_TEMPLATE_NAME, DESC_LOGIN_TEMPLATE_NAME);
        loginTemplateName.addValidator((FieldValidator)new RequiredFieldValidator());
        loginTemplateName.setDefaultValue(DEFAULT_LOGIN_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)loginTemplateName);
        TextFieldDescriptor logoutSubPath = new TextFieldDescriptor(FIELD_LOGOUT_SUB_PATH, DESC_LOGOUT_SUB_PATH);
        logoutSubPath.setDefaultValue(null);
        logoutSubPath.addValidator((FieldValidator)new SubPathValidator(), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)logoutSubPath);
        TextFieldDescriptor logoutRedirectLocation = new TextFieldDescriptor(FIELD_LOGOUT_REDIRECT_LOCATION, DESC_LOGOUT_REDIRECT_LOCATION);
        logoutRedirectLocation.setDefaultValue(null);
        logoutRedirectLocation.addValidator((FieldValidator)new URLValidator(true), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)logoutRedirectLocation);
        TextFieldDescriptor logoutTemplateName = new TextFieldDescriptor(FIELD_LOGOUT_TEMPLATE_NAME, DESC_LOGOUT_TEMPLATE_NAME);
        logoutTemplateName.setDefaultValue(DEFAULT_LOGOUT_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)logoutTemplateName);
        CheckBoxFieldDescriptor allowPasswordChanges = new CheckBoxFieldDescriptor(FIELD_ALLOW_PASSWORD_CHANGES, DESC_ALLOW_PASSWORD_CHANGES);
        allowPasswordChanges.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)allowPasswordChanges);
        TextFieldDescriptor changePasswordTemplateName = new TextFieldDescriptor(FIELD_CHANGE_PASSWORD_TEMPLATE_NAME, DESC_CHANGE_PASSWORD_TEMPLATE_NAME);
        changePasswordTemplateName.setDefaultValue(DEFAULT_CHANGE_PASSWORD_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)changePasswordTemplateName);
        TextFieldDescriptor changePasswordMessageTemplateName = new TextFieldDescriptor(FIELD_CHANGE_PASSWORD_MESSAGE_TEMPLATE_NAME, DESC_CHANGE_PASSWORD_MESSAGE_TEMPLATE_NAME);
        changePasswordMessageTemplateName.setDefaultValue("html.form.message.template.html");
        guiDescriptor.addAdvancedField((FieldDescriptor)changePasswordMessageTemplateName);
        TextFieldDescriptor pwmURL = new TextFieldDescriptor(FIELD_PASSWORD_CHANGE_PWM, DESC_PASSWORD_CHANGE_PWM);
        pwmURL.setDefaultValue(DEFAULT_PASSWORD_CHANGE_PWM);
        pwmURL.addValidator((FieldValidator)new HttpURLValidator(), true);
        guiDescriptor.addField((FieldDescriptor)pwmURL);
        TextFieldDescriptor pwmMessageTemplateName = new TextFieldDescriptor(FIELD_PASSWORD_CHANGE_PWM_MESSAGE_TEMPLATE_NAME, DESC_PASSWORD_CHANGE_PWM_MESSAGE_TEMPLATE_NAME);
        pwmMessageTemplateName.setDefaultValue("html.form.message.template.html");
        guiDescriptor.addAdvancedField((FieldDescriptor)pwmMessageTemplateName);
        CheckBoxFieldDescriptor enableRememberUsername = new CheckBoxFieldDescriptor(FIELD_ENABLE_REMEMBER_USERNAME, DESC_ENABLE_REMEMBER_USERNAME);
        enableRememberUsername.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableRememberUsername);
        CheckBoxFieldDescriptor enableMyDevice = new CheckBoxFieldDescriptor(FIELD_ENABLE_THIS_IS_MY_DEVICE, DESC_ENABLE_THIS_IS_MY_DEVICE);
        enableRememberUsername.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableMyDevice);
        PolicyContractFieldDescriptor changePasswordPolicyContractSelectFieldDescriptor = new PolicyContractFieldDescriptor("Change Password Policy Contract", "The policy contract to use for change password. Selecting a policy contract will enable usage of Authentication Policy during password change.");
        changePasswordPolicyContractSelectFieldDescriptor.addValidator((FieldValidator)new FilterableSelectionFieldDescriptor.FilterableSelectionFieldDefaultValidator((FilterableSelectionFieldDescriptor)changePasswordPolicyContractSelectFieldDescriptor), true);
        guiDescriptor.addField((FieldDescriptor)changePasswordPolicyContractSelectFieldDescriptor);
        CheckBoxFieldDescriptor enablePasswordChangeNotification = new CheckBoxFieldDescriptor(FIELD_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION, DESC_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION);
        enablePasswordChangeNotification.setLabel(LABEL_ENABLE_CHANGE_PASSWORD_EMAIL_NOTIFICATION);
        allowPasswordChanges.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enablePasswordChangeNotification);
        CheckBoxFieldDescriptor enableExpiringPasswordWarning = new CheckBoxFieldDescriptor(FIELD_ENABLE_EXPIRING_PASSWORD_WARNING, DESC_ENABLE_EXPIRING_PASSWORD_WARNING);
        enableExpiringPasswordWarning.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableExpiringPasswordWarning);
        TextFieldDescriptor passwordUpdateTimeout = new TextFieldDescriptor(FIELD_PASSWORD_UPDATE_TIMEOUT, DESC_PASSWORD_UPDATE_TIMEOUT);
        passwordUpdateTimeout.setDefaultValue("30");
        passwordUpdateTimeout.addValidator((FieldValidator)new IntegerValidator(1, 1440), true);
        guiDescriptor.addAdvancedField((FieldDescriptor)passwordUpdateTimeout);
        TextFieldDescriptor changePasswordEmailNotificationTemplateName = new TextFieldDescriptor(FIELD_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME, DESC_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME);
        changePasswordEmailNotificationTemplateName.setDefaultValue(DEFAULT_CHANGE_PASSWORD_EMAIL_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)changePasswordEmailNotificationTemplateName);
        TextFieldDescriptor expiringPasswordWarningTemplateName = new TextFieldDescriptor(FIELD_EXPIRING_PASSWORD_WARNING_TEMPLATE_NAME, DESC_EXPIRING_PASSWORD_WARNING_TEMPLATE_NAME);
        expiringPasswordWarningTemplateName.setDefaultValue(DEFAULT_PASSWORD_EXPIRY_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)expiringPasswordWarningTemplateName);
        TextFieldDescriptor expiringPasswordWarningThresholdDays = new TextFieldDescriptor(FIELD_EXPIRING_PASSWORD_WARNING_THRESHOLD, DESC_EXPIRING_PASSWORD_WARNING_THRESHOLD);
        expiringPasswordWarningThresholdDays.setDefaultValue(DEFAULT_PASSWORD_EXPIRING_WARNING_THRESHOLD);
        guiDescriptor.addAdvancedField((FieldDescriptor)expiringPasswordWarningThresholdDays);
        TextFieldDescriptor expiringPasswordWarningDelay = new TextFieldDescriptor(FIELD_EXPIRING_PASSWORD_WARNING_DELAY, DESC_EXPIRING_PASSWORD_WARNING_DELAY);
        expiringPasswordWarningDelay.setDefaultValue(DEFAULT_PASSWORD_EXPIRING_WARNING_DELAY);
        guiDescriptor.addAdvancedField((FieldDescriptor)expiringPasswordWarningDelay);
        CheckBoxFieldDescriptor reAuthenticate = new CheckBoxFieldDescriptor(FIELD_REQUIRE_REAUTHENTICATION_FOR_PASSWORD_EXPIRY_FLOW, DESC_REQUIRE_REAUTHENTICATION_FOR_PASSWORD_EXPIRY_FLOW);
        reAuthenticate.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)reAuthenticate);
        CheckBoxFieldDescriptor reAuthenticateAfterChangePassword = new CheckBoxFieldDescriptor(FIELD_RE_AUTHENTICATE_AFTER_CHANGE_PASSWORD, DESC_RE_AUTHENTICATE_AFTER_CHANGE_PASSWORD);
        reAuthenticateAfterChangePassword.setDefaultValue(false);
        reAuthenticateAfterChangePassword.setDefaultForLegacyConfig(String.valueOf(true));
        guiDescriptor.addAdvancedField((FieldDescriptor)reAuthenticateAfterChangePassword);
        CheckBoxFieldDescriptor reAuthenticateAfterPasswordReset = new CheckBoxFieldDescriptor(FIELD_RE_AUTHENTICATE_AFTER_PASSWORD_RESET, DESC_RE_AUTHENTICATE_AFTER_PASSWORD_RESET);
        reAuthenticateAfterPasswordReset.setDefaultValue(false);
        reAuthenticateAfterPasswordReset.setDefaultForLegacyConfig(String.valueOf(true));
        guiDescriptor.addAdvancedField((FieldDescriptor)reAuthenticateAfterPasswordReset);
        TextFieldDescriptor loginChallengeTemplateName = new TextFieldDescriptor(FIELD_LOGIN_CHALLENGE_TEMPLATE_NAME, DESC_LOGIN_CHALLENGE_TEMPLATE_NAME);
        loginChallengeTemplateName.setDefaultValue(DEFAULT_LOGIN_CHALLENGE_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)loginChallengeTemplateName);
        TextFieldDescriptor rememberUsernameLifetime = new TextFieldDescriptor(FIELD_REMEMBER_USERNAME_LIFETIME, DESC_REMEMBER_USERNAME_LIFETIME);
        rememberUsernameLifetime.setDefaultValue("30");
        guiDescriptor.addAdvancedField((FieldDescriptor)rememberUsernameLifetime);
        TextFieldDescriptor myDeviceLifetime = new TextFieldDescriptor(FIELD_MY_DEVICE_LIFETIME, DESC_MY_DEVICE_LIFETIME);
        myDeviceLifetime.setDefaultValue("30");
        myDeviceLifetime.setDefaultForLegacyConfig("30");
        guiDescriptor.addAdvancedField((FieldDescriptor)myDeviceLifetime);
        CheckBoxFieldDescriptor allowUsernameEdits = new CheckBoxFieldDescriptor(FIELD_ALLOW_USERNAME_EDITS, DESC_ALLOW_USERNAME_EDIT);
        allowUsernameEdits.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)allowUsernameEdits);
        CheckBoxFieldDescriptor trackAuthnTime = new CheckBoxFieldDescriptor(FIELD_TRACK_AUTHN_TIME, DESC_TRACK_AUTHN_TIME);
        trackAuthnTime.setDefaultValue(true);
        guiDescriptor.addAdvancedField((FieldDescriptor)trackAuthnTime);
        TextFieldDescriptor pwChangeReauthDelay = new TextFieldDescriptor(FIELD_PASSWORD_CHANGE_REAUTH_DELAY, DESC_PASSWORD_CHANGE_REAUTH_DELAY);
        pwChangeReauthDelay.setDefaultValue(DEFAULT_PASSWORD_CHANGE_REAUTH_DELAY);
        pwChangeReauthDelay.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 20121113L;
            private static final int lowerBound = 0;
            private static final int upperBound = 60000;

            public void validate(Field field) throws ValidationException {
                if (field.getValue() != null && field.getValue().length() != 0) {
                    IntegerValidator validator = new IntegerValidator(0, 60000);
                    validator.validate(field);
                }
            }
        });
        guiDescriptor.addAdvancedField((FieldDescriptor)pwChangeReauthDelay);
        ArrayList<AbstractSelectionFieldDescriptor.OptionValue> forgotPwdOptions = new ArrayList<AbstractSelectionFieldDescriptor.OptionValue>();
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_RESET_TYPE_POLICY_NAME, RESET_TYPE_POLICY_VALUE));
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_RESET_TYPE_OTL_NAME, RESET_TYPE_OTL_VALUE));
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(FIELD_RESET_TYPE_OTP_NAME, RESET_TYPE_OTP_VALUE));
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("PingID", "PingID"));
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue(RESET_TYPE_SMS_NAME, RESET_TYPE_SMS_VALUE));
        forgotPwdOptions.add(new AbstractSelectionFieldDescriptor.OptionValue("None", "NONE"));
        RadioGroupFieldDescriptor forgotPwdRadioGroup = new RadioGroupFieldDescriptor(FIELD_RESET_TYPE, DESC_RESET_TYPE, forgotPwdOptions);
        forgotPwdRadioGroup.setDefaultValue("NONE");
        forgotPwdRadioGroup.setDefaultForLegacyConfig("NONE");
        guiDescriptor.addField((FieldDescriptor)forgotPwdRadioGroup);
        PolicyContractFieldDescriptor policyContractSelectFieldDescriptor = new PolicyContractFieldDescriptor("Password Reset Policy Contract", "The policy contract to use for password reset.  This is used for the password reset type 'Authentication Policy'.");
        policyContractSelectFieldDescriptor.addValidator((FieldValidator)new FilterableSelectionFieldDescriptor.FilterableSelectionFieldDefaultValidator((FilterableSelectionFieldDescriptor)policyContractSelectFieldDescriptor), true);
        guiDescriptor.addField((FieldDescriptor)policyContractSelectFieldDescriptor);
        CheckBoxFieldDescriptor enableRevokeSessionsOnPwdChgReset = new CheckBoxFieldDescriptor("Revoke Sessions After Password Change Or Reset", DESC_ENABLE_REVOKE_SESSIONS_AFTER_PASSWORD_CHANGE_RESET);
        enableRevokeSessionsOnPwdChgReset.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableRevokeSessionsOnPwdChgReset);
        CheckBoxFieldDescriptor enableUnlock = new CheckBoxFieldDescriptor(FIELD_ACCOUNT_UNLOCK, DESC_ACCOUNT_UNLOCK);
        enableUnlock.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableUnlock);
        LocalIdentityProfileFieldDescriptor lipSelectFieldDescriptor = new LocalIdentityProfileFieldDescriptor("Local Identity Profile", "Optionally associate this instance with a Local Identity Profile.");
        guiDescriptor.addField((FieldDescriptor)lipSelectFieldDescriptor);
        NotificationSenderFieldDescriptor notificationSenderFieldDescriptor = new NotificationSenderFieldDescriptor("Notification Publisher", "Optionally associate this instance with a notification delivery mechanism.");
        notificationSenderFieldDescriptor.setDefaultValue(NotificationSenderFieldDescriptor.DEFAULT.getValue());
        guiDescriptor.addField((FieldDescriptor)notificationSenderFieldDescriptor);
        TextFieldDescriptor forgotPasswordOtlEmailTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME, DESC_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordOtlEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordOtlEmailTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_EMAIL_OTL_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)forgotPasswordOtlEmailTemplateName);
        TextFieldDescriptor forgotPasswordOtpEmailTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME, DESC_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordOtpEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordOtpEmailTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_EMAIL_OTP_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)forgotPasswordOtpEmailTemplateName);
        TextFieldDescriptor accountDisabledEmailTemplateName = new TextFieldDescriptor(FIELD_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME, DESC_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME);
        accountDisabledEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME);
        accountDisabledEmailTemplateName.setDefaultValue(DEFAULT_ACCOUNT_DISABLED_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)accountDisabledEmailTemplateName);
        TextFieldDescriptor forgotPasswordCompleteEmailTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME, DESC_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordCompleteEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordCompleteEmailTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_EMAIL_COMPLETE_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)forgotPasswordCompleteEmailTemplateName);
        TextFieldDescriptor forgotPasswordFailEmailTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME, DESC_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordFailEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME);
        forgotPasswordFailEmailTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_EMAIL_FAILED_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)forgotPasswordFailEmailTemplateName);
        TextFieldDescriptor forgotPasswordTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT, DESC_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT);
        forgotPasswordTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_TEMPLATE_USERNAME_INPUT);
        guiDescriptor.addAdvancedField((FieldDescriptor)forgotPasswordTemplateName);
        TextFieldDescriptor codeTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_TEMPLATE_CODE_INPUT, DESC_RESET_PASSWORD_TEMPLATE_CODE_INPUT);
        codeTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_TEMPLATE_CODE_INPUT);
        guiDescriptor.addAdvancedField((FieldDescriptor)codeTemplateName);
        TextFieldDescriptor changeTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT, DESC_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT);
        changeTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_TEMPLATE_CHANGE_INPUT);
        guiDescriptor.addAdvancedField((FieldDescriptor)changeTemplateName);
        TextFieldDescriptor errorTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_TEMPLATE_ERROR_INPUT, DESC_RESET_PASSWORD_TEMPLATE_ERROR_INPUT);
        errorTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_TEMPLATE_ERROR_INPUT);
        guiDescriptor.addAdvancedField((FieldDescriptor)errorTemplateName);
        TextFieldDescriptor successTemplateName = new TextFieldDescriptor(FIELD_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT, DESC_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT);
        successTemplateName.setDefaultValue(DEFAULT_RESET_PASSWORD_TEMPLATE_SUCCESS_INPUT);
        guiDescriptor.addAdvancedField((FieldDescriptor)successTemplateName);
        TextFieldDescriptor accountUnlockTemplateName = new TextFieldDescriptor(FIELD_ACCOUNT_UNLOCK_TEMPLATE, DESC_ACCOUNT_UNLOCK_TEMPLATE);
        accountUnlockTemplateName.setDefaultValue(DEFAULT_ACCOUNT_UNLOCK_TEMPLATE);
        guiDescriptor.addAdvancedField((FieldDescriptor)accountUnlockTemplateName);
        TextFieldDescriptor accountUnlockEmailTemplateName = new TextFieldDescriptor(FIELD_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME, DESC_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME);
        accountUnlockEmailTemplateName.setDefaultForLegacyConfig(DEFAULT_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME);
        accountUnlockEmailTemplateName.setDefaultValue(DEFAULT_ACCOUNT_UNLOCK_EMAIL_NOTIFICATION_TEMPLATE_NAME);
        guiDescriptor.addAdvancedField((FieldDescriptor)accountUnlockEmailTemplateName);
        TextFieldDescriptor numChars = new TextFieldDescriptor(FIELD_CODE_NUMCHARS_INPUT, DESC_CODE_NUMCHARS_INPUT);
        numChars.setDefaultValue(DEFAULT_CODE_NUMCHARS_INPUT);
        numChars.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 1L;
            private static final int lowerBound = 5;
            private static final int upperBound = 100;

            public void validate(Field field) throws ValidationException {
                if (field.getValue() != null && field.getValue().length() != 0) {
                    IntegerValidator validator = new IntegerValidator(5, 100);
                    validator.validate(field);
                }
            }
        });
        guiDescriptor.addAdvancedField((FieldDescriptor)numChars);
        TextFieldDescriptor otpAllowedChars = new TextFieldDescriptor(FIELD_OTP_ALLOWED_CHARS, DESC_OTP_ALLOWED_CHARS);
        otpAllowedChars.setDefaultValue(DEFAULT_OTP_ALLOWED_CHARS);
        otpAllowedChars.setDefaultForLegacyConfig(DEFAULT_OTP_ALLOWED_CHARS);
        otpAllowedChars.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 1L;
            private static final int minLength = 10;

            public void validate(Field field) throws ValidationException {
                String value;
                String string = value = field.getValue() == null ? null : field.getValue().trim();
                if (value != null && value.length() != 0 && value.length() < 10) {
                    throw new ValidationException(" 'Allowed OTP Character Set' has to have at least 10 characters.");
                }
            }
        });
        otpAllowedChars.setLabel(FIELD_OTP_ALLOWED_CHARS);
        guiDescriptor.addAdvancedField((FieldDescriptor)otpAllowedChars);
        TextFieldDescriptor expiration = new TextFieldDescriptor(FIELD_CODE_EXPIRATION_INPUT, DESC_CODE_EXPIRATION_INPUT);
        expiration.setDefaultValue(DEFAULT_CODE_EXPIRATION_INPUT);
        expiration.addValidator(new FieldValidator(){
            private static final long serialVersionUID = 1L;
            private static final int lowerBound = 1;
            private static final int upperBound = 4320;

            public void validate(Field field) throws ValidationException {
                if (field.getValue() != null && field.getValue().length() != 0) {
                    IntegerValidator validator = new IntegerValidator(1, 4320);
                    validator.validate(field);
                }
            }
        });
        expiration.setLabel("Password Reset Token Validity Time");
        guiDescriptor.addAdvancedField((FieldDescriptor)expiration);
        UploadFileFieldDescriptor pingidPropertiesField = new UploadFileFieldDescriptor(FIELD_PINGID_PROPERTIES, DESC_PINGID_PROPERTIES, true);
        guiDescriptor.addAdvancedField((FieldDescriptor)pingidPropertiesField);
        guiDescriptor.addValidator((ConfigurationValidator)new HtmlFormConfigurationValidator());
        CheckBoxFieldDescriptor enableUsernameRecovery = new CheckBoxFieldDescriptor(FIELD_ENABLE_USERNAME_RECOVERY, DESC_ENABLE_USERNAME_RECOVERY);
        enableUsernameRecovery.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        enableUsernameRecovery.setDefaultValue(false);
        guiDescriptor.addField((FieldDescriptor)enableUsernameRecovery);
        CheckBoxFieldDescriptor requireVerifiedEmail = new CheckBoxFieldDescriptor(FIELD_REQUIRE_VERIFIED_EMAIL, DESC_REQUIRE_VERIFIED_EMAIL);
        requireVerifiedEmail.setDefaultValue(false);
        requireVerifiedEmail.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        guiDescriptor.addAdvancedField((FieldDescriptor)requireVerifiedEmail);
        TextFieldDescriptor usernameRecoveryTemplate = new TextFieldDescriptor(FIELD_USERNAME_RECOVERY_TEMPLATE, DESC_USERNAME_RECOVERY_TEMPLATE);
        usernameRecoveryTemplate.setDefaultValue(DEFAULT_USERNAME_RECOVERY_TEMPLATE);
        usernameRecoveryTemplate.setDefaultForLegacyConfig(DEFAULT_USERNAME_RECOVERY_TEMPLATE);
        guiDescriptor.addAdvancedField((FieldDescriptor)usernameRecoveryTemplate);
        TextFieldDescriptor usernameRecoveryInfoTemplate = new TextFieldDescriptor(FIELD_USERNAME_RECOVERY_INFO_TEMPLATE, DESC_USERNAME_RECOVERY_INFO_TEMPLATE);
        usernameRecoveryInfoTemplate.setDefaultValue(DEFAULT_USERNAME_RECOVERY_INFO_TEMPLATE);
        usernameRecoveryInfoTemplate.setDefaultForLegacyConfig(DEFAULT_USERNAME_RECOVERY_INFO_TEMPLATE);
        guiDescriptor.addAdvancedField((FieldDescriptor)usernameRecoveryInfoTemplate);
        TextFieldDescriptor usernameRecoveryEmailTemplate = new TextFieldDescriptor(FIELD_USERNAME_RECOVERY_EMAIL_TEMPLATE, DESC_USERNAME_RECOVERY_EMAIL_TEMPLATE);
        usernameRecoveryEmailTemplate.setDefaultValue(DEFAULT_USERNAME_RECOVERY_EMAIL_TEMPLATE);
        usernameRecoveryEmailTemplate.setDefaultForLegacyConfig(DEFAULT_USERNAME_RECOVERY_EMAIL_TEMPLATE);
        guiDescriptor.addAdvancedField((FieldDescriptor)usernameRecoveryEmailTemplate);
        CaptchaProviderFieldDescriptor captchaProviderFieldDescriptor = new CaptchaProviderFieldDescriptor("CAPTCHA Provider", "Optionally associate this instance with a Risk Provider service.");
        captchaProviderFieldDescriptor.setDefaultValue(CaptchaProviderFieldDescriptor.DEFAULT.getValue());
        captchaProviderFieldDescriptor.setLabel("Risk Provider");
        guiDescriptor.addAdvancedField((FieldDescriptor)captchaProviderFieldDescriptor);
        CheckBoxFieldDescriptor enableCaptchaAuthentication = new CheckBoxFieldDescriptor(FIELD_ENABLE_CAPTCHA_AUTHENTICATION, DESC_ENABLE_CAPTCHA_AUTHENTICATION);
        enableCaptchaAuthentication.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        enableCaptchaAuthentication.setLabel(FIELD_LABEL_ENABLE_CAPTCHA_AUTHENTICATION);
        enableCaptchaAuthentication.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)enableCaptchaAuthentication);
        CheckBoxFieldDescriptor enableCaptchaPasswordChange = new CheckBoxFieldDescriptor(FIELD_ENABLE_CAPTCHA_PASSWORD_CHANGE, DESC_ENABLE_CAPTCHA_PASSWORD_CHANGE);
        enableCaptchaPasswordChange.setLabel(FIELD_LABEL_ENABLE_CAPTCHA_PASSWORD_CHANGE);
        enableCaptchaPasswordChange.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        enableCaptchaPasswordChange.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)enableCaptchaPasswordChange);
        CheckBoxFieldDescriptor enableCaptchaAccountUnlock = new CheckBoxFieldDescriptor(FIELD_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK, DESC_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK);
        enableCaptchaAccountUnlock.setLabel(FIELD_LABEL_ENABLE_CAPTCHA_PASS_RESET_ACCOUNT_UNLOCK);
        enableCaptchaAccountUnlock.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        enableCaptchaAccountUnlock.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)enableCaptchaAccountUnlock);
        CheckBoxFieldDescriptor enableCaptchaUsernameRecovery = new CheckBoxFieldDescriptor(FIELD_ENABLE_CAPTCHA_USERNAME_RECOVERY, DESC_ENABLE_CAPTCHA_USERNAME_RECOVERY);
        enableCaptchaUsernameRecovery.setLabel(FIELD_LABEL_ENABLE_CAPTCHA_USERNAME_RECOVERY);
        enableCaptchaUsernameRecovery.setDefaultForLegacyConfig(Boolean.FALSE.toString());
        enableCaptchaUsernameRecovery.setDefaultValue(false);
        guiDescriptor.addAdvancedField((FieldDescriptor)enableCaptchaUsernameRecovery);
        CheckBoxFieldDescriptor failAuthenticationOnAccountLockout = new CheckBoxFieldDescriptor(FIELD_FAIL_AUTHENTICATION_ON_ACCOUNT_LOCKOUT, DESC_FAIL_AUTHENTICATION_ON_ACCOUNT_LOCKOUT);
        failAuthenticationOnAccountLockout.setDefaultValue(false);
        failAuthenticationOnAccountLockout.setDefaultForLegacyConfig("true");
        guiDescriptor.addAdvancedField((FieldDescriptor)failAuthenticationOnAccountLockout);
        LinkDescriptor changePasswordDirectLink = new LinkDescriptor(FIELD_CHANGE_PASSWORD_ENDPOINT, CHANGE_PASSWORD_ENDPOINT);
        guiDescriptor.addSummaryDescriptor((ReadOnlyDescriptor)changePasswordDirectLink);
        LinkDescriptor passwordResetDirectLink = new LinkDescriptor(FIELD_ACCOUNT_RECOVERY_ENDPOINT, PASSWORD_RESET_ENDPOINT);
        guiDescriptor.addSummaryDescriptor((ReadOnlyDescriptor)passwordResetDirectLink);
        LinkDescriptor usernameRecoveryDirectLink = new LinkDescriptor(FIELD_USERNAME_RECOVERY_ENDPOINT, USERNAME_RECOVERY_ENDPOINT);
        guiDescriptor.addSummaryDescriptor((ReadOnlyDescriptor)usernameRecoveryDirectLink);
        guiDescriptor.addPreRenderCallback(new PreRenderCallback(){

            public void summaryPageCallback(List<ReadOnlyDescriptor> summaryFields, Configuration configuration) {
                Iterator<ReadOnlyDescriptor> iterator = summaryFields.iterator();
                while (iterator.hasNext()) {
                    ReadOnlyDescriptor descriptor = iterator.next();
                    if (HtmlFormGuiConfiguration.FIELD_CHANGE_PASSWORD_ENDPOINT.equals(descriptor.getName())) {
                        if (!configuration.getBooleanFieldValue(HtmlFormGuiConfiguration.FIELD_ALLOW_PASSWORD_CHANGES)) {
                            iterator.remove();
                            continue;
                        }
                        if (!(descriptor instanceof LinkDescriptor)) continue;
                        String pwdChgMgmtUrl = configuration.getFieldValue(HtmlFormGuiConfiguration.FIELD_PASSWORD_CHANGE_PWM);
                        if (StringUtils.isNotBlank((String)pwdChgMgmtUrl)) {
                            ((LinkDescriptor)descriptor).setLink(pwdChgMgmtUrl);
                            continue;
                        }
                        ((LinkDescriptor)descriptor).setLink(HtmlFormGuiConfiguration.CHANGE_PASSWORD_ENDPOINT);
                        continue;
                    }
                    if (HtmlFormGuiConfiguration.FIELD_ACCOUNT_RECOVERY_ENDPOINT.equals(descriptor.getName()) && HtmlFormIdpAuthnAdapter.isResetTypeNone(configuration)) {
                        iterator.remove();
                        continue;
                    }
                    if (!HtmlFormGuiConfiguration.FIELD_USERNAME_RECOVERY_ENDPOINT.equals(descriptor.getName()) || configuration.getBooleanFieldValue(HtmlFormGuiConfiguration.FIELD_ENABLE_USERNAME_RECOVERY)) continue;
                    iterator.remove();
                }
            }
        });
        return guiDescriptor;
    }

    public Set<String> createAttributeContract() {
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(ATTR_NAME_USERID);
        attrNames.add(ATTR_NAME_REQUESTEDACTION);
        return attrNames;
    }

    private static class PcvRowValidator
    implements EnhancedRowValidator,
    Serializable {
        private static final long serialVersionUID = 1L;

        private PcvRowValidator() {
        }

        public void validate(FieldList fieldsInRow) throws ValidationException {
        }

        public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
            ArrayList<String> adapters = new ArrayList<String>();
            for (Row row : configuration.getTable("Credential Validators").getRows()) {
                String pcvName = row.getFieldValue("Password Credential Validator Instance");
                if (adapters.contains(pcvName)) {
                    throw new ValidationException("Password Credential Validator '" + pcvName + "' has already been added");
                }
                adapters.add(pcvName);
            }
        }
    }
}

