/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idp;

import com.pingidentity.access.PasswordCredentialValidatorAccessor;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.idp.HtmlFormLoginContext;
import com.pingidentity.adapters.htmlform.idp.PasswordManagementAuthenticationContext;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.render.ChallengeWithForm;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.common.util.HTMLEncoder;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.password.AttributeRetrievablePasswordCredential;
import com.pingidentity.sdk.password.ChallengeablePasswordCredential;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordChallengeResult;
import com.pingidentity.sdk.password.PasswordCredentialChallengeException;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;

public class AuthenticateFormHandler {
    private final Log log = LogFactory.getLog(AuthenticateFormHandler.class);
    public static final String ACCOUNT_LOCKING_SERVICE_PREFIX = "AccountLockingService";
    public static final String AUDIT_MESSAGE_FORMAT = "[source:%s] %s";
    private final String SESSION_KEY_LOGIN_CONTEXT;
    private final String pwmLocation;
    private final String pwmTemplateName;
    private final List<String> pwdCrdVal;
    private final int maxConsecutiveFailures;
    private final LockingService accountLockingService;
    private final boolean adminAllowsPasswordChanges;
    private final boolean trackAuthenticationTime;
    private final boolean enablePasswordExpiryNotification;
    private final Long expiringPasswordWarningThreshold;
    private final int rememberUsernameCookieLifetime;
    private final String idpAdapterId;
    private final String localIdentityProfileId;
    private final String loginTemplateName;
    private final String passwordExpiryTemplateName;
    private final String loginChallengeTemplateName;
    private final String cookieName;
    private String myDeviceCookieName;
    private final String resetType;
    private final boolean enableRememberMyUsername;
    private boolean showMyDeviceCheckbox;
    private final boolean allowUsernameEdits;
    private final boolean enableUsernameRecovery;
    private final boolean captchaEnabled;
    private final String captchaProviderId;

    public AuthenticateFormHandler(String SESSION_KEY_LOGIN_CONTEXT, List<String> pwdCrdVal, boolean trackAuthenticationTime, int maxConsecutiveFailures, LockingService accountLockingService, boolean adminAllowsPasswordChanges, String pwmLocation, boolean enablePasswordExpiryNotification, String idpAdapterId, String localIdentityProfileId, String loginTemplateName, String passwordExpiryTemplateName, String cookieName, String myDeviceCookieName, boolean enableUsernameRecovery, String resetType, boolean enableRememberMyUsername, boolean showMyDeviceCheckbox, boolean allowUsernameEdits, int rememberUsernameCookieLifetime, Long expiringPasswordWarningThreshold, String loginChallengeTemplateName, String pwmTemplateName, boolean captchaEnabled, String captchaProviderId) {
        this.SESSION_KEY_LOGIN_CONTEXT = SESSION_KEY_LOGIN_CONTEXT;
        this.pwdCrdVal = pwdCrdVal;
        this.trackAuthenticationTime = trackAuthenticationTime;
        this.maxConsecutiveFailures = maxConsecutiveFailures;
        this.accountLockingService = accountLockingService;
        this.adminAllowsPasswordChanges = adminAllowsPasswordChanges;
        this.pwmLocation = pwmLocation;
        this.enablePasswordExpiryNotification = enablePasswordExpiryNotification;
        this.idpAdapterId = idpAdapterId;
        this.localIdentityProfileId = localIdentityProfileId;
        this.loginTemplateName = loginTemplateName;
        this.cookieName = cookieName;
        this.myDeviceCookieName = myDeviceCookieName;
        this.enableUsernameRecovery = enableUsernameRecovery;
        this.enableRememberMyUsername = enableRememberMyUsername;
        this.showMyDeviceCheckbox = showMyDeviceCheckbox;
        this.allowUsernameEdits = allowUsernameEdits;
        this.resetType = resetType;
        this.rememberUsernameCookieLifetime = rememberUsernameCookieLifetime;
        this.passwordExpiryTemplateName = passwordExpiryTemplateName;
        this.expiringPasswordWarningThreshold = expiringPasswordWarningThreshold;
        this.loginChallengeTemplateName = loginChallengeTemplateName;
        this.pwmTemplateName = pwmTemplateName;
        this.captchaEnabled = captchaEnabled;
        this.captchaProviderId = captchaProviderId;
    }

    public AuthenticateFormHandler(String SESSION_KEY_LOGIN_CONTEXT, ChangePasswordConfiguration configuration, LockingService accountLockingService) {
        this.SESSION_KEY_LOGIN_CONTEXT = SESSION_KEY_LOGIN_CONTEXT;
        this.pwdCrdVal = configuration.getPcvIds();
        this.trackAuthenticationTime = configuration.isTrackAuthenticationTime();
        this.maxConsecutiveFailures = configuration.getNumInvalidAttempts();
        this.accountLockingService = accountLockingService;
        this.adminAllowsPasswordChanges = configuration.isAllowsChangePassword();
        this.pwmLocation = configuration.getPwmLocation();
        this.enablePasswordExpiryNotification = configuration.isEnablePasswordExpiryNotification();
        this.idpAdapterId = configuration.getAdapterId();
        this.loginTemplateName = configuration.getLoginTemplateName();
        this.cookieName = configuration.getCookieName();
        this.enableUsernameRecovery = configuration.isEnableUsernameRecovery();
        this.enableRememberMyUsername = configuration.isEnableRememberMyUsername();
        this.allowUsernameEdits = configuration.isAllowUsernameEdits();
        this.resetType = configuration.getResetType();
        this.rememberUsernameCookieLifetime = configuration.getRememberUsernameCookieLifetime();
        this.passwordExpiryTemplateName = configuration.getPasswordExpiryTemplateName();
        this.expiringPasswordWarningThreshold = configuration.getExpiringPasswordWarningThreshold();
        this.captchaEnabled = configuration.isCaptchaEnabledPasswordChange();
        this.captchaProviderId = configuration.getCaptchaProviderId();
        this.localIdentityProfileId = null;
        this.loginChallengeTemplateName = null;
        this.pwmTemplateName = null;
    }

    public HtmlFormLoginContext authenticateForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, AuthnPolicy authnPolicy, String username, String password, String resumeUrl, String pcvId, TransactionalStateSupport transactionalStateSupport, boolean attemptToRecover, Object state, boolean isChainedUsernameAvailable, boolean updateCookieBeforeChallenge, boolean isPasswordChangeRequest, PasswordManagementAuthenticationContext passwordManagementContext) throws IOException {
        HtmlFormLoginContext oldLoginContext = (HtmlFormLoginContext)transactionalStateSupport.removeAttribute(this.SESSION_KEY_LOGIN_CONTEXT, req, resp);
        HtmlFormLoginContext loginContext = new HtmlFormLoginContext();
        if (oldLoginContext != null) {
            loginContext.setUserName(oldLoginContext.getUserName());
        }
        ArrayList<String> pcvList = new ArrayList<String>();
        int errorCount = 0;
        boolean isPasswordExpiryNotifiable = false;
        if (StringUtils.isNotBlank((String)pcvId)) {
            pcvList.add(pcvId);
        } else {
            pcvList.addAll(this.pwdCrdVal);
        }
        for (String pcv : pcvList) {
            boolean isChallengeQuestionPosted = false;
            isPasswordExpiryNotifiable = false;
            AttributeMap authnIds = null;
            try {
                PasswordCredentialValidator credentialValidator = new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(pcv);
                if (credentialValidator instanceof ChangeablePasswordCredential) {
                    ChangeablePasswordCredential changeablePasswordPCV = (ChangeablePasswordCredential)credentialValidator;
                    isPasswordExpiryNotifiable = changeablePasswordPCV.isPendingPasswordExpiryNotifiable();
                }
                boolean radiusChallengeInProgress = false;
                if (credentialValidator instanceof ChallengeablePasswordCredential) {
                    boolean bl = radiusChallengeInProgress = transactionalStateSupport.removeAttribute("radius-challenge-in-progress", req, resp) != null;
                }
                if (radiusChallengeInProgress) {
                    isChallengeQuestionPosted = true;
                    ChallengeablePasswordCredential cpc = (ChallengeablePasswordCredential)credentialValidator;
                    PasswordChallengeResult result = cpc.challenge(username, password, state);
                    authnIds = new AttributeMap();
                    authnIds.put("username", new AttributeValue(username));
                    if (credentialValidator.getPluginDescriptor().isSupportsExtendedContract()) {
                        for (Map.Entry attribute : result.getAttributes().entrySet()) {
                            authnIds.put(String.valueOf(attribute.getKey()), new AttributeValue((Collection)attribute.getValue()));
                        }
                    }
                } else {
                    authnIds = passwordManagementContext != null && credentialValidator instanceof AttributeRetrievablePasswordCredential && passwordManagementContext.isSuccess() && pcv.equals(passwordManagementContext.getPcvId()) ? ((AttributeRetrievablePasswordCredential)credentialValidator).getUserAttributes(username) : credentialValidator.processPasswordCredential(username, password);
                }
                if (Util.isEmpty((Map)authnIds)) {
                    if (loginContext.getPcvId() != null) continue;
                    loginContext.setPcvId(pcv);
                    loginContext.setAuthnIds((Map)authnIds);
                    loginContext.addException(AuthenticationResultEnum.INVALID_CREDENTIALS.newException());
                    if (loginContext.isRecoverable()) continue;
                    ++errorCount;
                    continue;
                }
                loginContext.setPcvId(pcv);
                AuditLogger.setPcvId((String)pcv);
                if (this.trackAuthenticationTime || this.showMyDeviceCheckbox) {
                    HashMap<String, Object> attributes = new HashMap<String, Object>((Map<String, Object>)authnIds);
                    if (this.trackAuthenticationTime) {
                        attributes.put("org.sourceid.saml20.adapter.idp.authn.authnInst", System.currentTimeMillis());
                    }
                    if (this.showMyDeviceCheckbox) {
                        DeviceSharingType deviceSharingType = HtmlFormIdpAuthnAdapterUtils.isMyDeviceSelected(req, this.myDeviceCookieName) ? DeviceSharingType.PRIVATE : DeviceSharingType.SHARED;
                        attributes.put("org.sourceid.saml20.adapter.idp.authn.deviceSharingType", deviceSharingType.name());
                    }
                    loginContext.setAuthnIds(attributes);
                } else {
                    loginContext.setAuthnIds((Map)authnIds);
                }
                loginContext.removeAllExceptions();
                errorCount = 0;
                break;
            }
            catch (PasswordCredentialChallengeException e) {
                if (HtmlFormIdpAuthnAdapterUtils.supportsChallengeResponse(pcv)) {
                    errorCount = 0;
                    loginContext.addException((PasswordCredentialValidatorAuthnException)((Object)e));
                    loginContext.setPcvId(pcv);
                    String userKey = AccountLockingService.getUserKey((String)req.getRemoteAddr(), (String)username);
                    String passwordKey = AccountLockingService.buildPasswordLockingKey((String)password);
                    if (isChallengeQuestionPosted && authnIds == null) {
                        boolean locked;
                        this.accountLockingService.logFailedLogin(userKey);
                        this.accountLockingService.logFailedPassword(passwordKey);
                        boolean bl = locked = this.accountLockingService.isLocked(userKey, this.maxConsecutiveFailures, AccountLockingService.getLockoutPeriod()) || this.accountLockingService.isLocked(passwordKey, AccountLockingService.getMaxPasswordAttempts(), AccountLockingService.getPasswordLockoutPeriod());
                        if (loginContext.isError() && loginContext.isRecoverable() && !locked) {
                            this.handlePasswordCredentialChallengeException(req, resp, inParameters, username, resumeUrl, transactionalStateSupport, e);
                            break;
                        }
                        ++errorCount;
                        break;
                    }
                    this.accountLockingService.clearFailedLogins(userKey);
                    if (updateCookieBeforeChallenge) {
                        HtmlFormIdpAuthnAdapter.updateUserNameCookie(req, resp, username, isChainedUsernameAvailable, this.allowUsernameEdits, this.rememberUsernameCookieLifetime, this.cookieName);
                    }
                    this.handlePasswordCredentialChallengeException(req, resp, inParameters, username, resumeUrl, transactionalStateSupport, e);
                    break;
                }
                loginContext.setPcvId(pcv);
                loginContext.setAuthnIds(null);
                loginContext.addException((PasswordCredentialValidatorAuthnException)((Object)e));
            }
            catch (PasswordCredentialValidatorAuthnException e) {
                if (loginContext.getPcvId() == null || !AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey().equals(e.getMessageKey())) {
                    loginContext.setPcvId(pcv);
                    loginContext.addException(e);
                    if (loginContext.isRecoverable()) {
                        errorCount = 0;
                        if (!attemptToRecover) break;
                        if (this.adminAllowsPasswordChanges) {
                            if (HtmlFormIdpAuthnAdapterUtils.supportsPasswordChange(loginContext.getPcvId(), this.pwmLocation)) {
                                this.saveLoginState(req, resp, username, transactionalStateSupport, loginContext);
                                HtmlFormIdpAuthnAdapter.promptForPasswordChange(req, resp, inParameters, authnPolicy, this.idpAdapterId, resumeUrl, loginContext.getMessageKey(), isChainedUsernameAvailable, username, this.pwmLocation, this.pwmTemplateName, this.adminAllowsPasswordChanges, this.SESSION_KEY_LOGIN_CONTEXT);
                                break;
                            }
                            ChallengeWithForm form = new ChallengeWithForm.Builder().authnPolicy(authnPolicy).url(resumeUrl).name(username).loginFailed(true).errorMessageKey(null).authnMessageKey(loginContext.getMessageKey()).serverError(null).isChainedUsernameAvailable(isChainedUsernameAvailable).pwdCrdVal(this.pwdCrdVal).pwmLocation(this.pwmLocation).allowsChangePassword(this.adminAllowsPasswordChanges).loginTemplateName(this.loginTemplateName).localIdentityProfileId(this.localIdentityProfileId).cookieName(this.cookieName).resetType(this.resetType).enableRememberMyUsername(this.enableRememberMyUsername).showMyDeviceCheckbox(this.showMyDeviceCheckbox).myDeviceChecked(HtmlFormIdpAuthnAdapterUtils.isMyDeviceSelected(req, this.myDeviceCookieName)).allowUsernameEdits(this.allowUsernameEdits).enableUsernameRecovery(this.enableUsernameRecovery).resetType(this.resetType).captchaEnabled(this.captchaEnabled).captchaProviderId(this.captchaProviderId).build();
                            form.render(req, resp, inParameters);
                            loginContext.setAuthnIds(null);
                            this.log.debug((Object)("Password Credential Validator " + loginContext.getPcvId() + " doesn't support password changes."));
                            break;
                        }
                        ChallengeWithForm form = new ChallengeWithForm.Builder().authnPolicy(authnPolicy).url(resumeUrl).name(username).loginFailed(true).errorMessageKey(null).authnMessageKey(loginContext.getMessageKey()).serverError(null).isChainedUsernameAvailable(isChainedUsernameAvailable).pwdCrdVal(this.pwdCrdVal).pwmLocation(this.pwmLocation).allowsChangePassword(this.adminAllowsPasswordChanges).loginTemplateName(this.loginTemplateName).localIdentityProfileId(this.localIdentityProfileId).cookieName(this.cookieName).resetType(this.resetType).enableRememberMyUsername(this.enableRememberMyUsername).showMyDeviceCheckbox(this.showMyDeviceCheckbox).myDeviceChecked(HtmlFormIdpAuthnAdapterUtils.isMyDeviceSelected(req, this.myDeviceCookieName)).allowUsernameEdits(this.allowUsernameEdits).enableUsernameRecovery(this.enableUsernameRecovery).resetType(this.resetType).captchaEnabled(this.captchaEnabled).captchaProviderId(this.captchaProviderId).build();
                        form.render(req, resp, inParameters);
                        break;
                    }
                    if (AuthenticationResultEnum.USER_NOT_FOUND.getMessageKey().equals(e.getMessageKey())) continue;
                    ++errorCount;
                    continue;
                }
                this.log.debug((Object)("'User Not Found' error in Password Credential Validator '" + loginContext.getPcvId() + "' ignored because an authentication error has occurred in another PCV."));
            }
            catch (Exception e) {
                loginContext.setPcvId(pcv);
                loginContext.addException(AuthenticationResultEnum.getDefaultValue().newException());
                this.log.error((Object)e.getMessage(), (Throwable)e);
                if (loginContext.isRecoverable()) continue;
                ++errorCount;
            }
        }
        if (errorCount > 1) {
            loginContext.setPcvId(null);
            loginContext.setAuthnIds(null);
            loginContext.setUserName(username);
            List<PasswordCredentialValidatorAuthnException> exceptionList = loginContext.getExceptionList();
            if (exceptionList.isEmpty()) {
                loginContext.setException(AuthenticationResultEnum.getDefaultValue().newException());
                this.log.debug((Object)"Multiple non-recoverable errors in Password Credential Validators.  A general authentication error will be returned.");
            } else {
                loginContext.setException(exceptionList.get(0));
            }
        } else if (this.enablePasswordExpiryNotification) {
            if (this.adminAllowsPasswordChanges && isPasswordExpiryNotifiable && !isPasswordChangeRequest) {
                try {
                    this.handleExpiringPasswordWarning(req, resp, resumeUrl, loginContext, username, inParameters);
                }
                catch (TemplateRendererUtilException e) {
                    this.log.error((Object)e.toString(), (Throwable)e);
                }
            }
        } else {
            HtmlFormIdpAuthnAdapterUtils.addCookie("pf-hfa-exp-pwd", "", 0, resp);
        }
        return loginContext;
    }

    private void handleExpiringPasswordWarning(HttpServletRequest req, HttpServletResponse resp, String resumeUrl, HtmlFormLoginContext loginContext, String username, Map<String, Object> inParameters) throws IOException {
        if (loginContext != null && loginContext.getAuthnIds() != null) {
            String pendingPwdCookieValue = HtmlFormIdpAuthnAdapter.getPendingPwdCookieValue(loginContext.getPcvId(), username);
            String cookieValue = CookieMonster.getCookieValue((String)"pf-hfa-exp-pwd", (HttpServletRequest)req);
            boolean isSnoozed = false;
            if (StringUtils.isNotBlank((String)cookieValue) && cookieValue.equals(pendingPwdCookieValue)) {
                isSnoozed = true;
            } else {
                HtmlFormIdpAuthnAdapterUtils.addCookie("pf-hfa-exp-pwd", "", 0, resp);
            }
            Long expiryDurationMillis = null;
            if (loginContext.getAuthnIds().containsKey("passwordExpiryTime")) {
                String passwordExpiryTime = loginContext.getAuthnIds().get("passwordExpiryTime").toString();
                expiryDurationMillis = Long.parseLong(passwordExpiryTime) - new Date().getTime();
            } else if (loginContext.getAuthnIds().containsKey("seconds-until-password-expiration")) {
                String secondsUntilPasswordExpiration = loginContext.getAuthnIds().get("seconds-until-password-expiration").toString();
                expiryDurationMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(secondsUntilPasswordExpiration));
            }
            if (!isSnoozed && expiryDurationMillis != null && expiryDurationMillis > 0L && expiryDurationMillis <= this.expiringPasswordWarningThreshold) {
                loginContext.setPasswordExpiring(true);
                TransactionalStateSupport transactionalStateSupport = new TransactionalStateSupport(resumeUrl);
                this.saveLoginState(req, resp, username, transactionalStateSupport, loginContext);
                long timeToExpire = TimeUnit.MILLISECONDS.toDays(expiryDurationMillis);
                String daysToExpire = String.valueOf((int)timeToExpire);
                String pcvId = loginContext.getPcvId();
                Map userAttributes = new HashMap();
                PasswordCredentialValidator pcv = new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(pcvId);
                if (pcv instanceof ResettablePasswordCredential) {
                    userAttributes = TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)((ResettablePasswordCredential)pcv).findUser(username));
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(TemplateKey.NAME.getKey(), "pf.username");
                params.put(TemplateKey.USERNAME.getKey(), HTMLEncoder.encode((String)username) == null ? "" : HTMLEncoder.encode((String)username));
                params.put(TemplateKey.PASS.getKey(), "pf.pass");
                params.put(TemplateKey.OK.getKey(), "pf.ok");
                params.put(TemplateKey.CANCEL.getKey(), "pf.notificationCancel");
                params.put(TemplateKey.CHANGE_PASSWORD.getKey(), "ChangePassword");
                params.put(TemplateKey.URL.getKey(), resumeUrl);
                params.put(TemplateKey.PASSWORD_EXPIRING.getKey(), "pf.passwordExpiring");
                params.put(TemplateKey.PCV_ID.getKey(), pcvId);
                params.put(TemplateKey.PCV_ID_FIELD.getKey(), "pf.pcvId");
                params.put(TemplateKey.DAYS_TO_EXPIRE.getKey(), daysToExpire);
                params.put(TemplateKey.USER_ATTRIBUTES.getKey(), userAttributes);
                if (AuthnApiSupport.getDefault().isApiRequest(req)) {
                    PasswordChangeHandler.saveExpiringUsernamePCVPair(req, username, pcvId);
                }
                ResponseHandler.renderPasswordExpiringWarningResponse(req, resp, this.passwordExpiryTemplateName, params);
            }
        }
    }

    public void saveLoginState(HttpServletRequest req, HttpServletResponse resp, String username, TransactionalStateSupport transactionalStateSupport, HtmlFormLoginContext loginContext) {
        loginContext.setUserName(username);
        transactionalStateSupport.setAttribute(this.SESSION_KEY_LOGIN_CONTEXT, (Object)loginContext, req, resp);
    }

    private void handlePasswordCredentialChallengeException(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String username, String resumeUrl, TransactionalStateSupport transactionalStateSupport, PasswordCredentialChallengeException exception) throws IOException {
        String replyMessage;
        Object state;
        boolean isRadiusException;
        String errorMessageKey = null;
        boolean bl = isRadiusException = exception.getCause() != null && exception.getCause() instanceof RadiusAdminUserException;
        if (isRadiusException) {
            RadiusAdminUserException re = (RadiusAdminUserException)exception.getCause();
            state = re.getState();
            replyMessage = re.getReplyMessage();
        } else {
            state = exception.getState();
            replyMessage = exception.getMessageKey();
        }
        if (replyMessage == null) {
            errorMessageKey = "challengeResponseBlankError";
        }
        if (state != null) {
            transactionalStateSupport.setAttribute("radius-state", state, req, resp);
        }
        transactionalStateSupport.setAttribute("radius-challenge-in-progress", (Object)true, req, resp);
        transactionalStateSupport.setAttribute("radius-username", (Object)username, req, resp);
        transactionalStateSupport.setAttribute("radius-reply-message", (Object)replyMessage, req, resp);
        this.loginChallengeWithForm(req, resp, inParameters, resumeUrl, replyMessage, errorMessageKey);
    }

    private void loginChallengeWithForm(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String url, String challengeQuestion, String errorMessageKey) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(TemplateKey.URL.getKey(), url);
        params.put(TemplateKey.OK.getKey(), "pf.ok");
        params.put(TemplateKey.CANCEL.getKey(), "pf.cancel");
        params.put(TemplateKey.CHALLENGE_RESPONSE.getKey(), "pf.challengeResponse");
        params.put(TemplateKey.CHALLENGE_QUESTION.getKey(), challengeQuestion);
        params.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), errorMessageKey);
        ResponseHandler.renderLoginChallengeResponse(req, resp, this.loginChallengeTemplateName, params);
    }

    public static String getPasswordCredentialValidatorErrorMessage(Exception exception) {
        String errorMessage = null;
        if (exception instanceof PasswordCredentialValidatorAuthnException) {
            PasswordCredentialValidatorAuthnException pcvException = (PasswordCredentialValidatorAuthnException)((Object)exception);
            String auditErrorMessage = pcvException.getAuditErrorMessage();
            String errorSource = pcvException.getErrorSource();
            if (StringUtils.isNotBlank((String)auditErrorMessage)) {
                errorMessage = String.format(AUDIT_MESSAGE_FORMAT, errorSource, auditErrorMessage);
            }
        }
        return errorMessage;
    }
}

