/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idp;

import com.pingidentity.access.PasswordCredentialValidatorAccessor;
import com.pingidentity.common.util.CookieMonster;
import com.pingidentity.sdk.DeviceSharingType;
import com.pingidentity.sdk.password.ChallengeablePasswordCredential;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class HtmlFormIdpAuthnAdapterUtils {
    private HtmlFormIdpAuthnAdapterUtils() {
    }

    public static void addCookie(String name, String value, int maxAge, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        response.addCookie(cookie);
    }

    public static boolean supportsChallengeResponse(String pcvId) {
        PasswordCredentialValidator pcv = HtmlFormIdpAuthnAdapterUtils.getPcv(pcvId);
        return pcv instanceof ChallengeablePasswordCredential;
    }

    public static boolean supportsPasswordChange(String pcvId, String pwmLocation) {
        boolean pwdExists;
        boolean bl = pwdExists = !StringUtils.isBlank((String)pwmLocation);
        if (pwdExists) {
            return true;
        }
        PasswordCredentialValidator pcv = HtmlFormIdpAuthnAdapterUtils.getPcv(pcvId);
        boolean pcvAllowsPasswordChange = pcv instanceof ChangeablePasswordCredential;
        boolean ldapsEnabled = false;
        if (pcvAllowsPasswordChange) {
            ldapsEnabled = ((ChangeablePasswordCredential)pcv).isPasswordChangeable();
        }
        return pcvAllowsPasswordChange && ldapsEnabled;
    }

    public static boolean supportsPasswordReset(String pcvId) {
        boolean ldapsEnabled = false;
        PasswordCredentialValidator pcv = HtmlFormIdpAuthnAdapterUtils.getPcv(pcvId);
        boolean pcvAllowsPasswordReset = pcv instanceof ResettablePasswordCredential;
        if (pcvAllowsPasswordReset) {
            ldapsEnabled = ((ResettablePasswordCredential)pcv).isPasswordResettable();
        }
        return pcvAllowsPasswordReset && ldapsEnabled;
    }

    public static String getRememberUsernameCookieName(String adapterId) {
        return "pf-hfa-" + adapterId + "-rmu";
    }

    public static String getMyDeviceCookieName(String adapterId) {
        return "pf-hfa-" + adapterId + "-mcpt";
    }

    public static boolean showMyDeviceCheckbox(boolean enableMyDevice, Map<String, Object> inParameters) {
        if (!enableMyDevice) {
            return false;
        }
        String deviceSharingType = HtmlFormIdpAuthnAdapterUtils.getDeviceSharingType(inParameters);
        if (deviceSharingType == null) {
            return true;
        }
        return deviceSharingType.equals(DeviceSharingType.UNSPECIFIED.name());
    }

    private static String getDeviceSharingType(Map<String, Object> inParameters) {
        String deviceSharingType = (String)inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type");
        return deviceSharingType;
    }

    public static void updateMyDeviceCookieValue(HttpServletRequest req, HttpServletResponse resp, boolean enableMyDevice, boolean checkboxShown, boolean isMyDevice, String cookieName, int lifetimeDays) {
        if (checkboxShown || HtmlFormIdpAuthnAdapterUtils.isMyDeviceSelected(req, cookieName) && !enableMyDevice) {
            boolean myDevice = enableMyDevice && isMyDevice;
            int age = myDevice ? 86400 * lifetimeDays : 0;
            String cookieValue = myDevice ? "true" : "";
            HtmlFormIdpAuthnAdapterUtils.addCookie(cookieName, cookieValue, age, resp);
            req.setAttribute(cookieName, (Object)cookieValue);
        }
    }

    public static String getMyDeviceCookieValue(HttpServletRequest req, String cookieName) {
        String value = (String)req.getAttribute(cookieName);
        if (value != null) {
            return value;
        }
        return CookieMonster.getCookieValue((String)cookieName, (HttpServletRequest)req);
    }

    public static boolean isMyDeviceSelected(HttpServletRequest req, String cookieName) {
        if (cookieName == null) {
            return false;
        }
        String cookieValue = HtmlFormIdpAuthnAdapterUtils.getMyDeviceCookieValue(req, cookieName);
        return StringUtils.isNotBlank((String)cookieValue);
    }

    static PasswordCredentialValidator getPcv(String pcvId) {
        return new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(pcvId);
    }

    public static boolean isRevokeSessionAfterPasswordChangeOrReset(String idpAdapterId) {
        Configuration configuration;
        IdpAuthnAdapterInstance idpAuthnAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(idpAdapterId);
        if (idpAuthnAdapter != null && (configuration = idpAuthnAdapter.getRuntimeCompositeConfiguration()) != null) {
            return configuration.getBooleanFieldValue("Revoke Sessions After Password Change Or Reset", false);
        }
        return false;
    }
}

