/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idp;

import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.mgmt.impl.RadiusAdminUserException;

public class HtmlFormLoginContext
implements Serializable {
    private static final long serialVersionUID = 20121107L;
    private String pcvId = null;
    private PasswordCredentialValidatorAuthnException curException = null;
    private List<PasswordCredentialValidatorAuthnException> exceptionList = new ArrayList<PasswordCredentialValidatorAuthnException>();
    private String messageKey = null;
    private boolean inProgress = false;
    private boolean isAlternateAuthnSystem = false;
    private final Boolean isRecoverable = null;
    private Map authnIds = null;
    private String userName = null;
    private boolean passwordExpiring = false;

    public String getPcvId() {
        return this.pcvId;
    }

    public void setPcvId(String pcvId) {
        this.pcvId = pcvId;
    }

    public PasswordCredentialValidatorAuthnException getException() {
        return this.curException;
    }

    public void setException(PasswordCredentialValidatorAuthnException ex) {
        this.curException = ex;
    }

    public String getMessageKey() {
        if (this.messageKey == null) {
            return this.curException.getMessageKey();
        }
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public String getRadiusServerError() {
        String serverError = null;
        if (this.isError() && this.curException.getCause() instanceof RadiusAdminUserException) {
            RadiusAdminUserException re = (RadiusAdminUserException)this.curException.getCause();
            serverError = re.getReplyMessage();
        }
        return serverError;
    }

    public Map getAuthnIds() {
        return this.authnIds;
    }

    public void setAuthnIds(Map authnIds) {
        this.authnIds = authnIds;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isRecoverable() {
        if (this.isRecoverable == null) {
            return this.curException.isRecoverable();
        }
        return this.isRecoverable;
    }

    public boolean isError() {
        return this.curException != null;
    }

    public boolean isSuccess() {
        return this.curException == null && !this.isInProgress();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean isAlternateAuthnSystem() {
        return this.isAlternateAuthnSystem;
    }

    public void setAlternateAuthnSystem(boolean alternateAuthnSystem) {
        this.isAlternateAuthnSystem = alternateAuthnSystem;
    }

    public boolean isPasswordExpiring() {
        return this.passwordExpiring;
    }

    public void setPasswordExpiring(boolean passwordExpiring) {
        this.passwordExpiring = passwordExpiring;
    }

    public List<PasswordCredentialValidatorAuthnException> getExceptionList() {
        return this.exceptionList;
    }

    public void addException(PasswordCredentialValidatorAuthnException exception) {
        this.curException = exception;
        this.exceptionList.add(exception);
    }

    public void removeAllExceptions() {
        this.curException = null;
        this.exceptionList.clear();
    }
}

