/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idrecovery.handler;

import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameConfiguration;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameSessionState;
import com.pingidentity.adapters.htmlform.idrecovery.model.RecoverUsernameForm;
import com.pingidentity.adapters.htmlform.idrecovery.type.RecoverUsernameResult;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.password.RecoverableUsername;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class RecoverUsernameHandler {
    private static final Logger logger = LogManager.getLogger(RecoverUsernameHandler.class);
    private RecoverUsernameConfiguration recoveryConfiguration;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;

    public RecoverUsernameHandler(RecoverUsernameConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        this.recoveryConfiguration = configuration;
        this.servletRequest = request;
        this.servletResponse = response;
    }

    public RecoverUsernameResult validateEmailAddress(RecoverUsernameForm recoverUsernameForm, HttpServletRequest request) {
        RecoverableUsername pcv;
        if (recoverUsernameForm.isPasswordResetRequested()) {
            return RecoverUsernameResult.PasswordReset;
        }
        if (!recoverUsernameForm.isEmailSubmitted()) {
            if (AbstractPasswordManagementServlet.Stage.COMPLETED.equals((Object)this.getSessionState().getStage())) {
                return RecoverUsernameResult.Continue;
            }
            return RecoverUsernameResult.Cancel;
        }
        if (recoverUsernameForm.getEmail() == null || recoverUsernameForm.getEmail().isEmpty()) {
            logger.debug("No email address found in the form data");
            return RecoverUsernameResult.NoEmailAddress;
        }
        List<AttributeMap> userAttributes = null;
        String selectedPcvId = null;
        for (String pcvId : this.recoveryConfiguration.getPcvIds()) {
            try {
                userAttributes = this.getAttributes(recoverUsernameForm.getEmail(), pcvId);
                if (userAttributes == null) continue;
                selectedPcvId = pcvId;
                break;
            }
            catch (Exception e) {
                logger.error("Error retrieving user attributes. " + e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug("Error retrieving user attributes. " + e.getMessage(), (Throwable)e);
                }
                return null;
            }
        }
        this.getSessionState().setPcvId(selectedPcvId);
        if (userAttributes == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Attributes not found for user: " + recoverUsernameForm.getEmail());
            }
            return RecoverUsernameResult.UserNotFound;
        }
        if (this.recoveryConfiguration.isRequireVerifiedEmail() && ((userAttributes = this.buildVerifiedUserAttributesList(pcv = (RecoverableUsername)MgmtFactory.getCredentialValidatorManager().getValidator(selectedPcvId), userAttributes)) == null || userAttributes.isEmpty())) {
            logger.error("User found but email address not verified.");
            return RecoverUsernameResult.MailNotVerified;
        }
        Locale locale = LocaleUtil.getUserLocale((HttpServletRequest)request);
        return this.sendUsernames(recoverUsernameForm, userAttributes, selectedPcvId, locale);
    }

    private RecoverUsernameSessionState getSessionState() {
        return RecoverUsernameSessionState.get(this.servletRequest, this.servletResponse);
    }

    private RecoverUsernameResult sendUsernames(RecoverUsernameForm recoverUsernameForm, List<AttributeMap> userAttributes, String pcvId, Locale locale) {
        logger.debug("Sending username recovery email.");
        RecoverableUsername pcv = this.getPcv(pcvId);
        Map<String, Object> defaultTemplateParams = this.getSessionState().getDefaultTemplateParams();
        try {
            List<String> usernames = this.buildUsernameList(pcv, userAttributes);
            if (usernames != null && !usernames.isEmpty()) {
                NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                notificationSupportHelper.sendUsernameRecoveryEmail(recoverUsernameForm.getEmail(), this.buildDisplayName(pcv, userAttributes), usernames, this.recoveryConfiguration.getAdapterId(), pcvId, locale, this.recoveryConfiguration.getUsernameRecoveryEmailTemplate(), this.recoveryConfiguration.getNotificationPublisher(), defaultTemplateParams);
                if (logger.isDebugEnabled()) {
                    logger.debug("Username recovery email queued to be sent to " + usernames + " at " + recoverUsernameForm.getEmail());
                }
                return RecoverUsernameResult.EmailSent;
            }
            logger.error("No username(s) found in directory for email address: " + recoverUsernameForm.getEmail());
            return RecoverUsernameResult.UserNotFound;
        }
        catch (Exception e) {
            logger.error("Error occurred while sending username recovery email", (Throwable)e);
            return RecoverUsernameResult.Error;
        }
    }

    private List<AttributeMap> buildVerifiedUserAttributesList(RecoverableUsername pcv, List<AttributeMap> userAttributes) {
        if (pcv == null || userAttributes == null) {
            throw new IllegalArgumentException("pcv and userAttributes cannot be null");
        }
        return userAttributes.stream().filter(m -> m.containsKey((Object)pcv.getMailVerifiedAttribute()) ? Boolean.valueOf(m.getSingleValue(pcv.getMailVerifiedAttribute())) : false).collect(Collectors.toList());
    }

    private List<String> buildUsernameList(RecoverableUsername pcv, List<AttributeMap> userAttributes) throws IllegalArgumentException {
        if (pcv == null || userAttributes == null) {
            throw new IllegalArgumentException("pcv and userAttributes cannot be null");
        }
        return userAttributes.stream().map(m -> m.getSingleValue(pcv.getUsernameAttribute())).collect(Collectors.toList());
    }

    private String buildDisplayName(RecoverableUsername pcv, List<AttributeMap> userAttributes) throws IllegalArgumentException {
        if (pcv == null || userAttributes == null) {
            throw new IllegalArgumentException("pcv and userAttributes cannot be null");
        }
        return userAttributes.stream().filter(m -> m.containsKey((Object)pcv.getNameAttribute())).map(m -> m.getSingleValue(pcv.getNameAttribute())).findFirst().orElse("");
    }

    private List<AttributeMap> getAttributes(String email, String pcvId) {
        try {
            RecoverableUsername pcv = (RecoverableUsername)MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            return pcv.findUsersByMail(email);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("User not found")) {
                logger.error("Error retrieving user attributes. " + e.getMessage());
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            } else {
                logger.error("Error retrieving user attributes. " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private RecoverableUsername getPcv(String pcvId) {
        return (RecoverableUsername)MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
    }
}

