/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.idrecovery.servlet;

import com.pingidentity.access.CaptchaProviderAccessor;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameConfiguration;
import com.pingidentity.adapters.htmlform.idrecovery.common.RecoverUsernameSessionState;
import com.pingidentity.adapters.htmlform.idrecovery.handler.RecoverUsernameHandler;
import com.pingidentity.adapters.htmlform.idrecovery.model.RecoverUsernameForm;
import com.pingidentity.adapters.htmlform.idrecovery.servlet.AbstractRecoverUsernameServlet;
import com.pingidentity.adapters.htmlform.idrecovery.type.RecoverUsernameResult;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.idrecovery.ApiUsernameRecoveryEmailRequiredHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.idrecovery.ApiUsernameRecoveryEmailSentHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.idrecovery.ApiUsernameRecoveryHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.common.util.CrossSiteRequestForgeryHelper;
import com.pingidentity.common.util.TrackedParamsUtil;
import com.pingidentity.sdk.api.authn.common.CommonActionSpec;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.model.action.CheckUsernameRecoveryEmail;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.reqparam.InvalidRequestParameterException;

public class RecoverUsernameServlet
extends AbstractRecoverUsernameServlet {
    private static Log logger = LogFactory.getLog(RecoverUsernameServlet.class);
    private static final String RECOVER_USERNAME_REQUEST = "USERNAME_RECOVER";
    private static final String USERNAME_RECOVERY_SERVLET = "/idrecovery/Recover";
    private static final ParamMapping<CheckUsernameRecoveryEmail, String> EMAIL_MAPPING = new ParamMapping("email", CheckUsernameRecoveryEmail.class, CheckUsernameRecoveryEmail::getEmail, Function.identity());
    private final AbstractPasswordManagementServlet.Stage servletStage;

    public RecoverUsernameServlet(AbstractPasswordManagementServlet.Stage servletStage) {
        this.servletStage = servletStage;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)("GET Request to " + request.getRequestURI()));
        if (AbstractPasswordManagementServlet.Stage.IDENTIFYING.equals((Object)this.servletStage) && !AuthnApiSupport.getDefault().isApiRequest(request)) {
            this.initializeSessionState(request, response);
        }
        if (!this.validStage(this.servletStage, request, response)) {
            this.handleError(request, response, "username.recovery.template.invalidState");
            return;
        }
        RecoverUsernameConfiguration configuration = this.getConfiguration(request, response);
        if (!configuration.isEnableUsernameRecovery()) {
            ResponseHandler.sendResourceNotFoundResponse(request, response);
            return;
        }
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        String cSRFToken = CrossSiteRequestForgeryHelper.generateAndStoreCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        defaultParams.put("cSRFToken", cSRFToken);
        if (AbstractPasswordManagementServlet.Stage.COMPLETED.equals((Object)this.servletStage)) {
            this.renderEmailSent(request, response, defaultParams);
            return;
        }
        this.render(request, response, defaultParams);
    }

    private Map<String, Class<?>> getActionIdToModelMapping(HttpServletRequest request, HttpServletResponse response) {
        String targetResource = this.getSessionState(request, response).getTargetResource();
        return AbstractPasswordManagementServlet.Stage.COMPLETED.equals((Object)this.servletStage) ? new ApiUsernameRecoveryEmailSentHandler(targetResource != null).getActionIdToModelMapping(request, response) : new ApiUsernameRecoveryEmailRequiredHandler().getActionIdToModelMapping(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)("POST Request to " + request.getRequestURI()));
        if (!this.validStage(this.servletStage, request, response)) {
            this.handleError(request, response, "username.recovery.template.invalidState");
            return;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(request) && !AuthnApiSupport.getDefault().isValidAuthnApiPostRequest(request, response, this.getActionIdToModelMapping(request, response))) {
            return;
        }
        PwdResetAuditLogger.init(RECOVER_USERNAME_REQUEST, request, response);
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(request, response);
        RecoverUsernameSessionState sessionState = this.getSessionState(request, response);
        String cSRFToken = CrossSiteRequestForgeryHelper.validateCSRFToken((HttpServletRequest)request, (HttpServletResponse)response);
        if (!AuthnApiSupport.getDefault().isApiRequest(request) && !AbstractPasswordManagementServlet.Stage.COMPLETED.equals((Object)sessionState.getStage()) && cSRFToken == null) {
            PwdResetAuditLogger.logFailure("Invalid state (unauthorized method)");
            this.handleError(request, response, "username.recovery.template.invalidState");
            return;
        }
        defaultParams.put("cSRFToken", cSRFToken);
        RecoverUsernameResult validationResult = null;
        RecoverUsernameConfiguration configuration = this.getConfiguration(request, response);
        try {
            RecoverUsernameForm form = this.parseRequest(request);
            if (form.isEmailSubmitted() && configuration.isEnableCaptcha()) {
                if (AuthnApiSupport.getDefault().isApiRequest(request) && HtmlFormAuthnApiHandler.isMissingAuthnApiCaptchaResponse(request)) {
                    HtmlFormAuthnApiHandler.sendCaptchaResponseMissingResponse(request, response);
                    return;
                }
                CaptchaProvider captchaProvider = CaptchaProviderAccessor.getCaptchaProvider((String)configuration.getCaptchaProviderId());
                Map<String, Object> parameters = this.getCaptchaProviderInParams(request, response, sessionState);
                parameters.put("com.pingidentity.adapter.input.parameter.userid", form.getEmail());
                parameters.put("com.pingidentity.adapter.input.parameter.userid.authenticated", false);
                CaptchaContext context = new CaptchaContext.Builder().setRequest(request).setResponse(response).setAction("usernameRecovery").setInParameters(parameters).build();
                CaptchaResult captchaResult = captchaProvider.validateCaptcha(context);
                boolean isValid = captchaResult.isValid();
                if (!isValid) {
                    logger.debug((Object)"Login failed: reCAPTCHA validation failure.");
                    validationResult = RecoverUsernameResult.CaptchaFailure;
                }
            }
            if (validationResult == null) {
                PwdResetAuditLogger.setUserName((String)form.getEmail());
                RecoverUsernameHandler handler = new RecoverUsernameHandler(configuration, request, response);
                validationResult = handler.validateEmailAddress(form, request);
            }
        }
        catch (IOException | InvalidRequestParameterException e) {
            logger.error((Object)e.getMessage());
            validationResult = RecoverUsernameResult.Error;
        }
        RecoverUsernameServlet.auditRequestResult(validationResult);
        switch (validationResult) {
            case UserNotFound: 
            case MailNotVerified: 
            case Error: 
            case EmailSent: {
                sessionState.setStage(AbstractPasswordManagementServlet.Stage.COMPLETED);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    ApiUsernameRecoveryHandler.reissueRequestToRecoveryEmailSentServlet(request, response);
                    break;
                }
                this.redirect(response, this.buildRecoveryEmailSentUrl(request));
                break;
            }
            case Cancel: {
                this.doCancel(request, response);
                break;
            }
            case Continue: {
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    if (!this.getSessionState(request, response).isFromHtmlFormAdapter()) {
                        String targetResource = this.getSessionState(request, response).getTargetResource();
                        ApiUsernameRecoveryHandler.writeResumeAtTargeResourceResponse(request, response, targetResource);
                        break;
                    }
                    ApiUsernameRecoveryHandler.reissueRequestToHtmlFormAdapter(request, response);
                    break;
                }
                this.redirect(response, this.getSessionState(request, response).getTargetResource());
                break;
            }
            case PasswordReset: {
                sessionState = this.getSessionState(request, response);
                PasswordResetSessionState newSessionState = PasswordResetSessionState.create(request, response);
                newSessionState.setAdapterId(sessionState.getAdapterId());
                newSessionState.setResumeUrl(sessionState.getResumeUrl());
                newSessionState.setTargetResource(sessionState.getTargetResource());
                newSessionState.setTrackedHttpParams(sessionState.getTrackedHttpParams());
                newSessionState.setFromHtmlFormAdapter(sessionState.isFromHtmlFormAdapter());
                newSessionState.setDefaultTemplateParams(sessionState.getDefaultTemplateParams());
                newSessionState.setPartnerId(sessionState.getPartnerId());
                this.redirect(response, HtmlFormIdpAuthnAdapter.getForgetPasswordUrl(request, response));
                break;
            }
            case CaptchaFailure: {
                this.handleError(request, response, "username.recovery.template.captchaFailure");
                break;
            }
            case NoEmailAddress: {
                defaultParams.put(TemplateKey.ERROR_MESSAGE_KEY.getKey(), "noEmail");
                this.render(request, response, defaultParams);
            }
        }
    }

    private RecoverUsernameForm parseRequest(HttpServletRequest request) throws InvalidRequestParameterException, IOException {
        RecoverUsernameForm recoverUsernameForm = new RecoverUsernameForm(request);
        String email = (String)EMAIL_MAPPING.getValue(request);
        if (StringUtils.isNotEmpty((String)email)) {
            recoverUsernameForm.setEmail(email);
        }
        recoverUsernameForm.setEmailSubmitted("clicked".equals(request.getParameter("Resume")) || CommonActionSpec.CHECK_USERNAME_RECOVERY_EMAIL.isRequested(request));
        recoverUsernameForm.setPasswordResetRequested("clicked".equals(request.getParameter("pf.passwordreset")));
        return recoverUsernameForm;
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        RecoverUsernameConfiguration configuration = this.getConfiguration(request, response);
        try {
            params.put("email", "email");
            params.put("ok", "Resume");
            params.put("cancel", "Cancel");
            params.put("passwordReset", "pf.passwordreset");
            params.put("supportsPasswordRecovery", configuration.isEnablePasswordRecovery());
            params.put("captchaEnabled", configuration.isEnableCaptcha());
            if (configuration.isEnableCaptcha()) {
                CaptchaProviderRenderUtil.addCaptchaProviderParametersToTemplateParameters(request, response, configuration.getCaptchaProviderId(), "usernameRecovery", "siteKey", params);
            }
            if (!params.containsKey("savedEmail")) {
                params.put("savedEmail", "");
            }
            if (this.redirectToDefaultAuthnApp(request, response)) {
                HashMap stateParams = new HashMap();
                InternalAuthnApiSupport.getDefault().setCurrentAuthnPlugin(request, stateParams, InternalAuthnApiSupport.AuthnPluginType.IDP_ADAPTER, configuration.getAdapterId());
                InternalAuthnApiSupport.getDefault().createFlowAndRedirectToDefaultAuthnApp(request, response, stateParams, USERNAME_RECOVERY_SERVLET);
            } else {
                ResponseHandler.renderUsernameRecoveryEmailRequiredResponse(request, response, configuration.getUsernameRecoveryTemplate(), params);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error on Request to /ext/idrecovery/Recover", (Throwable)ex);
            throw new ProcessRuntimeException((Throwable)ex);
        }
    }

    private void renderEmailSent(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        RecoverUsernameConfiguration configuration = this.getConfiguration(request, response);
        params.put("cancel", "Cancel");
        if (StringUtils.isNotBlank((String)this.getSessionState(request, response).getTargetResource())) {
            params.put(TemplateKey.SUCCESS_CONTINUE.getKey(), "true");
        }
        this.setStage(AbstractPasswordManagementServlet.Stage.COMPLETED, request, response);
        try {
            ResponseHandler.renderUsernameRecoveryEmailSentResponse(request, response, configuration.getUsernameRecoveryInfoTemplate(), params);
        }
        catch (Exception ex) {
            logger.error((Object)"Error on Request to /ext/idrecovery/Recover", (Throwable)ex);
            throw new ProcessRuntimeException((Throwable)ex);
        }
    }

    private static void auditRequestResult(RecoverUsernameResult validationResult) {
        switch (validationResult) {
            case Cancel: 
            case Continue: 
            case CaptchaFailure: 
            case NoEmailAddress: {
                break;
            }
            case Error: {
                PwdResetAuditLogger.logFailure("System error (see server log)");
                break;
            }
            case UserNotFound: {
                PwdResetAuditLogger.logFailure("User not found");
                break;
            }
            case MailNotVerified: {
                PwdResetAuditLogger.logFailure("User found but email address not verified.");
                break;
            }
            case EmailSent: {
                PwdResetAuditLogger.log();
                break;
            }
        }
    }

    private String buildRecoveryEmailSentUrl(HttpServletRequest request) {
        return request.getContextPath() + "/ext/idrecovery/EmailSent";
    }

    private void initializeSessionState(HttpServletRequest request, HttpServletResponse response) {
        boolean internalRedirect;
        boolean bl = internalRedirect = request.getParameter("InternalRedirect") != null;
        if (!internalRedirect) {
            TrackedParamsUtil paramsUtil;
            Map trackedHttpParams;
            String targetResource;
            RecoverUsernameSessionState sessionState = RecoverUsernameSessionState.create(request, response);
            String adapterId = this.getAdapterIdFromRequest(request);
            if (StringUtils.isNotEmpty((String)adapterId)) {
                sessionState.setAdapterId(adapterId);
            }
            if (StringUtils.isNotEmpty((String)(targetResource = request.getParameter("TargetResource")))) {
                if (this.isValidTargetResource(targetResource)) {
                    sessionState.setTargetResource(targetResource);
                } else {
                    logger.warn((Object)String.format("Ignoring request parameter TargetResource '%s' as it does not pass TargetResource validation.", targetResource));
                }
            }
            if (!(trackedHttpParams = (paramsUtil = new TrackedParamsUtil()).retrieveTrackedParams(request)).isEmpty()) {
                sessionState.setTrackedHttpParams(trackedHttpParams);
            }
        }
    }
}

