/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.handler;

import com.pingidentity.access.PasswordCredentialValidatorAccessor;
import com.pingidentity.adapters.htmlform.idp.AuthenticateFormHandler;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.idp.HtmlFormLoginContext;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdchange.model.IdentifyForm;
import com.pingidentity.adapters.htmlform.pwdchange.render.ChangePasswordWithForm;
import com.pingidentity.adapters.htmlform.pwdchange.type.ChangePasswordResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.adapters.htmlform.session.HtmlFormSessionStateSupport;
import com.pingidentity.common.event.Event;
import com.pingidentity.common.event.EventService;
import com.pingidentity.common.event.EventType;
import com.pingidentity.common.security.LockingService;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.password.ChangeablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import com.pingidentity.sdk.password.PasswordPolicyRequirementValidationException;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sdk.session.SessionManager;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.AuthenticationResultEnum;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.util.UserKeyAttributeUtil;
import org.sourceid.util.log.AttributeMap;

public class ChangePasswordHandler
extends BaseHandler {
    private static final Logger log = LogManager.getLogger(ChangePasswordHandler.class);
    private ChangePasswordConfiguration configuration;

    public ChangePasswordHandler(ChangePasswordConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChangePasswordResult changePassword(IdentifyForm form, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ChangePasswordResult result = ChangePasswordResult.Error;
        ChangePasswordSessionState state = ChangePasswordSessionState.get(req, resp);
        HtmlFormLoginContext loginContext = new HtmlFormLoginContext();
        HashMap<String, Object> inParameters = new HashMap<String, Object>();
        TransactionalStateSupport transactionalStateSupport = this.getTransactionalStateSupport(req, resp, state);
        if (HtmlFormIdpAuthnAdapterUtils.supportsPasswordChange(state.getPcvId(), this.configuration.getPwmLocation())) {
            LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(HtmlFormIdpAuthnAdapter.class.getSimpleName() + this.configuration.getAdapterId());
            AuthenticateFormHandler authenticateFormHandler = new AuthenticateFormHandler(state.getSessionKeyLoginContext(), this.configuration, accountLockingService);
            try {
                ChangeablePasswordCredential pcv = (ChangeablePasswordCredential)new PasswordCredentialValidatorAccessor().getPasswordCredentialValidator(state.getPcvId());
                pcv.changePassword(form.getUsername(), form.getCurrentPassword(), form.getNewPassword(), null);
                PwdResetAuditLogger.log();
                if (this.configuration.getPwChangeReauthDelay() > 0) {
                    try {
                        log.debug("Delaying for " + this.configuration.getPwChangeReauthDelay() + " milliseconds before reauthentication can occur.");
                        Thread.sleep(this.configuration.getPwChangeReauthDelay());
                    }
                    catch (Exception e) {
                        log.warn("Failed to sleep for the configured Post-Password Change Re-Authentication Delay", (Throwable)e);
                    }
                }
                if ((loginContext = authenticateFormHandler.authenticateForm(req, resp, inParameters, state.getAuthnPolicy(), form.getUsername(), form.getNewPassword(), "", loginContext.getPcvId(), transactionalStateSupport, false, null, state.isChainedUsernameAvailable(), false, true, null)).isSuccess()) {
                    Map authnIds;
                    result = ChangePasswordResult.Success;
                    if (pcv.isChangePasswordEmailNotifiable() && this.configuration.isEnableChangePasswordEmailNotification() && (authnIds = loginContext.getAuthnIds()) != null) {
                        HashMap<String, Object> eventParams = new HashMap<String, Object>();
                        eventParams.put("givenName", authnIds.get("givenName"));
                        String mailAttribute = pcv instanceof ResettablePasswordCredential ? ((ResettablePasswordCredential)pcv).getMailAttribute() : "mail";
                        eventParams.put("mail", authnIds.get(mailAttribute));
                        eventParams.put("template_name", new AttributeValue(this.configuration.getChangePasswordEmailNotificationTemplateName()));
                        eventParams.put("username", new AttributeValue(form.getUsername()));
                        eventParams.put("locale", LocaleUtil.getUserLocale((HttpServletRequest)req));
                        eventParams.put("adapterId", this.configuration.getAdapterId());
                        eventParams.put("pcvId", state.getPcvId());
                        eventParams.put("notificationPublisher", this.configuration.getNotificationPublisherId());
                        eventParams.put("TransactionId", state.getTransactionId());
                        eventParams.put("entityId", state.getDefaultTemplateParams().get("entityId"));
                        eventParams.put("extendedProperties", state.getDefaultTemplateParams().get("extendedProperties"));
                        Map userAttributes = state.getUserAttributes();
                        if (userAttributes.isEmpty() && pcv instanceof ResettablePasswordCredential) {
                            userAttributes = TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)((ResettablePasswordCredential)pcv).findUser(form.getUsername()));
                        }
                        eventParams.put("userAttributes", userAttributes);
                        EventService eventService = EventService.getService();
                        eventService.addEvent(new Event(EventType.PASSWORD_CHANGE, eventParams));
                    }
                    if (!Util.isEmpty((Map)loginContext.getAuthnIds())) {
                        String idpAdapterId;
                        if (!this.configuration.getSessionState().equals("None")) {
                            HtmlFormSessionStateSupport sessionStateSupport = new HtmlFormSessionStateSupport();
                            sessionStateSupport.removeAttribute(this.configuration.SESSION_KEY_AUTHN, req, resp);
                        }
                        if (!state.isPasswordExpiring() || this.configuration.isRequireReAuthenticationForPendingExpiry()) {
                            TransactionalStateSupport stateSupport = new TransactionalStateSupport(state.getResumeUrl());
                            stateSupport.removeAttribute(state.getSessionKeyLoginContext(), req, resp);
                        }
                        if (HtmlFormIdpAuthnAdapterUtils.isRevokeSessionAfterPasswordChangeOrReset(idpAdapterId = state.getAdapterId())) {
                            this.handleRevokeSessionsAfterPasswordChange(req, resp, loginContext, idpAdapterId);
                        }
                    }
                } else if (loginContext.isRecoverable()) {
                    authenticateFormHandler.saveLoginState(req, resp, form.getUsername(), transactionalStateSupport, loginContext);
                    ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
                    changePasswordWithFormBuilder.setErrorMessageKeyList(null).setAuthnMessageKey(loginContext.getMessageKey()).setPwdQualityRequirementMetMsgList(Collections.emptyList()).setPwdQualityRequirementNotMetMsgList(Collections.emptyList()).build().render(req, resp);
                }
            }
            catch (PasswordCredentialValidatorAuthnException e) {
                String errorMsg = AuthenticateFormHandler.getPasswordCredentialValidatorErrorMessage((Exception)((Object)e));
                if (errorMsg == null) {
                    errorMsg = e.getMessageKey();
                }
                PwdResetAuditLogger.logFailure(errorMsg);
                PwdResetAuditLogger.cleanupAuthnAttempt();
                if (e.isRecoverable()) {
                    authenticateFormHandler.saveLoginState(req, resp, form.getUsername(), transactionalStateSupport, loginContext);
                    if (e instanceof PasswordPolicyRequirementValidationException) {
                        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)req);
                        ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
                        changePasswordWithFormBuilder.setErrorMessageKeyList(null).setAuthnMessageKey(AuthenticationResultEnum.PASSWORD_POLICY_VIOLATED.getMessageKey()).setPwdQualityRequirementMetMsgList(((PasswordPolicyRequirementValidationException)e).getRequirementsMet(userLocale)).setPwdQualityRequirementNotMetMsgList(((PasswordPolicyRequirementValidationException)e).getRequirementsNotMet(userLocale)).build().render(req, resp);
                    } else {
                        ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
                        changePasswordWithFormBuilder.setErrorMessageKeyList(null).setAuthnMessageKey(e.getMessageKey()).setPwdQualityRequirementMetMsgList(Collections.emptyList()).setPwdQualityRequirementNotMetMsgList(Collections.emptyList()).build().render(req, resp);
                    }
                }
                loginContext.setAuthnIds(null);
            }
            catch (Exception e) {
                log.error("Error updating password", (Throwable)e);
                loginContext.setAuthnIds(null);
            }
        } else {
            log.debug("Password change attempt couldn't complete.  Password Credential Validator " + state.getPcvId() + " doesn't support password changes.  If you're using the standard LDAP PCV with ActiveDirectory, SSL must be enabled.  If you implemented a custom PCV, it must implement the ChangeablePasswordCredential interface.");
            return ChangePasswordResult.Error;
        }
        return result;
    }

    private void handleRevokeSessionsAfterPasswordChange(HttpServletRequest req, HttpServletResponse resp, HtmlFormLoginContext loginContext, String idpAdapterId) {
        IdpAuthnAdapterInstance idpAuthnAdapterInstance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(idpAdapterId);
        if (idpAuthnAdapterInstance != null) {
            AdapterAuthnSourceKey adapterAuthnSourceKey = idpAuthnAdapterInstance.getAdapterAuthnSourceKey();
            try {
                String uniqueUserKeyValue = UserKeyAttributeUtil.getUniqueUserKeyValue((AdapterAuthnSourceKey)adapterAuthnSourceKey, (Map)loginContext.getAuthnIds(), (HttpServletRequest)req);
                if (uniqueUserKeyValue != null) {
                    SessionManager sessionManager = new SessionManager();
                    sessionManager.revokeOtherSessionsFor(uniqueUserKeyValue, req, resp);
                }
            }
            catch (AuthnAdapterException | AuthorizationException e) {
                log.error("Unable to get unique user key to proceed with session revocation after successful password change.", e);
            }
        } else {
            log.error("Unable to revoke session after password change, because adapter with ID '" + idpAdapterId + "' not found.");
        }
    }
}

