/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.handler;

import com.pingidentity.adapters.htmlform.idp.AuthenticateFormHandler;
import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter;
import com.pingidentity.adapters.htmlform.idp.HtmlFormLoginContext;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdchange.model.IdentifyForm;
import com.pingidentity.adapters.htmlform.pwdchange.render.ChangePasswordWithForm;
import com.pingidentity.adapters.htmlform.pwdchange.type.IdentifyResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.common.security.AccountLockingService;
import com.pingidentity.common.security.LockingService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.state.TransactionalStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdentifyHandler
extends BaseHandler {
    private static final Log log = LogFactory.getLog(IdentifyHandler.class);
    private final ChangePasswordConfiguration configuration;

    public IdentifyHandler(ChangePasswordConfiguration configuration) {
        this.configuration = configuration;
    }

    public IdentifyResult authenticateExistingCredentials(IdentifyForm identifyForm, HttpServletRequest req, HttpServletResponse resp, ChangePasswordSessionState state) throws IOException {
        LockingService accountLockingService = MgmtFactory.getAccountLockingService().getInstance(HtmlFormIdpAuthnAdapter.class.getSimpleName() + this.configuration.getAdapterId());
        String passwordKey = AccountLockingService.buildPasswordLockingKey((String)identifyForm.getCurrentPassword());
        String accountKey = AccountLockingService.getUserKey((String)req.getRemoteAddr(), (String)identifyForm.getUsername());
        IdentifyResult result = this.checkLockedCredential(accountLockingService, accountKey, passwordKey);
        if (!IdentifyResult.AccountLocked.equals((Object)result)) {
            AuthenticateFormHandler authenticateFormHandler = new AuthenticateFormHandler(state.getSessionKeyLoginContext(), this.configuration, accountLockingService);
            HashMap<String, Object> inParameters = new HashMap<String, Object>();
            TransactionalStateSupport transactionalStateSupport = this.getTransactionalStateSupport(req, resp, state);
            HtmlFormLoginContext loginContext = authenticateFormHandler.authenticateForm(req, resp, inParameters, state.getAuthnPolicy(), identifyForm.getUsername(), identifyForm.getCurrentPassword(), "", null, transactionalStateSupport, false, null, state.isChainedUsernameAvailable(), false, true, null);
            PwdResetAuditLogger.setPcvId((String)loginContext.getPcvId());
            if (loginContext.isSuccess() || loginContext.isError() && loginContext.isRecoverable()) {
                result = IdentifyResult.Authenticated;
                state.setPcvId(loginContext.getPcvId());
                state.setCurrentPassword(identifyForm.getCurrentPassword());
            } else {
                accountLockingService.logFailedLogin(accountKey);
                accountLockingService.logFailedPassword(passwordKey);
                result = this.checkLockedCredential(accountLockingService, accountKey, passwordKey);
                if (!IdentifyResult.AccountLocked.equals((Object)result)) {
                    result = IdentifyResult.Error;
                    PwdResetAuditLogger.logFailure(this.getPasswordChangeErrorMessage(loginContext));
                    PwdResetAuditLogger.cleanupAuthnAttempt();
                    ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
                    changePasswordWithFormBuilder.setErrorMessageKeyList(identifyForm.getErrorList()).setAuthnMessageKey(StringUtils.isNotBlank((String)loginContext.getMessageKey()) ? loginContext.getMessageKey() : "authn.srvr.msg.invalid.credentials").setPwdQualityRequirementMetMsgList(Collections.emptyList()).setPwdQualityRequirementNotMetMsgList(Collections.emptyList()).build().render(req, resp);
                }
            }
        }
        return result;
    }

    private String getPasswordChangeErrorMessage(HtmlFormLoginContext loginContext) {
        Exception error;
        String errorMessage;
        String defaultErrorMsg = "Incorrect current password.";
        if (!loginContext.getExceptionList().isEmpty() && (errorMessage = AuthenticateFormHandler.getPasswordCredentialValidatorErrorMessage(error = (Exception)((Object)loginContext.getExceptionList().get(0)))) != null) {
            return errorMessage;
        }
        return defaultErrorMsg;
    }

    private IdentifyResult checkLockedCredential(LockingService accountLockingService, String accountKey, String passwordKey) {
        IdentifyResult result = null;
        LockingService.IsLockedRequest usernameRequest = new LockingService.IsLockedRequest.Builder(accountKey).loginType(LockingService.FailedLoginType.USERNAME).maxFailedLogins(this.configuration.getNumInvalidAttempts()).lockoutPeriod(AccountLockingService.getLockoutPeriod()).build();
        LockingService.IsLockedRequest passwordRequest = new LockingService.IsLockedRequest.Builder(passwordKey).loginType(LockingService.FailedLoginType.PASSWORD).build();
        if (accountLockingService.isLocked(usernameRequest)) {
            this.logLockedEvent("Account Locked");
            result = IdentifyResult.AccountLocked;
        } else if (accountLockingService.isLocked(passwordRequest)) {
            this.logLockedEvent("Password Locked");
            result = IdentifyResult.AccountLocked;
        }
        return result;
    }

    private void logLockedEvent(String message) {
        String formattedMessage = String.format("[source:%s] %s", "AccountLockingService", message);
        log.error((Object)formattedMessage);
        PwdResetAuditLogger.logFailure(formattedMessage);
        PwdResetAuditLogger.cleanupAuthnAttempt();
    }
}

