/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.render;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfigHelper;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.util.CaptchaProviderRenderUtil;
import com.pingidentity.common.util.HTMLEncoder;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ChangePasswordWithForm {
    private Map<String, Object> params = new HashMap<String, Object>();

    private ChangePasswordWithForm() {
    }

    public void render(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ChangePasswordSessionState state = ChangePasswordSessionState.get(req, resp);
        AbstractPasswordManagementServlet.Stage stage = state.getStage();
        ChangePasswordConfiguration configuration = ChangePasswordConfigHelper.get(state.getAdapterId());
        boolean showUsername = !state.isChainedUsernameAvailable() || configuration.isAllowUsernameEdits() && configuration.isEnableRememberMyUsername();
        String username = StringUtils.defaultString((String)state.getUsername());
        if (AbstractPasswordManagementServlet.Stage.IDENTIFYING.equals((Object)stage) && showUsername && req.getParameter("pf.username") != null) {
            username = req.getParameter("pf.username");
        }
        if (!state.isFromHtmlFormAdapter() || state.getAuthnPolicy().allowUserInteraction() && configuration.isAllowsChangePassword()) {
            boolean isPendingPwdChange = StringUtils.isNotEmpty((String)req.getParameter("pf.passwordExpiring")) && Boolean.TRUE.toString().equals(req.getParameter("pf.passwordExpiring")) || state.isPasswordExpiring();
            this.params.putAll(state.getDefaultTemplateParams());
            this.params.put(TemplateKey.URL.getKey(), req.getContextPath() + "/ext/pwdchange/Identify");
            this.params.put(TemplateKey.NAME.getKey(), "pf.username");
            this.params.put(TemplateKey.USERNAME.getKey(), HTMLEncoder.encode((String)username));
            this.params.put(TemplateKey.PASS.getKey(), "pf.pass");
            this.params.put(TemplateKey.NEW_PASSWORD_1.getKey(), "pf.new.pass1");
            this.params.put(TemplateKey.NEW_PASSWORD_2.getKey(), "pf.new.pass2");
            this.params.put(TemplateKey.OK.getKey(), "pf.ok");
            this.params.put(TemplateKey.CANCEL.getKey(), "pf.cancel");
            this.params.put(TemplateKey.PWM_LOCATION.getKey(), configuration.getPwmLocation());
            this.params.put(TemplateKey.PASSWORD_EXPIRING.getKey(), "pf.passwordExpiring");
            this.params.put(TemplateKey.IS_PASSWORD_EXPIRING.getKey(), isPendingPwdChange);
            this.params.put(TemplateKey.HIDE_CHAINED_USERNAME.getKey(), !showUsername);
            this.params.put(TemplateKey.USERNAME_NOT_CHAINED.getKey(), !state.isChainedUsernameAvailable());
            this.params.put(TemplateKey.CAPTCHA_ENABLED.getKey(), configuration.isCaptchaEnabledPasswordChange());
            this.params.put(TemplateKey.IS_AUTHN_POLICY.getKey(), !StringUtils.isEmpty((String)configuration.getPolicyContractId()));
            this.params.put(TemplateKey.STAGE_IDENTIFYING.getKey(), AbstractPasswordManagementServlet.Stage.IDENTIFYING.equals((Object)stage));
            this.params.put(TemplateKey.STAGE_AUTHENTICATED.getKey(), AbstractPasswordManagementServlet.Stage.AUTHENTICATED.equals((Object)stage));
            if (configuration.isCaptchaEnabledPasswordChange()) {
                CaptchaProviderRenderUtil.addCaptchaProviderParametersToTemplateParameters(req, resp, configuration.getCaptchaProviderId(), "passwordChange", TemplateKey.SITE_KEY.getKey(), this.params);
            }
            ResponseHandler.renderPasswordChangeResponse(req, resp, configuration.getChangePasswordTemplateName(), this.params);
        }
    }

    public static class Builder {
        private ChangePasswordWithForm changePasswordWithForm = new ChangePasswordWithForm();

        public Builder setErrorMessageKeyList(List<String> errorMessageKeyList) {
            this.changePasswordWithForm.params.put(TemplateKey.ERROR_MESSAGE_KEYS.getKey(), errorMessageKeyList);
            return this;
        }

        public Builder setAuthnMessageKey(String authnMessageKey) {
            this.changePasswordWithForm.params.put(TemplateKey.AUTHN_MESSAGE_KEY.getKey(), authnMessageKey);
            return this;
        }

        public Builder setPwdQualityRequirementMetMsgList(List<String> pwdQualityRequirementMetMsgList) {
            this.changePasswordWithForm.params.put(TemplateKey.PWD_QUALITY_REQ_MET_MSG_LIST.getKey(), pwdQualityRequirementMetMsgList);
            return this;
        }

        public Builder setPwdQualityRequirementNotMetMsgList(List<String> pwdQualityRequirementNotMetMsgList) {
            this.changePasswordWithForm.params.put(TemplateKey.PWD_QUALITY_REQ_NOT_MET_MSG_LIST.getKey(), pwdQualityRequirementNotMetMsgList);
            return this;
        }

        public ChangePasswordWithForm build() {
            return this.changePasswordWithForm;
        }
    }
}

