/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.servlet;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfigHelper;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.render.ChangePasswordWithForm;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.servlet.adapter.Handler;

public abstract class AbstractChangePasswordServlet
extends AbstractPasswordManagementServlet
implements Handler {
    private static final Log logger = LogFactory.getLog(AbstractChangePasswordServlet.class);

    @Override
    protected ChangePasswordSessionState getSessionState(HttpServletRequest request, HttpServletResponse response) {
        return ChangePasswordSessionState.get(request, response);
    }

    protected void handleResumableError(HttpServletRequest request, HttpServletResponse response, List<String> errors) throws IOException {
        ChangePasswordWithForm.Builder changePasswordWithFormBuilder = new ChangePasswordWithForm.Builder();
        changePasswordWithFormBuilder.setErrorMessageKeyList(errors).setAuthnMessageKey(null).setPwdQualityRequirementMetMsgList(Collections.emptyList()).setPwdQualityRequirementNotMetMsgList(Collections.emptyList()).build().render(request, response);
    }

    protected void doCancel(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ChangePasswordSessionState sessionState = this.getSessionState(req, resp);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey("html.form.message.template.passwordChangedCancelHeaderMessage");
        if (AuthnApiSupport.getDefault().isApiRequest(req) && sessionState.isFromHtmlFormAdapter()) {
            PasswordChangeHandler.reissueRequestToHtmlFormAdapter(req, resp);
        } else if (!AuthnApiSupport.getDefault().isApiRequest(req) && sessionState.getTargetResource() != null) {
            resp.sendRedirect(sessionState.getTargetResource());
        } else {
            this.handleError(req, resp, "html.form.message.template.passwordChangedCancelHeaderMessage");
        }
    }

    protected void handleError(HttpServletRequest request, HttpServletResponse response, String errorMessage) throws IOException {
        ChangePasswordSessionState sessionState = this.getSessionState(request, response);
        sessionState.setStage(AbstractPasswordManagementServlet.Stage.ERROR);
        sessionState.setErrorMessageKey(errorMessage);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            PasswordChangeHandler.reissueRequestToPasswordChangeError(request, response);
        } else {
            this.redirect(response, this.buildErrorUrl(request));
        }
    }

    @Override
    protected ChangePasswordConfiguration getConfiguration(HttpServletRequest request, HttpServletResponse response) {
        String adapterId = this.getAdapterId(request, response);
        return ChangePasswordConfigHelper.get(adapterId);
    }

    @Override
    protected void populateAdapterActionParam(Map<String, Object> stateParams) {
        stateParams.put("PartnerEntityId", "com.pingidentity.pf.change.password");
        stateParams.put("adapterAction", "com.pingidentity.pf.change.password");
    }

    private String buildErrorUrl(HttpServletRequest request) {
        return request.getContextPath() + "/ext/pwdchange/Error";
    }
}

