/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.servlet;

import com.pingidentity.adapters.htmlform.pwdchange.servlet.AbstractChangePasswordServlet;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class ErrorServlet
extends AbstractChangePasswordServlet {
    private static final Log logger = LogFactory.getLog(ErrorServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        logger.debug((Object)"GET Request to /ext/pwdchange/Error");
        this.render(request, response, this.getDefaultTemplateParams(request, response));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdchange/Error");
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            AuthnApiSupport.getDefault().writeErrorResponse(request, response, CommonErrorSpec.INVALID_ACTION_ID.makeInstanceBuilder().build());
        }
        this.render(request, response, this.getDefaultTemplateParams(request, response));
    }

    protected void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params) {
        params.put(TemplateKey.HEADER_MESSAGE.getKey(), "changePasswordErrorTitle");
        String message = this.getSessionState(request, response).getErrorMessageKey();
        if (!StringUtils.isEmpty((String)message)) {
            params.put(TemplateKey.AUTHN_MESSAGE_KEY.getKey(), message);
        }
        try {
            String templateName = "html.form.message.template.html";
            String adapterId = this.getSessionState(request, response).getAdapterId();
            if (adapterId != null) {
                templateName = this.getConfiguration(request, response).getChangePasswordMessageTemplateName();
            }
            ResponseHandler.renderPasswordChangeErrorResponse(request, response, templateName, params);
        }
        catch (Exception ex) {
            throw new ProcessRuntimeException("Error on request to change password error servlet", (Throwable)ex);
        }
    }

    @Override
    protected boolean canSkipStageValidation() {
        return true;
    }
}

