/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.servlet;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.servlet.AbstractChangePasswordServlet;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetAuthnSourceSupport;
import com.pingidentity.adapters.htmlform.render.handler.api.passwordchange.PasswordChangeHandler;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.profiles.AdapterPathSupport;
import org.sourceid.saml20.state.PasswordResetStateSupport;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.state.StateSupport;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.PasswordResetAuthenticationResult;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PolicyServlet
extends AbstractChangePasswordServlet
implements ResumeRequestFromAuthnResponseHandler {
    private static final long serialVersionUID = 1L;
    private transient PasswordResetStateSupport stateSupport = new PasswordResetStateSupport(MetaDataFactory.getLocalMetaData());
    private static Log logger = LogFactory.getLog(PolicyServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdchange/Policy");
        ChangePasswordConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || StringUtils.isEmpty((String)configuration.getPolicyContractId())) {
            this.handleError(request, response, "html.form.message.template.invalidState");
            return;
        }
        if (this.stateSupport.isResumeRequest(request)) {
            this.resume(request, response);
        } else {
            this.createChangePasswordFlow(request, response, configuration);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdchange/Policy");
        ChangePasswordConfiguration configuration = this.getConfiguration(request, response);
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATING, request, response) || StringUtils.isEmpty((String)configuration.getPolicyContractId())) {
            this.handleError(request, response, "html.form.message.template.invalidState");
            return;
        }
        if (this.stateSupport.isResumeRequest(request)) {
            this.resume(request, response);
        } else {
            this.createChangePasswordFlow(request, response, configuration);
        }
    }

    private void resume(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String stateKey = this.stateSupport.getStateKey(request, response);
        try {
            State state = StateMgmtFactory.retrieveAndRemoveState((String)stateKey, (boolean)false, (HttpServletRequest)request, (HttpServletResponse)response);
            if (state == null) {
                this.handleError(request, response, "html.form.message.template.invalidState");
                return;
            }
            this.resumeAuthn(state.getInMsgCtx(), request, response, state.getOutMsgCtx(), state.getParameters());
        }
        catch (RenderPageException renderPageException) {
            // empty catch block
        }
    }

    private void createChangePasswordFlow(HttpServletRequest request, HttpServletResponse response, ChangePasswordConfiguration configuration) throws IOException {
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        InMessageContext inMsgCtx = new InMessageContext();
        this.populateStateParamsForFlow(request, response, stateParams, inMsgCtx);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            String contextRoot = PropertyInfo.getContextPath();
            contextRoot = contextRoot.equals("/") ? "" : contextRoot;
            String policyPath = contextRoot + "/ext/pwdchange/Policy";
            String flowId = AuthnApiSupport.getDefault().getFlowId(request.getPathInfo());
            StateSupport.overridePath((HttpServletRequest)request, (String)this.stateSupport.makeResumePath(policyPath, false, flowId));
        }
        this.resumeAuthn(inMsgCtx, request, response, null, stateParams);
    }

    @Override
    protected String getPolicyId(HttpServletRequest request, HttpServletResponse response) {
        String policyID = this.getConfiguration(request, response).getPolicyContractId();
        return policyID;
    }

    private void handleAuthnResult(HttpServletRequest request, HttpServletResponse response, PasswordResetAuthenticationResult authnResult, Map<String, Object> stateParams) throws IOException {
        ChangePasswordConfiguration configuration = this.getConfiguration(request, response);
        switch (authnResult.getStatus()) {
            case RESTART: {
                break;
            }
            case FINISHED: {
                ChangePasswordSessionState state = this.getSessionState(request, response);
                this.restoreParentFlowState(request, response, stateParams);
                if (authnResult.getAuthnBeans() == null) {
                    this.handleError(request, response, "html.form.message.template.authFailed");
                    break;
                }
                if (StringUtils.isNotEmpty((String)configuration.getPolicyContractId()) && configuration.getPasswordUpdateTimeout() != null) {
                    state.refreshPasswordUpdateSession();
                }
                state.setStage(AbstractPasswordManagementServlet.Stage.AUTHENTICATED);
                if (AuthnApiSupport.getDefault().isApiRequest(request)) {
                    PasswordChangeHandler.reissueRequestToPasswordChangeIdentifyServlet(request, response);
                    break;
                }
                String changePasswordEndpoint = AdapterPathSupport.convertPath((HttpServletRequest)request, (HttpServletResponse)response, (String)"/ext/pwdchange/Identify?InternalRedirect=true");
                this.redirect(response, changePasswordEndpoint);
                break;
            }
            case FALL_THROUGH: {
                this.restoreParentFlowState(request, response, stateParams);
                logger.debug((Object)("Failed to select a Policy during Change Password for Adapter ID:" + configuration.getAdapterId()));
                this.handleError(request, response, "html.form.message.template.unknownError");
                break;
            }
        }
    }

    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest request, HttpServletResponse response, OutMessageContext outMsgCtx, Map<String, Object> stateParams) throws IOException {
        boolean isValid = this.validateTransactionId(request, response, stateParams.get("PRPS.PolicyTransactionId"));
        if (!isValid) {
            String msg = "The password change transaction failed due to authentication policy transaction ID change";
            logger.debug((Object)msg);
            this.handleError(request, response, "html.form.message.template.unknownError");
            return;
        }
        String resumePath = this.stateSupport.saveState(request, response, inMsgCtx, outMsgCtx, stateParams, null);
        try {
            PasswordResetAuthnSourceSupport pwdResetAuthnSourceSupport = new PasswordResetAuthnSourceSupport();
            AuthnPolicy authnPolicy = new AuthnPolicy(true, true);
            PasswordResetAuthenticationResult authnResult = pwdResetAuthnSourceSupport.lookupAuthNs(request, response, authnPolicy, resumePath, stateParams, inMsgCtx, null, (ResumeRequestFromAuthnResponseHandler)this, false);
            if (authnResult != null) {
                this.handleAuthnResult(request, response, authnResult, stateParams);
            } else if (!response.isCommitted()) {
                this.handleError(request, response, "html.form.message.template.unknownError");
            }
        }
        catch (IOException | AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
            this.restoreParentFlowState(request, response, stateParams);
            logger.error((Object)("Error processing selected policy for policy contract ID: " + stateParams.get("policy_contract_id") + ". " + (Exception)e));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e.getMessage(), e);
            }
            this.handleError(request, response, "html.form.message.template.unknownError");
        }
    }

    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext reqInMsgCtx, OutMessageContext respOutMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) {
    }

    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return this.isAuthnApiHandlesResult(req, stateParams);
    }

    public boolean isAuthnApiHandlesResult(HttpServletRequest req, Map<String, Object> stateParams) {
        return AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(stateParams) || this.getOrigAuthnApiAppId(stateParams) != null;
    }

    public AuthnApiApplication getAuthnApiAppOverride(HttpServletRequest req, Map<String, Object> stateParams) {
        String authnApiAppId = this.getOrigAuthnApiAppId(stateParams);
        if (authnApiAppId == null) {
            return null;
        }
        return MgmtFactory.getAuthnApiManager().getApiApplication(authnApiAppId);
    }
}

