/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdchange.servlet;

import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordConfiguration;
import com.pingidentity.adapters.htmlform.pwdchange.common.ChangePasswordSessionState;
import com.pingidentity.adapters.htmlform.pwdchange.servlet.AbstractChangePasswordServlet;
import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.adapters.htmlform.render.handler.ResponseHandler;
import com.pingidentity.adapters.htmlform.render.handler.api.HtmlFormAuthnApiHandler;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.model.state.Completed;
import com.pingidentity.sdk.api.authn.model.state.Resume;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class SuccessServlet
extends AbstractChangePasswordServlet {
    private static final Log logger = LogFactory.getLog(SuccessServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug((Object)"GET Request to /ext/pwdchange/Success");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, req, resp)) {
            this.handleError(req, resp, "html.form.message.template.invalidState");
            return;
        }
        ChangePasswordSessionState state = ChangePasswordSessionState.get(req, resp);
        ChangePasswordConfiguration configuration = this.getConfiguration(req, resp);
        String targetUrl = state.getTargetResource();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> defaultParams = this.getDefaultTemplateParams(req, resp);
        if (defaultParams != null && !defaultParams.isEmpty()) {
            params.putAll(defaultParams);
        }
        params.put(TemplateKey.HEADER_MESSAGE.getKey(), StringUtils.isNotBlank((String)state.getTargetResource()) ? "passwordChangedHeaderMessage" : "passwordChangedNoTargetResourceHeaderMessage");
        params.put(TemplateKey.AUTHN_MESSAGE_KEY.getKey(), null);
        params.put(TemplateKey.REDIRECT_URL.getKey(), targetUrl);
        params.put(TemplateKey.LINK_TEXT.getKey(), "passwordChangedLinkText");
        if (AuthnApiSupport.getDefault().isApiRequest(req) && !state.isFromHtmlFormAdapter()) {
            this.renderAuthnApiDirectLinkPasswordChangeResponse(req, resp, targetUrl);
        } else {
            ResponseHandler.renderSuccessfulPasswordChangeResponse(req, resp, configuration.getChangePasswordMessageTemplateName(), params);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug((Object)"POST Request to /ext/pwdchange/Success");
        if (!this.validStage(AbstractPasswordManagementServlet.Stage.COMPLETED, req, resp)) {
            this.handleError(req, resp, "html.form.message.template.invalidState");
            return;
        }
        if (AuthnApiSupport.getDefault().isApiRequest(req)) {
            ChangePasswordSessionState state = this.getSessionState(req, resp);
            if (!state.isFromHtmlFormAdapter()) {
                AuthnApiSupport.getDefault().writeErrorResponse(req, resp, CommonErrorSpec.INVALID_ACTION_ID.makeInstanceBuilder().build());
            } else if (HtmlFormAuthnApiHandler.isValidApiPostRequest(req, resp, state.getResumeUrl(), null)) {
                HtmlFormAuthnApiHandler.reissueRequestToHtmlFormAdapter(req, resp);
            }
        } else {
            throw new ProcessRuntimeException("Unexpected POST request.");
        }
    }

    private void renderAuthnApiDirectLinkPasswordChangeResponse(HttpServletRequest request, HttpServletResponse response, String targetUrl) throws IOException {
        if (targetUrl == null) {
            AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, CommonStateSpec.COMPLETED.makeInstance(request, (Object)new Completed()));
        } else {
            Resume resume = new Resume();
            resume.setResumeUrl(targetUrl);
            AuthnApiSupport.getDefault().writeAuthnStateResponse(request, response, CommonStateSpec.RESUME.makeInstance(request, (Object)resume));
        }
    }
}

