/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdmgmt.common;

import com.pingidentity.adapters.htmlform.pwdmgmt.servlet.AbstractPasswordManagementServlet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.internal.TransactionIdSupport;

public abstract class PasswordManagementSessionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String PASSWORD_MANAGEMENT_SESSION_STATE = "PasswordManagementSessionState";
    private AbstractPasswordManagementServlet.Stage stage = AbstractPasswordManagementServlet.Stage.IDENTIFYING;
    private String adapterId;
    private String partnerId;
    private String targetResource;
    private String pcvId;
    private String username;
    private boolean fromHtmlFormAdapter;
    private String policyTransactionId;
    private long passwordUpdateActivityTimeMillis = 0L;
    private Map<String, Collection<String>> trackedHttpParams = Collections.emptyMap();
    private String errorMessageKey;
    private Map<String, Object> defaultTemplateParams = new HashMap<String, Object>();
    private String transactionId;
    public Map<String, Object> userAttributes = new HashMap<String, Object>();
    private boolean success;
    private String resumeUrl = null;

    public static <T extends PasswordManagementSessionState> T getAndPreserveTransactionId(HttpServletRequest request, HttpServletResponse response, Class<T> sessionStateType) {
        return PasswordManagementSessionState.get(request, response, sessionStateType, null, false);
    }

    protected static <T extends PasswordManagementSessionState> T get(HttpServletRequest request, HttpServletResponse response, Class<T> sessionStateType, Supplier<T> supplier) {
        return PasswordManagementSessionState.get(request, response, sessionStateType, supplier, true);
    }

    private static <T extends PasswordManagementSessionState> T get(HttpServletRequest request, HttpServletResponse response, Class<T> sessionStateType, Supplier<T> supplier, boolean restoreTransactionId) {
        Object state = request.getAttribute(PASSWORD_MANAGEMENT_SESSION_STATE);
        if (sessionStateType.isInstance(state)) {
            return (T)((PasswordManagementSessionState)sessionStateType.cast(state));
        }
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        state = sessionStateSupport.getAttribute(PASSWORD_MANAGEMENT_SESSION_STATE, request, response);
        if (sessionStateType.isInstance(state)) {
            PasswordManagementSessionState result = (PasswordManagementSessionState)sessionStateType.cast(state);
            if (restoreTransactionId) {
                TransactionIdSupport.setTransactionId((String)result.getTransactionId());
            }
            result.attach(request, response, restoreTransactionId);
            return (T)result;
        }
        if (supplier != null) {
            PasswordManagementSessionState t = (PasswordManagementSessionState)supplier.get();
            t.setTransactionId(TransactionIdSupport.getTransactionId());
            return (T)t;
        }
        return null;
    }

    public static void delete(HttpServletRequest request, HttpServletResponse response) {
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        sessionStateSupport.removeAttribute(PASSWORD_MANAGEMENT_SESSION_STATE, request, response);
        request.removeAttribute(PASSWORD_MANAGEMENT_SESSION_STATE);
        HttpServletRespProxy.clearRunnable((HttpServletResponse)response, (String)PASSWORD_MANAGEMENT_SESSION_STATE);
    }

    protected void attach(HttpServletRequest request, HttpServletResponse response) {
        this.attach(request, response, true);
    }

    protected void attach(HttpServletRequest request, HttpServletResponse response, boolean saveAsRequestAttribute) {
        if (saveAsRequestAttribute) {
            request.setAttribute(PASSWORD_MANAGEMENT_SESSION_STATE, (Object)this);
        }
        HttpServletRespProxy.setRunnable((HttpServletResponse)response, (String)PASSWORD_MANAGEMENT_SESSION_STATE, () -> this.save(request, response));
    }

    protected void save(HttpServletRequest request, HttpServletResponse response) {
        SessionStateSupport sessionStateSupport = new SessionStateSupport();
        sessionStateSupport.setAttribute(PASSWORD_MANAGEMENT_SESSION_STATE, (Object)this, request, response, true);
    }

    public AbstractPasswordManagementServlet.Stage getStage() {
        return this.stage;
    }

    public void setStage(AbstractPasswordManagementServlet.Stage stage) {
        this.stage = stage;
    }

    public String getTargetResource() {
        return this.targetResource;
    }

    public void setTargetResource(String targetResource) {
        this.targetResource = targetResource;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public String getPcvId() {
        return this.pcvId;
    }

    public void setPcvId(String pcvId) {
        this.pcvId = pcvId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPolicyTransactionId() {
        return this.policyTransactionId;
    }

    public void setPolicyTransactionId(String policyTransactionId) {
        this.policyTransactionId = policyTransactionId;
    }

    public void refreshPasswordUpdateSession() {
        this.passwordUpdateActivityTimeMillis = System.currentTimeMillis();
    }

    public boolean isPasswordUpdateSessionExpired(Integer sessionTimeoutMins) {
        if (this.passwordUpdateActivityTimeMillis == 0L || sessionTimeoutMins == null) {
            return false;
        }
        long sessionTimeoutMillis = sessionTimeoutMins.longValue() * 60L * 1000L;
        return System.currentTimeMillis() - this.passwordUpdateActivityTimeMillis > sessionTimeoutMillis;
    }

    public Map<String, Collection<String>> getTrackedHttpParams() {
        return this.trackedHttpParams;
    }

    public void setTrackedHttpParams(Map<String, Collection<String>> trackedHttpParams) {
        this.trackedHttpParams = trackedHttpParams;
    }

    public boolean isFromHtmlFormAdapter() {
        return this.fromHtmlFormAdapter;
    }

    public void setFromHtmlFormAdapter(boolean fromHtmlFormAdapter) {
        this.fromHtmlFormAdapter = fromHtmlFormAdapter;
    }

    public String getErrorMessageKey() {
        return this.errorMessageKey;
    }

    public void setErrorMessageKey(String errorMessageKey) {
        this.errorMessageKey = errorMessageKey;
    }

    public Map<String, Object> getDefaultTemplateParams() {
        return this.defaultTemplateParams;
    }

    public void setDefaultTemplateParams(Map<String, Object> defaultTemplateParams) {
        this.defaultTemplateParams = defaultTemplateParams;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getResumeUrl() {
        return this.resumeUrl;
    }

    public void setResumeUrl(String resumeUrl) {
        this.resumeUrl = resumeUrl;
    }

    public boolean doesResumeUrlMatch(String resumeUrl) {
        return StringUtils.equals((String)this.resumeUrl, (String)resumeUrl);
    }

    public void setSuccessAuthenticationStageCompleted() {
        this.stage = AbstractPasswordManagementServlet.Stage.COMPLETED;
        this.success = true;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setUserAttributes(Map<String, Object> userAttributes) {
        this.userAttributes = userAttributes;
    }

    public Map<String, Object> getUserAttributes() {
        return this.userAttributes;
    }
}

