/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdmgmt.servlet;

import com.pingidentity.adapters.htmlform.pwdmgmt.PasswordManagementConfiguration;
import com.pingidentity.adapters.htmlform.pwdmgmt.common.PasswordManagementSessionState;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.common.util.EscapeUtils;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.api.authn.internal.InternalAuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.templates.mgmt.DefaultTemplateParams;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.InvalidRedirectValidationException;
import org.sourceid.saml20.domain.mgmt.TargetResourceValidationMgr;
import org.sourceid.saml20.domain.util.plugin.AdapterDefaultTemplateParams;
import org.sourceid.saml20.state.State;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.authn.AuthnApiCookielessUtils;
import org.sourceid.websso.authn.AuthnApiPolicyUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.servlet.adapter.Handler;
import org.sourceid.websso.wrapper.InMessageContext;

public abstract class AbstractPasswordManagementServlet
extends HttpServlet
implements Handler {
    private static Log logger = LogFactory.getLog(AbstractPasswordManagementServlet.class);
    private static final String ATTR_STAGE_VALIDATED = "APMS.StageValidated";
    protected static final String PARAM_ORIG_AUTHN_API_APP_ID = "PRPS.OrigAuthnApiAppId";
    protected static final String PARAM_PARENT_FLOW_STATE = "PRPS.ParentFlowState";
    protected static final String PARAM_POLICY_TRANSACTION_ID = "PRPS.PolicyTransactionId";
    private TargetResourceValidationMgr redirectValidationMgr = (TargetResourceValidationMgr)GlobalRegistry.getService(TargetResourceValidationMgr.class);

    protected abstract PasswordManagementConfiguration getConfiguration(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void populateAdapterActionParam(Map<String, Object> var1);

    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<Object, Object> defaultTemplateParams = Collections.emptyMap();
        PasswordManagementSessionState sessionState = PasswordManagementSessionState.getAndPreserveTransactionId(req, resp, PasswordManagementSessionState.class);
        if (sessionState != null) {
            defaultTemplateParams = sessionState.getDefaultTemplateParams();
        }
        String oidcUiLocalesStr = defaultTemplateParams == null ? null : (String)defaultTemplateParams.get(AdapterDefaultTemplateParams.OIDC_UI_LOCALES.getParamName());
        HttpServletRequest wrappedRequest = StringUtils.isNotBlank(oidcUiLocalesStr) ? LocaleUtil.createLocaleWrappedRequest((HttpServletRequest)req, (String)oidcUiLocalesStr) : req;
        HttpServletRespProxy.setRunnable((HttpServletResponse)resp, (String)"APMS.CheckStageValidated", () -> this.checkStageValidated(wrappedRequest));
        this.service(wrappedRequest, resp);
    }

    private void checkStageValidated(HttpServletRequest req) {
        if (!this.canSkipStageValidation() && !this.wasStageValidated(req)) {
            throw new ProcessRuntimeException("Missing stage validation: ensure that servlet checks the stage is valid by calling validStage()");
        }
    }

    protected void populateStateParamsForFlow(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams, InMessageContext inMsgCtx) {
        Map<String, Collection<String>> trackedParams = this.getSessionState(request, response).getTrackedHttpParams();
        if (trackedParams == null) {
            trackedParams = new HashMap<String, Collection<String>>();
        }
        stateParams.put("pf.TrackedHttpParams", trackedParams);
        String username = this.getUsername(request, response);
        inMsgCtx.setRequestedUserId(username);
        String policyContractId = this.getPolicyId(request, response);
        stateParams.put("policy_contract_id", policyContractId);
        this.populateAdapterActionParam(stateParams);
        if (AuthnApiSupport.getDefault().isApiRequest(request)) {
            State parentFlowState = AuthnApiPolicyUtil.getDefault().getApiFlowState(request);
            if (parentFlowState == null) {
                throw new ProcessRuntimeException("Missing parent flow state during password management API request using authn policy");
            }
            String oauthFlowId = InternalAuthnApiSupport.getDefault().getAuthnAPIOAuthFlowID(request);
            boolean redirectless = false;
            AuthnApiApplication origAuthnApiApplication = null;
            Map origStateParams = parentFlowState.getParameters();
            if (origStateParams != null) {
                origAuthnApiApplication = AuthnApiPolicyUtil.getDefault().getLastAuthnApiApplication(origStateParams);
                redirectless = AuthnApiPolicyUtil.getDefault().isRedirectlessApiFlow(origStateParams);
            }
            InternalAuthnApiSupport.getDefault().addStateParamsToRequest(request, stateParams);
            State newState = new State();
            newState.setInMsgCtx(inMsgCtx);
            newState.setParameters(stateParams);
            AuthnApiPolicyUtil.getDefault().setApiFlowState(request, newState);
            if (oauthFlowId != null) {
                InternalAuthnApiSupport.getDefault().setAuthnAPIOAuthFlowID(request, oauthFlowId);
            }
            if (redirectless) {
                AuthnApiPolicyUtil.getDefault().setRedirectlessApiFlow(stateParams, true);
                AuthnApiCookielessUtils cookielessUtils = AuthnApiCookielessUtils.newInstance();
                boolean cookielessApiFlow = cookielessUtils.isCookielessApiFlow(origStateParams);
                cookielessUtils.setCookielessApiFlow(stateParams, cookielessApiFlow);
            }
            if (origAuthnApiApplication != null) {
                AuthnApiPolicyUtil.getDefault().saveLastAuthnApiApplication(stateParams, origAuthnApiApplication);
                this.setOrigAuthnApiAppId(stateParams, origAuthnApiApplication.getId());
            }
            stateParams.put(PARAM_PARENT_FLOW_STATE, parentFlowState);
        }
        String transactionId = IDGenerator.rndAlphaNumeric((int)25);
        stateParams.put(PARAM_POLICY_TRANSACTION_ID, transactionId);
        this.getSessionState(request, response).setPolicyTransactionId(transactionId);
    }

    protected abstract PasswordManagementSessionState getSessionState(HttpServletRequest var1, HttpServletResponse var2);

    protected void setStage(Stage stage, HttpServletRequest request, HttpServletResponse response) {
        this.getSessionState(request, response).setStage(stage);
    }

    protected boolean validStage(Stage stage, HttpServletRequest request, HttpServletResponse response) {
        return this.validStage(Collections.singletonList(stage), request, response);
    }

    protected boolean validStage(Collection<Stage> allowedStages, HttpServletRequest request, HttpServletResponse response) {
        this.setStageValidated(request);
        Stage stage = this.getSessionState(request, response).getStage();
        return allowedStages.contains((Object)stage);
    }

    protected Stage getStage(HttpServletRequest request, HttpServletResponse response) {
        return this.getSessionState(request, response).getStage();
    }

    protected String getUsername(HttpServletRequest request, HttpServletResponse response) {
        return this.getSessionState(request, response).getUsername();
    }

    protected String getAdapterId(HttpServletRequest request, HttpServletResponse response) {
        return this.getSessionState(request, response).getAdapterId();
    }

    protected String getPolicyId(HttpServletRequest request, HttpServletResponse response) {
        PasswordManagementConfiguration configuration = this.getConfiguration(request, response);
        return configuration.getPolicyContractId();
    }

    protected String getOrigAuthnApiAppId(Map<String, Object> stateParams) {
        return (String)stateParams.get(PARAM_ORIG_AUTHN_API_APP_ID);
    }

    private void setOrigAuthnApiAppId(Map<String, Object> stateParams, String appId) {
        stateParams.put(PARAM_ORIG_AUTHN_API_APP_ID, appId);
    }

    protected void restoreParentFlowState(HttpServletRequest request, HttpServletResponse response, Map<String, Object> stateParams) {
        if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
            return;
        }
        State parentFlowState = (State)stateParams.get(PARAM_PARENT_FLOW_STATE);
        if (parentFlowState == null) {
            throw new ProcessRuntimeException("Missing parent flow state during password management API request using authn policy");
        }
        AuthnApiPolicyUtil.getDefault().setApiFlowState(request, parentFlowState);
        InternalAuthnApiSupport.getDefault().addStateParamsToRequest(request, parentFlowState.getParameters());
    }

    protected String getAdapterIdFromRequest(HttpServletRequest request) {
        String requestAdapterId = request.getParameter("AdapterId");
        if (requestAdapterId == null) {
            requestAdapterId = request.getParameter("adapterId");
        }
        return requestAdapterId;
    }

    protected Map<String, Object> getDefaultTemplateParams(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)request);
        params.put(TemplateKey.PLUGIN_LOCALE.getKey(), request.getLocale());
        PasswordManagementSessionState sessionState = PasswordManagementSessionState.getAndPreserveTransactionId(request, response, PasswordManagementSessionState.class);
        if (sessionState != null) {
            params.putAll(sessionState.getDefaultTemplateParams());
        }
        String entityId = Objects.toString(params.get(AdapterDefaultTemplateParams.ENTITY_ID.getParamName()), null);
        String clientId = Objects.toString(params.get(AdapterDefaultTemplateParams.CLIENT_ID.getParamName()), null);
        params.putAll(new DefaultTemplateParams.Builder(DefaultTemplateParams.Role.IDP).entityId(entityId).clientId(clientId).build());
        if (!AuthnApiSupport.getDefault().isApiRequest(request)) {
            LanguagePackMessages lpm = new LanguagePackMessages("pingfederate-messages", userLocale);
            params.put(TemplateKey.PLUGIN_TEMPLATE_MESSAGES.getKey(), lpm);
        }
        return params;
    }

    protected void clearState(HttpServletRequest request, HttpServletResponse response) {
        PasswordManagementSessionState.delete(request, response);
    }

    public void redirect(HttpServletResponse response, String servletPath) {
        this.redirect(response, servletPath, true);
    }

    public void redirect(HttpServletResponse response, String servletPath, boolean escape) {
        try {
            String path = escape ? EscapeUtils.escape((String)servletPath) : servletPath;
            response.sendRedirect(path);
        }
        catch (IOException e) {
            logger.error((Object)("Error redirecting to: " + servletPath), (Throwable)e);
        }
    }

    protected boolean redirectToDefaultAuthnApp(HttpServletRequest request, HttpServletResponse response) {
        return !this.getSessionState(request, response).isFromHtmlFormAdapter() && !AuthnApiSupport.getDefault().isApiRequest(request) && InternalAuthnApiSupport.getDefault().isDefaultAuthnAppEnabled();
    }

    protected Map<String, Object> getCaptchaProviderInParams(HttpServletRequest request, HttpServletResponse response, PasswordManagementSessionState sessionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("com.pingidentity.adapter.input.parameter.tracking.id", TrackingIdSupport.generateTrackingId((HttpServletRequest)request, (HttpServletResponse)response));
        parameters.put("com.pingidentity.adapter.input.parameter.request.id", TrackingIdSupport.getRequestId());
        parameters.put("com.pingidentity.adapter.input.parameter.transaction.id", sessionState.getTransactionId());
        parameters.put("com.pingidentity.adapter.input.parameter.resume.path", sessionState.getResumeUrl());
        return parameters;
    }

    protected boolean validateTransactionId(HttpServletRequest request, HttpServletResponse response, Object transactionIdObj) {
        boolean result = false;
        if (transactionIdObj instanceof String) {
            String globalTransactionId = this.getSessionState(request, response).getPolicyTransactionId();
            String transactionId = (String)transactionIdObj;
            result = StringUtils.equals((String)transactionId, (String)globalTransactionId);
        }
        return result;
    }

    protected boolean isValidTargetResource(String targetResource) {
        if (!this.redirectValidationMgr.isEnableValidationTargetResourceSLOAndOther()) {
            return true;
        }
        try {
            this.redirectValidationMgr.validateTargetResourceSloAndOther(targetResource, null);
            return true;
        }
        catch (InvalidRedirectValidationException invalidRedirectValidationException) {
            return false;
        }
    }

    protected boolean canSkipStageValidation() {
        return false;
    }

    private boolean wasStageValidated(HttpServletRequest request) {
        return request.getAttribute(ATTR_STAGE_VALIDATED) != null;
    }

    private void setStageValidated(HttpServletRequest request) {
        request.setAttribute(ATTR_STAGE_VALIDATED, (Object)true);
    }

    public static enum Stage {
        IDENTIFYING,
        AUTHENTICATING,
        AUTHENTICATED,
        COMPLETED,
        ERROR;

    }
}

