/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.common;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.ProxyScoping;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupportBase;
import org.sourceid.saml20.profiles.idp.authn.AuthnSelectionResult;
import org.sourceid.saml20.profiles.idp.authn.MappedAuthnSourcesAndApcs;
import org.sourceid.servlet.HttpServletRespProxy;
import org.sourceid.websso.authn.ApiRedirectWrapper;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.PasswordResetAuthenticationResult;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PasswordResetAuthnSourceSupport
extends AuthnSourceSupportBase {
    public static final String PARAM_PARTNER_POLICY_CONTRACT_ID = "policy_contract_id";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected MappedAuthnSourcesAndApcs getMappedSources(HttpServletRequest req, Map<String, Object> stateParams, BaseMessageContext messageContext, ProxyScoping proxyScoping) {
        String apcId = (String)stateParams.get(PARAM_PARTNER_POLICY_CONTRACT_ID);
        HashSet mappedAuthnSourceKeys = new HashSet();
        HashSet<String> mappedContractIds = new HashSet<String>();
        mappedContractIds.add(apcId);
        if (mappedAuthnSourceKeys.isEmpty() && mappedContractIds.isEmpty()) {
            throw new ProcessRuntimeException("No authentication sources (IdP adapters or IdP connections) configured for the Authentication Policy Contract with Id: " + apcId);
        }
        return new MappedAuthnSourcesAndApcs(mappedAuthnSourceKeys, mappedContractIds);
    }

    protected String makeNoMappingErrMsg(Map<String, Object> stateParams, String escapedParam) {
        String apcId = (String)stateParams.get(PARAM_PARTNER_POLICY_CONTRACT_ID);
        StringBuilder sb = new StringBuilder();
        sb.append(PARAM_PARTNER_POLICY_CONTRACT_ID).append(" was specified as ").append(escapedParam);
        sb.append(" but ").append(apcId).append(" does not have a mapping defined for that Policy Contract.");
        return sb.toString();
    }

    public PasswordResetAuthenticationResult lookupAuthNs(HttpServletRequest request, HttpServletResponse response, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, ResumeRequestFromAuthnResponseHandler requestHandler, boolean adapterLogoutRequired) throws IOException, AuthnProcessorException, AuthnAdapterException, AuthorizationException {
        try {
            ApiRedirectWrapper wrapper = new ApiRedirectWrapper(request, response, resumePath, stateParams, inMsgCtx, outMsgCtx, requestHandler);
            PasswordResetAuthenticationResult passwordResetAuthenticationResult = (PasswordResetAuthenticationResult)wrapper.wrap(() -> this.localLookupAuthNs(request, response, authnPolicy, resumePath, stateParams, inMsgCtx, requestHandler));
            return passwordResetAuthenticationResult;
        }
        catch (AuthorizationRequestException e) {
            throw new ProcessRuntimeException("Unexpected exception during authentication policy processing", (Throwable)e);
        }
        finally {
            HttpServletRespProxy.clearRunnable((HttpServletResponse)response);
        }
    }

    private PasswordResetAuthenticationResult localLookupAuthNs(HttpServletRequest req, HttpServletResponse resp, AuthnPolicy authnPolicy, String resumePath, Map<String, Object> stateParams, InMessageContext inMsgCtx, ResumeRequestFromAuthnResponseHandler reqHandler) throws IOException, AuthnAdapterException, AuthnProcessorException, AuthorizationException {
        AuthnSelectionResult authnSelectionResult = null;
        AuthnSourceSupportBase.MappedSourcesWrapper mappedSources = new AuthnSourceSupportBase.MappedSourcesWrapper((AuthnSourceSupportBase)this, req, stateParams, authnPolicy, (BaseMessageContext)inMsgCtx);
        this.populateStateParamsWithResumeInfo(resumePath, stateParams, reqHandler);
        try {
            if (this.isAuthnSelectionEnabled(stateParams)) {
                authnSelectionResult = this.doTreeAuthn(req, resp, resumePath, stateParams, authnPolicy, inMsgCtx, null, mappedSources, reqHandler, false);
            } else {
                this.log.warn((Object)"IDP Authentication Policies is disabled, the current configuration requires the IDP Authentication Policies to be enabled.");
            }
            if (authnSelectionResult != null) {
                return new PasswordResetAuthenticationResult(authnSelectionResult);
            }
            return null;
        }
        catch (IOException | AuthnAdapterException | AuthorizationException | AuthnProcessorException e) {
            this.cleanUpStateParams(stateParams);
            throw e;
        }
    }
}

