/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.AccountUnlockSuccessForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResetResult;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.account.AccountUnlockablePasswordCredential;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class AccountUnlockHandler
extends BaseHandler {
    private static Log logger = LogFactory.getLog(AccountUnlockHandler.class);

    public AccountUnlockHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
    }

    public AccountUnlockSuccessAction action(AccountUnlockSuccessForm form, HttpServletRequest request, HttpServletResponse response) {
        if (form.isContinue()) {
            return AccountUnlockSuccessAction.Continue;
        }
        if (form.isReset()) {
            return AccountUnlockSuccessAction.Reset;
        }
        return AccountUnlockSuccessAction.Cancel;
    }

    public ResetResult isUserAccountLocked(String username, HttpServletRequest request, HttpServletResponse response) {
        String pcvId = this.getSessionState().getPcvId();
        boolean isLocked = false;
        try {
            PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            if (pcv instanceof AccountUnlockablePasswordCredential) {
                isLocked = ((AccountUnlockablePasswordCredential)pcv).isAccountLocked(username);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while checking for user account status: " + username), (Throwable)e);
            return ResetResult.Error;
        }
        if (isLocked) {
            return ResetResult.Locked;
        }
        return ResetResult.None;
    }

    public ResetResult unlockAccount(String username, HttpServletRequest request, HttpServletResponse response) {
        String pcvId = this.getSessionState().getPcvId();
        try {
            boolean unlockSuccess;
            PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            if (pcv instanceof AccountUnlockablePasswordCredential && (unlockSuccess = ((AccountUnlockablePasswordCredential)pcv).unlockAccount(username))) {
                Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)request);
                this.sendNotice(username, "Success", pcvId, userLocale);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while unlocking the user account: " + username + ". " + e.getMessage()), (Throwable)e);
            return ResetResult.Error;
        }
        return ResetResult.Success;
    }

    private void sendNotice(String username, String status, String pcvId, Locale locale) {
        AttributeMap userAttributes = this.getAttributes(username, pcvId);
        Map<String, Object> templateParams = this.getSessionState().getDefaultTemplateParams();
        templateParams.put(TemplateKey.USER_ATTRIBUTES.getKey(), this.getSessionState().getUserAttributes());
        if (userAttributes != null) {
            ResettablePasswordCredential pcv = this.getPcv(pcvId);
            String email = userAttributes.getSingleValue(pcv.getMailAttribute());
            if (!StringUtils.isEmpty((String)email)) {
                String name = userAttributes.getSingleValue(pcv.getNameAttribute());
                if (StringUtils.isEmpty((String)name)) {
                    name = username;
                }
                if (status != null) {
                    NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                    if (status.equals("Success")) {
                        notificationSupportHelper.sendAccountUnlockComplete(email, name, this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getAccountUnlockEmailNotificationTemplate(), templateParams);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Account unlock success email queued to be sent to " + name + " at " + email));
                        }
                    }
                }
            } else {
                logger.error((Object)("Could not send unlock completion email; no email address found in directory for user: " + LogGuard.encode((String)username)));
            }
        } else {
            logger.error((Object)("No user attributes are found for the user: " + LogGuard.encode((String)username)));
        }
    }

    public static enum AccountUnlockSuccessAction {
        Continue,
        Reset,
        Cancel;

    }
}

