/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.model.ApiInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.base64url.Base64;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;
import org.sourceid.util.json.JsonUtils;

public class ApiHelper {
    private static final Log logger = LogFactory.getLog(ApiHelper.class);
    protected PasswordResetConfiguration configuration;

    public ApiHelper(PasswordResetConfiguration configuration) {
        this.configuration = configuration;
    }

    public ApiInfo getUserDetails(String pingIdUsername) {
        if (pingIdUsername == null || pingIdUsername.isEmpty()) {
            logger.debug((Object)"No PingId username found in getuserDetails");
            return null;
        }
        String requestToken = this.buildRequestToken(pingIdUsername);
        String pingIDGetUserPath = this.configuration.getPingIdAdminUrl() + "/rest/4/getuserdetails/do";
        return this.callApi(pingIDGetUserPath, requestToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiInfo callApi(String pingIdUrl, String requestToken) {
        ApiInfo returnInfo = new ApiInfo();
        HttpURLConnection urlConnection = null;
        try {
            String stringJWS;
            URL restUrl = new URL(pingIdUrl);
            urlConnection = (HttpURLConnection)restUrl.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.addRequestProperty("Content-Type", "application/json");
            urlConnection.addRequestProperty("Accept", "*/*");
            urlConnection.setDoOutput(true);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                outputStreamWriter.write(requestToken);
                outputStreamWriter.flush();
            }
            int responseCode = urlConnection.getResponseCode();
            logger.debug((Object)("Ping API call to: " + pingIdUrl + " returned status: " + responseCode));
            try (InputStream is = responseCode >= 400 ? urlConnection.getErrorStream() : urlConnection.getInputStream();){
                stringJWS = IOUtils.toString((InputStream)is, (String)urlConnection.getContentEncoding());
                returnInfo.setSuccess(responseCode == 200);
            }
            urlConnection.disconnect();
            Map<String, Object> responsePayload = this.parseResponse(stringJWS);
            returnInfo.setPayload(responsePayload);
            if (responsePayload != null) {
                returnInfo.setErrorId(((Integer)responsePayload.get("errorId")).intValue());
                returnInfo.setErrorMessage((String)responsePayload.get("errorMsg"));
                returnInfo.setMessageId((String)responsePayload.get("uniqueMsgId"));
                if (returnInfo.getErrorId() != 200L) {
                    returnInfo.setSuccess(false);
                }
                logger.debug((Object)("errorId: " + responsePayload.get("errorId")));
            } else {
                logger.error((Object)("Could not parse JWS result from call to: " + pingIdUrl));
                returnInfo.setErrorId(500L);
                returnInfo.setErrorMessage("Could not parse JWS");
                returnInfo.setSuccess(false);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error calling: " + pingIdUrl), (Throwable)e);
            returnInfo.setResponseCode(500);
            returnInfo.setSuccess(false);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return returnInfo;
    }

    private String buildRequestToken(Object pingIdUsername) {
        Map<String, Object> requestHeader = this.buildRequestHeader();
        Map<String, Object> requestBody = this.buildRequestBody(pingIdUsername);
        HashMap<String, Map<String, Object>> payload = new HashMap<String, Map<String, Object>>();
        payload.put("reqHeader", requestHeader);
        payload.put("reqBody", requestBody);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("HS256");
        jws.setHeader("org_alias", this.configuration.getPingIdOrgAlias());
        jws.setHeader("token", this.configuration.getPingIdToken());
        try {
            jws.setPayload(JsonUtils.getInstance().writeValueAsString(payload));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("JSON String payload creation failed", e);
        }
        HmacKey key = new HmacKey(Base64.decode((String)this.configuration.getPingIdBase64Key()));
        jws.setKey((Key)key);
        String jwsCompactSerialization = null;
        try {
            jwsCompactSerialization = jws.getCompactSerialization();
        }
        catch (JoseException e) {
            logger.error((Object)"Error compacting JWS", (Throwable)e);
        }
        return jwsCompactSerialization;
    }

    private Map<String, Object> buildRequestHeader() {
        SimpleDateFormat PINGID_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        HashMap<String, Object> reqHeader = new HashMap<String, Object>();
        reqHeader.put("locale", "en");
        reqHeader.put("orgAlias", this.configuration.getPingIdOrgAlias());
        reqHeader.put("secretKey", this.configuration.getPingIdToken());
        reqHeader.put("timestamp", PINGID_DATE_FORMAT.format(new Date()));
        reqHeader.put("version", "4.9");
        return reqHeader;
    }

    private Map<String, Object> buildRequestBody(Object pingIdUsername) {
        HashMap<String, Object> reqBody = new HashMap<String, Object>();
        reqBody.put("getSameDeviceUsers", false);
        reqBody.put("userName", pingIdUsername);
        return reqBody;
    }

    private Map<String, Object> parseResponse(String stringJWS) {
        String payload = stringJWS;
        JsonNode responsePayloadJSON = null;
        try {
            if (!stringJWS.startsWith("{")) {
                JsonWebSignature responseJWS = new JsonWebSignature();
                responseJWS.setCompactSerialization(stringJWS);
                HmacKey key = new HmacKey(Base64.decode((String)this.configuration.getPingIdBase64Key()));
                responseJWS.setKey((Key)key);
                payload = responseJWS.getPayload();
            }
            if ((responsePayloadJSON = JsonUtils.getInstance().readTree(payload)).has("responseBody")) {
                responsePayloadJSON = responsePayloadJSON.get("responseBody");
            }
        }
        catch (JsonProcessingException | JoseException e) {
            logger.error((Object)"Error parsing processing API response", e);
        }
        return JsonUtils.getInstance().toMap(responsePayloadJSON);
    }
}

