/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.type.BaseResult;
import com.pingidentity.adapters.htmlform.pwdreset.util.PwdResetAuditLogger;
import com.pingidentity.common.util.CodeGenerationUtil;
import com.pingidentity.common.util.TimeUtil;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.templates.mgmt.TemplateParamUtil;
import java.text.ParseException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.log.AttributeMap;

public class BaseHandler {
    private static final Log logger = LogFactory.getLog(BaseHandler.class);
    protected PasswordResetConfiguration configuration;
    protected final HttpServletRequest servletRequest;
    protected final HttpServletResponse servletResponse;
    protected final PasswordResetSessionState sessionState;

    public BaseHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        this.configuration = configuration;
        this.servletRequest = request;
        this.servletResponse = response;
        this.sessionState = PasswordResetSessionState.get(this.servletRequest, this.servletResponse);
    }

    protected PasswordResetSessionState getSessionState() {
        return this.sessionState;
    }

    protected BaseResult validateCode(String username, String securityCode, AttributeMap userAttributes, HttpServletRequest request, HttpServletResponse response) {
        String code = userAttributes.getSingleValue("prCodeMapCode");
        if (code != null && code.length() > 0) {
            if (CodeGenerationUtil.isExpectedPassword((char[])securityCode.toCharArray(), (String)code)) {
                logger.debug((Object)"Code Successfully Validated");
                return this.handleExpiredRequest(userAttributes);
            }
            logger.debug((Object)"Invalid Code");
            int attemptCount = this.incrementCodeAttemptCount(username);
            if (attemptCount >= this.configuration.getNumInvalidAttempts()) {
                logger.debug((Object)"Too many invalid attempts");
                return BaseResult.TooManyAttempts;
            }
            return BaseResult.InvalidCode;
        }
        logger.error((Object)"Code attribute missing");
        PwdResetAuditLogger.setDescription((String)"Code attribute missing");
        return BaseResult.Error;
    }

    protected BaseResult handleExpiredRequest(AttributeMap userAttributes) {
        boolean isExpired;
        if ("OTL".equals(this.configuration.getResetType())) {
            AttributeValue expTimeAttr = (AttributeValue)userAttributes.get((Object)"prExpTime");
            if (expTimeAttr == null) {
                logger.debug((Object)"Unable to obtain expiration time from OTL user attributes.");
                return BaseResult.CodeExpired;
            }
            long expTime = Long.parseLong(expTimeAttr.getValue());
            isExpired = expTime < System.currentTimeMillis();
        } else {
            Date creationTime = this.getCreationTime(userAttributes);
            isExpired = this.isExpired(creationTime);
        }
        if (isExpired) {
            logger.debug((Object)"Password Reset request has expired");
            return BaseResult.CodeExpired;
        }
        logger.debug((Object)"Password Reset request is valid");
        return BaseResult.Success;
    }

    Date getCreationTime(AttributeMap userAttributes) {
        Date creationTime;
        try {
            creationTime = TimeUtil.decodeGeneralizedTime((String)userAttributes.getSingleValue("prCodeMapTime"));
        }
        catch (ParseException e) {
            logger.error((Object)"Error parsing Date for stored expiration, returning expired", (Throwable)e);
            return null;
        }
        return creationTime;
    }

    protected boolean isExpired(AttributeMap userAttributes) {
        Date createDate = this.getCreationTime(userAttributes);
        return this.isExpired(createDate);
    }

    protected boolean isExpired(Date createDate) {
        Date now = new Date();
        long result = now.getTime() / 60000L - createDate.getTime() / 60000L;
        logger.debug((Object)("Number of minutes since token was generated: " + result));
        return result > (long)this.configuration.getExpirationMinutes();
    }

    protected AttributeMap getCodeAttributeMap() {
        return this.getSessionState().getCodeAttributeMap();
    }

    protected AttributeMap getAttributes(String username, String pcvId) {
        try {
            ResettablePasswordCredential pcv = (ResettablePasswordCredential)MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
            AttributeMap attributeMap = pcv.findUser(username);
            this.getSessionState().setUserAttributes(TemplateParamUtil.convertAttributeMapToTemplateParams((AttributeMap)attributeMap));
            return attributeMap;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("User not found")) {
                logger.error((Object)("Error retrieving user attributes. " + e.getMessage()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e.toString(), (Throwable)e);
                }
            } else {
                logger.error((Object)("Error retrieving user attributes. " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    protected int incrementCodeAttemptCount(String username) {
        int count = this.getSessionState().incrementCodeAttemptCount();
        logger.debug((Object)("Number of invalid attempts for " + username + " is " + count));
        return count;
    }

    protected ResettablePasswordCredential getPcv(String pcvId) {
        return (ResettablePasswordCredential)MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
    }
}

