/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.handler.ApiHelper;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.ApiInfo;
import com.pingidentity.adapters.htmlform.pwdreset.model.PingIDForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.PingIDResult;
import com.pingidentity.crypto.SecurityProviderUtil;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.bindings.FormPost;
import shaded.pingid.com.pingone.common.mfa.domain.PPMAttribute;
import shaded.pingid.com.pingone.common.mfa.domain.PPMRequest;
import shaded.pingid.com.pingone.common.mfa.domain.PPMResponse;
import shaded.pingid.com.pingone.common.mfa.jwt.JwtHmacUtil;
import shaded.pingid.com.pingone.common.mfa.jwt.JwtResult;
import shaded.pingid.org.jose4j.jwk.OctetSequenceJsonWebKey;
import shaded.pingid.org.jose4j.lang.JoseException;

public class PingIDHandler
extends BaseHandler {
    private static Log logger = LogFactory.getLog(PingIDHandler.class);
    private static final int REQUEST_ID_LENGTH = 20;
    private static final char[] REQUEST_ID_ALLOWED_CHARACTERS = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private ApiHelper apiHelper;

    public PingIDHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
        this.apiHelper = new ApiHelper(configuration);
    }

    public PingIDResult validatePingID(PingIDForm pingIdForm) {
        PPMResponse ppmResponse;
        AttributeMap codeAttributes = this.getCodeAttributeMap();
        if (codeAttributes == null) {
            logger.debug((Object)"No code session attributes found");
            return PingIDResult.Error;
        }
        if (this.isExpired(codeAttributes)) {
            logger.debug((Object)"Token has expired");
            return PingIDResult.Expired;
        }
        if (pingIdForm.getPpmResponse() == null) {
            logger.error((Object)"No ppm response from Authenticator");
            return PingIDResult.AuthFailed;
        }
        try {
            ppmResponse = this.getPPMResponse(pingIdForm.getPpmResponse());
        }
        catch (JoseException e) {
            logger.error((Object)"Error reading ppm response from Authenticator", (Throwable)e);
            return PingIDResult.AuthFailed;
        }
        if (!"success".equalsIgnoreCase(ppmResponse.getStatus().trim())) {
            logger.debug((Object)("Authenticator status failed (error code: " + ppmResponse.getErrorCode() + ", message: " + ppmResponse.getMessage() + ")"));
            if ("20516".equals(ppmResponse.getErrorCode().trim())) {
                return PingIDResult.Canceled;
            }
            return PingIDResult.AuthFailed;
        }
        String savedNonce = this.getSessionState().getPingIdNonce();
        if (savedNonce == null || !savedNonce.equals(ppmResponse.getNonce())) {
            logger.error((Object)"Authenticator response id does not match request id");
            return PingIDResult.AuthFailed;
        }
        logger.debug((Object)"PingID Code Successfully Validated");
        return PingIDResult.Success;
    }

    public String getPingUserId(String username, String pcvId) {
        String pingIdUsername = null;
        AttributeMap userAttrs = this.getAttributes(username, pcvId);
        if (userAttrs != null) {
            ResettablePasswordCredential pcv = this.getPcv(pcvId);
            pingIdUsername = userAttrs.getSingleValue(pcv.getPingIdUsernameAttribute());
        }
        logger.debug((Object)("PingID username (for user: " + username + ") is: " + pingIdUsername));
        return pingIdUsername;
    }

    public boolean isActiveForAuthentication(String pingIdUsername) {
        boolean active;
        Map userDetails;
        String status = "";
        ApiInfo apiInfo = this.apiHelper.getUserDetails(pingIdUsername);
        if (apiInfo.isSuccess() && apiInfo.getPayload() != null && apiInfo.getPayload().containsKey("userDetails") && (userDetails = (Map)apiInfo.getPayload().get("userDetails")) != null) {
            status = (String)userDetails.get("status");
        }
        if (!(active = "ACTIVE".equalsIgnoreCase(status))) {
            logger.debug((Object)("Status for PingId user " + pingIdUsername + ": " + status));
        }
        return active;
    }

    public void sendAuthRequest(String pingIdUsername, String returnUrl, HttpServletRequest request, HttpServletResponse response) throws JoseException, IOException, Exception {
        if (pingIdUsername == null || pingIdUsername.length() == 0) {
            throw new Exception("No PingID username provided");
        }
        PPMRequest ppmRequest = this.generatePPMRequest(pingIdUsername, returnUrl);
        this.getSessionState().setPingIdNonce(ppmRequest.getNonce());
        ArrayList<PPMAttribute> additionalAttributes = new ArrayList<PPMAttribute>();
        additionalAttributes.add(new PPMAttribute("isUserAuthenticated", Boolean.toString(true)));
        additionalAttributes.add(new PPMAttribute("saasid", "com.pingidentity.pf.passwordreset"));
        ppmRequest.setAttributes(additionalAttributes);
        String jwtToken = this.createToken(ppmRequest.toJson());
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("idp_account_id", this.configuration.getPingIdOrgAlias());
        postParams.put("ppm_request", jwtToken);
        String pingIDAuthenticatorPath = this.configuration.getPingIdAuthenticatorUrl() + "/auth";
        FormPost.post((String)pingIDAuthenticatorPath, postParams, (HttpServletResponse)response);
    }

    private String createToken(String payload) throws JoseException {
        OctetSequenceJsonWebKey hmacKey = JwtHmacUtil.pingidKeyToWebKey((String)this.configuration.getPingIdBase64Key());
        String jwt = JwtHmacUtil.sign((String)payload, (OctetSequenceJsonWebKey)hmacKey);
        return jwt;
    }

    private PPMRequest generatePPMRequest(String username, String returnUrl) {
        String requestId = this.generateRequestId();
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, this.configuration.getExpirationMinutes());
        PPMRequest ppmRequest = new PPMRequest();
        ppmRequest.setIdpAccountId(this.configuration.getPingIdOrgAlias());
        ppmRequest.setReturnUrl(returnUrl);
        ppmRequest.setSub(username);
        ppmRequest.setJti("");
        ppmRequest.setNonce(requestId);
        ppmRequest.setIss("");
        ppmRequest.setAud("pingidauthenticator");
        ppmRequest.setIat(date.getTime());
        ppmRequest.setExp(cal.getTime().getTime());
        return ppmRequest;
    }

    private PPMResponse getPPMResponse(String payload) throws JoseException {
        OctetSequenceJsonWebKey hmacKey = JwtHmacUtil.pingidKeyToWebKey((String)this.configuration.getPingIdBase64Key());
        JwtResult jwt = JwtHmacUtil.verifySignature((String)payload, (OctetSequenceJsonWebKey)hmacKey);
        PPMResponse ppmResponse = PPMResponse.fromJson((String)jwt.getPayload());
        return ppmResponse;
    }

    private String generateRequestId() {
        SecureRandom random = SecurityProviderUtil.getSecureRandom();
        char[] chars = new char[20];
        for (int i = 0; i < 20; ++i) {
            int rnd = random.nextInt(REQUEST_ID_ALLOWED_CHARACTERS.length);
            chars[i] = REQUEST_ID_ALLOWED_CHARACTERS[rnd];
        }
        return new String(chars);
    }
}

