/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.htmlform.pwdreset.handler;

import com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapterUtils;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetConfiguration;
import com.pingidentity.adapters.htmlform.pwdreset.common.PasswordResetSessionState;
import com.pingidentity.adapters.htmlform.pwdreset.handler.BaseHandler;
import com.pingidentity.adapters.htmlform.pwdreset.model.ResetForm;
import com.pingidentity.adapters.htmlform.pwdreset.type.BaseResult;
import com.pingidentity.adapters.htmlform.pwdreset.type.ResetResult;
import com.pingidentity.adapters.htmlform.render.TemplateKey;
import com.pingidentity.common.util.LogGuard;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.password.PasswordCredentialValidator;
import com.pingidentity.sdk.password.PasswordResetException;
import com.pingidentity.sdk.password.PasswordValidationException;
import com.pingidentity.sdk.password.ResettablePasswordCredential;
import com.pingidentity.sdk.session.SessionManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AssertionReplayPreventionService;
import org.sourceid.saml20.service.BearerAssertionReplayPreventionServiceException;
import org.sourceid.saml20.state.StateMgmtFactory;
import org.sourceid.saml20.util.UserKeyAttributeUtil;
import org.sourceid.util.log.AttributeMap;

public class ResetHandler
extends BaseHandler {
    private static Log logger = LogFactory.getLog(ResetHandler.class);

    public ResetHandler(PasswordResetConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        super(configuration, request, response);
    }

    public ResetResult resetPassword(ResetForm resetForm, HttpServletRequest request, HttpServletResponse response) throws PasswordResetException {
        if (!resetForm.isSubmit()) {
            logger.debug((Object)"Form was not submitted");
            return ResetResult.Cancel;
        }
        boolean isPasswordUpdateTimedOut = this.getSessionState().isPasswordUpdateSessionExpired(this.configuration.getPasswordUpdateTimeout());
        if (isPasswordUpdateTimedOut) {
            logger.debug((Object)"Password update timed out.");
            return ResetResult.PasswordUpdateTimedOut;
        }
        PasswordResetSessionState sessionState = this.getSessionState();
        String username = sessionState.getUsername();
        if (StringUtils.isEmpty((String)resetForm.getNewPassword())) {
            logger.debug((Object)"No New Password was found in the form data");
            return ResetResult.NoNewPassword;
        }
        if (StringUtils.isEmpty((String)resetForm.getConfirmPassword())) {
            logger.debug((Object)"No Confirm Password was found in the form data");
            return ResetResult.NoConfirmPassword;
        }
        if (!resetForm.getNewPassword().equals(resetForm.getConfirmPassword())) {
            logger.debug((Object)"New and Confirm Passwords do not match");
            return ResetResult.PasswordMismatch;
        }
        AttributeMap userAttributes = this.getCodeAttributeMap();
        if (userAttributes == null) {
            logger.debug((Object)"No code session attributes found");
            return ResetResult.Error;
        }
        BaseResult expiryResult = this.handleExpiredRequest(userAttributes);
        if (BaseResult.CodeExpired.equals((Object)expiryResult)) {
            return ResetResult.Expired;
        }
        String pcvId = this.getSessionState().getPcvId();
        ResetResult result = this.resetPassword(username, resetForm.getNewPassword(), pcvId);
        Locale locale = LocaleUtil.getUserLocale((HttpServletRequest)request);
        if (ResetResult.Success.equals((Object)result)) {
            String idpAdapterId = this.configuration.getAdapterId();
            if (HtmlFormIdpAuthnAdapterUtils.isRevokeSessionAfterPasswordChangeOrReset(idpAdapterId)) {
                this.handleRevokeSessionsAfterPasswordReset(resetForm, request, response, username, pcvId, idpAdapterId);
            }
            if ("OTL".equals(this.configuration.getResetType())) {
                this.addToReplayPrevention(userAttributes.getSingleValue("prCodeMapCode"), new Date(Long.parseLong(((AttributeValue)userAttributes.get((Object)"prExpTime")).getValue())), username);
            }
            this.sendCompletionNotice(sessionState, "Success", pcvId, locale);
        } else if (!ResetResult.PasswordConstraintViolation.equals((Object)result)) {
            this.sendCompletionNotice(sessionState, "Failed", pcvId, locale);
        }
        return result;
    }

    private void handleRevokeSessionsAfterPasswordReset(ResetForm resetForm, HttpServletRequest request, HttpServletResponse response, String username, String pcvId, String idpAdapterId) {
        AttributeMap attributeMap = null;
        PasswordCredentialValidator pcv = MgmtFactory.getCredentialValidatorManager().getValidator(pcvId);
        try {
            attributeMap = pcv.processPasswordCredential(username, resetForm.getNewPassword());
        }
        catch (PasswordValidationException e) {
            logger.error((Object)"Unable to validate username and new password to proceed with session revocation after successful password reset.", (Throwable)e);
        }
        if (attributeMap != null) {
            IdpAuthnAdapterInstance idpAuthnAdapterInstance = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(idpAdapterId);
            if (idpAuthnAdapterInstance != null) {
                AdapterAuthnSourceKey adapterAuthnSourceKey = idpAuthnAdapterInstance.getAdapterAuthnSourceKey();
                String uniqueUserKeyValue = null;
                try {
                    uniqueUserKeyValue = UserKeyAttributeUtil.getUniqueUserKeyValue((AdapterAuthnSourceKey)adapterAuthnSourceKey, (Map)attributeMap, (HttpServletRequest)request);
                }
                catch (AuthnAdapterException | AuthorizationException e) {
                    logger.error((Object)"Unable to get unique user key to proceed with session revocation after successful password reset.", e);
                }
                if (uniqueUserKeyValue != null) {
                    SessionManager sessionManager = new SessionManager();
                    sessionManager.revokeOtherSessionsFor(uniqueUserKeyValue, request, response);
                }
            } else {
                logger.error((Object)("Unable to revoke session after password reset, because adapter with ID '" + idpAdapterId + "' not found."));
            }
        }
    }

    private ResetResult resetPassword(String username, String password, String pcvId) throws PasswordResetException {
        ResettablePasswordCredential pcv = null;
        try {
            pcv = this.getPcv(pcvId);
            pcv.resetPassword(username, password);
            return ResetResult.Success;
        }
        catch (PasswordResetException e) {
            if (e.isRecoverable()) {
                throw e;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error resetting password for: " + LogGuard.encode((String)username) + " [" + e.toString() + "]"), (Throwable)e);
            }
            return ResetResult.Error;
        }
        catch (Exception e) {
            logger.error((Object)("Error resetting password for: " + LogGuard.encode((String)username)), (Throwable)e);
            return ResetResult.Error;
        }
    }

    private void addToReplayPrevention(String code, Date expirationTime, String username) throws PasswordResetException {
        try {
            Calendar expiration = Util.getUtcCalendar();
            expiration.setTimeInMillis(expirationTime.getTime());
            AssertionReplayPreventionService replaySvc = StateMgmtFactory.getBearerAssertionReplayPreventionSvc();
            replaySvc.isReplay(code, expiration);
        }
        catch (BearerAssertionReplayPreventionServiceException e) {
            throw new PasswordResetException(false, "Unable to perform replay check on the password reset code: '" + code + "' for username: " + username, (Throwable)e);
        }
    }

    private void sendCompletionNotice(PasswordResetSessionState sessionState, String status, String pcvId, Locale locale) {
        ResettablePasswordCredential pcv = this.getPcv(pcvId);
        String username = sessionState.getUsername();
        AttributeMap userAttributes = this.getAttributes(username, pcvId);
        String email = null;
        Map<String, Object> templateData = this.getSessionState().getDefaultTemplateParams();
        templateData.put(TemplateKey.USER_ATTRIBUTES.getKey(), this.getSessionState().getUserAttributes());
        if (userAttributes != null) {
            email = userAttributes.getSingleValue(pcv.getMailAttribute());
        }
        if (!StringUtils.isEmpty(email)) {
            String name = userAttributes.getSingleValue(pcv.getNameAttribute());
            if (StringUtils.isEmpty((String)name)) {
                name = username;
            }
            if (status != null) {
                boolean isEmailVerified;
                boolean bl = isEmailVerified = this.configuration.isRequireVerifiedEmail() ? Boolean.valueOf(userAttributes.getSingleValue(pcv.getMailVerifiedAttribute())) : true;
                if (isEmailVerified) {
                    NotificationSupportHelper notificationSupportHelper = new NotificationSupportHelper();
                    if (status.equals("Success")) {
                        notificationSupportHelper.sendPasswordResetComplete(email, name, status, this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getPwdResetCompleteEmailNotificationTemplate(), templateData);
                    } else if (status.equals("Failed")) {
                        notificationSupportHelper.sendPasswordResetFailed(email, name, this.configuration.getAdapterId(), pcvId, locale, this.configuration.getNotificationPublisherId(), this.configuration.getPwdResetFailureEmailNotificationTemplate(), templateData);
                    }
                    if ((status.equals("Success") || status.equals("Failed")) && logger.isDebugEnabled()) {
                        logger.debug((Object)("Password reset '" + status + "' email queued to be sent to " + name + " at " + email));
                    }
                } else {
                    logger.error((Object)("Could not send completion email; email address found but it is unverified in directory for user: " + LogGuard.encode((String)username)));
                }
            }
        } else {
            logger.error((Object)("Could not send completion email; no email address found in directory for user: " + LogGuard.encode((String)username)));
        }
    }
}

